/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackend;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendFiles;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageV1;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorage {
    private static final ObjectPath ROOT_PATH = ObjectPath.create((String)"", (ObjectKind)ObjectKind.ROOT);
    public static final String STORAGE_SUBDIR = "storage_v2";
    private final String myProjectId;
    private final String myDataSourceId;
    private final DbSrcBackend myBackend;
    private final AtomicReference<Set<ObjectPath>> myDirtyDirs;
    private final AtomicReference<Set<ObjectPath>> myDirtyDirsRec;
    private final AtomicReference<Set<ObjectPath>> myDirtySrc;
    private final Alarm myFlusher;
    private final boolean myCheckSanity;

    public DbSrcStorage(@Nullable Project project, @NotNull String rootPath, @NotNull String dataSourceId) {
        if (rootPath == null) {
            DbSrcStorage.$$$reportNull$$$0(0);
        }
        if (dataSourceId == null) {
            DbSrcStorage.$$$reportNull$$$0(1);
        }
        this.myDirtyDirs = new AtomicReference<Set>(ContainerUtil.newConcurrentSet());
        this.myDirtyDirsRec = new AtomicReference<Set>(ContainerUtil.newConcurrentSet());
        this.myDirtySrc = new AtomicReference<Set>(ContainerUtil.newConcurrentSet());
        this.myCheckSanity = ApplicationManager.getApplication().isUnitTestMode();
        this.myProjectId = DbSrcUtils.getProjectId(project);
        this.myFlusher = AlarmFactory.getInstance().create(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)(project == null ? ApplicationManager.getApplication() : project));
        this.myDataSourceId = dataSourceId;
        this.myBackend = new DbSrcBackend(rootPath + File.separator + dataSourceId + File.separator + STORAGE_SUBDIR, new DbSrcBackend.Listener(){

            @Override
            public void fileChanged(@NotNull ObjectPath object, boolean staging) {
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((Set)DbSrcStorage.this.myDirtySrc.get()).add(object)) {
                    this.scheduleFlush();
                }
            }

            @Override
            public void dirChanged(@Nullable ObjectPath object, boolean staging, boolean recursive) {
                if (((Set)(recursive ? DbSrcStorage.this.myDirtyDirsRec : DbSrcStorage.this.myDirtyDirs).get()).add(ObjectUtils.chooseNotNull((Object)object, (Object)ROOT_PATH))) {
                    this.scheduleFlush();
                }
            }

            private void scheduleFlush() {
                if (DbSrcStorage.this.myFlusher.isDisposed()) {
                    return;
                }
                DbSrcStorage.this.myFlusher.cancelAllRequests();
                DbSrcStorage.this.myFlusher.addRequest(() -> DbSrcStorage.this.flushToFs(false), 800);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorage$1", "fileChanged"));
            }
        });
    }

    public boolean migrate(@NotNull DasModel model) {
        String v1Path;
        if (model == null) {
            DbSrcStorage.$$$reportNull$$$0(2);
        }
        if (DbSrcStorageV1.exists(v1Path = StringUtil.trimEnd((String)this.myBackend.getRoot(), (String)(File.separator + STORAGE_SUBDIR)))) {
            try {
                DbSrcStorageV1.migrate(this, v1Path, model);
                this.flushToFs(false);
                DbSrcStorageV1.LOG.info("Migrated storage for " + this.myDataSourceId);
                FileUtil.createDirectory((File)new File(this.myBackend.getRoot()));
            }
            catch (Throwable e) {
                DbSrcStorageV1.LOG.warn(e);
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getDataSourceId() {
        String string = this.myDataSourceId;
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean hasGroup(@Nullable ObjectPath object, @NotNull ObjectKind group2) {
        if (group2 == null) {
            DbSrcStorage.$$$reportNull$$$0(4);
        }
        return this.myBackend.hasGroup(object, group2, false) || this.myBackend.hasGroup(object, group2, true);
    }

    public boolean hasChildren(@Nullable ObjectPath object) {
        return this.myBackend.hasChildren(object, false) || this.myBackend.hasChildren(object, true);
    }

    @Nullable
    public FileAttributes getSrcAttributes(@NotNull ObjectPath object, boolean original, boolean force) {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(5);
        }
        if (original) {
            if (!force && this.myBackend.getSrcAttributes(object, true) == null) {
                return null;
            }
            return DbSrcStorage.overrideWritable(this.myBackend.getSrcAttributes(object, false), false);
        }
        FileAttributes baseAttrs = this.myBackend.getSrcAttributes(object, false);
        FileAttributes attrs = this.myBackend.getSrcAttributes(object, true);
        if (attrs == null || baseAttrs == null) {
            return attrs == null ? DbSrcStorage.overrideWritable(baseAttrs, true) : attrs;
        }
        return attrs;
    }

    @NotNull
    public Iterable<ObjectKind> listGroups(@Nullable ObjectPath object) {
        Set set = JBIterable.from(this.myBackend.listGroups(object, false)).append(this.myBackend.listGroups(object, true)).toSet();
        if (set == null) {
            DbSrcStorage.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Nullable
    public Trinity<Collection<ObjectPath>, List<ObjectPath>, List<ObjectPath>> list(@Nullable ObjectPath object, @NotNull ObjectKind group2) {
        if (group2 == null) {
            DbSrcStorage.$$$reportNull$$$0(7);
        }
        Pair<List<ObjectPath>, List<ObjectPath>> b2 = this.myBackend.list(object, group2, false);
        Pair<List<ObjectPath>, List<ObjectPath>> s = this.myBackend.list(object, group2, true);
        if (b2 == null && s == null) {
            return null;
        }
        return Trinity.create(DbSrcStorage.cheapConcat((List)Pair.getFirst(b2), (List)Pair.getFirst(s)), (Object)(b2 == null ? Collections.emptyList() : (List)b2.second), s == null ? Collections.emptyList() : (List)s.second);
    }

    public void putContent(@NotNull ObjectPath object, @Nullable byte[] content) throws IOException {
        boolean differs;
        DbSrcStorageDsMetadata.MetaData metaData;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(8);
        }
        if ((metaData = this.myBackend.getMetaData(object)) == null) {
            metaData = DbSrcStorageDsMetadata.MetaData.EMPTY;
        }
        int hc = metaData.contentHash == 0 ? 0 : DbSrcUtils.StringHashBuilder.hashStep(0, content);
        boolean bl = differs = content == null || !this.myCheckSanity && hc != metaData.contentHash;
        if (!differs) {
            try (InputStream stream = this.myBackend.getContentInputStream(object, false);){
                boolean bl2 = differs = stream == null;
                if (!differs) {
                    differs = DbSrcUtils.contentDiffers(stream, content);
                    if (this.myCheckSanity && hc != metaData.contentHash && !differs) {
                        throw new AssertionError((Object)"wrong hash code stored");
                    }
                }
            }
            catch (FileNotFoundException e) {
                differs = true;
            }
        }
        if (!differs) {
            content = null;
        }
        this.putContentOrRemove(object, true, content, null);
    }

    private void putContentOrRemove(@NotNull ObjectPath object, boolean staging, @Nullable byte[] content, @Nullable DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(9);
        }
        if (content == null && !this.myBackend.hasChildren(object, staging) && DbSrcStorageDsMetadata.MetaData.isEmpty(metaData)) {
            this.myBackend.dropObject(object, staging);
        } else {
            this.myBackend.putContent(object, staging, content, metaData);
        }
    }

    public void setTimestamp(@NotNull ObjectPath object, boolean staging, long timestamp) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(10);
        }
        this.myBackend.setTimestamp(object, staging, timestamp);
    }

    public void dropObject(@NotNull ObjectPath object, boolean original) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(11);
        }
        this.myBackend.dropObject(object, !original);
    }

    public void putOriginalContent(@NotNull ObjectPath object, @Nullable byte[] content, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        block30: {
            boolean shouldExist;
            if (object == null) {
                DbSrcStorage.$$$reportNull$$$0(12);
            }
            if (metaData == null) {
                DbSrcStorage.$$$reportNull$$$0(13);
            }
            int hash = content == null ? 0 : DbSrcUtils.StringHashBuilder.hashStep(0, content);
            DbSrcStorageDsMetadata.MetaData curMetaData = this.myBackend.getMetaData(object);
            DbSrcStorageDsMetadata.MetaData newMetaData = new DbSrcStorageDsMetadata.MetaData(metaData.srcVersion, hash, metaData.offsets, metaData.kinds, metaData.introContentVersion, metaData.genContentVersion);
            boolean looksSimilar = newMetaData.equals(curMetaData);
            boolean exists = this.myBackend.getSrcAttributes(object, false) != null;
            boolean bl = shouldExist = content != null;
            if (looksSimilar && exists == shouldExist) {
                return;
            }
            try (DbSrcBackendFiles.Locker lock = this.myBackend.writeLock();){
                boolean differs;
                this.putContentOrRemove(object, false, content, newMetaData);
                if (content == null) break block30;
                try (InputStream stream = this.myBackend.getContentInputStream(object, true);){
                    differs = stream == null || DbSrcUtils.contentDiffers(stream, content);
                }
                catch (FileNotFoundException ignore) {
                    differs = true;
                }
                if (!differs) {
                    this.putContentOrRemove(object, true, null, null);
                }
            }
        }
    }

    @Nullable
    public OutputStream getContentOutputStream(final @NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(14);
        }
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    DbSrcStorage.this.putContent(object, this.toByteArray());
                }
            }
        };
    }

    public void putMetaData(@NotNull ObjectPath path, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (path == null) {
            DbSrcStorage.$$$reportNull$$$0(15);
        }
        if (metaData == null) {
            DbSrcStorage.$$$reportNull$$$0(16);
        }
        this.myBackend.putMetaData(path, false, metaData);
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull ObjectPath path) {
        if (path == null) {
            DbSrcStorage.$$$reportNull$$$0(17);
        }
        return this.myBackend.getMetaData(path);
    }

    @NotNull
    public String getRoot() {
        String string = this.myBackend.getRoot();
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public byte[] getContent(@NotNull ObjectPath object, boolean original) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(19);
        }
        if (original) {
            return this.myBackend.getContent(object, false);
        }
        byte[] content = this.myBackend.getContent(object, true);
        if (content == null) {
            content = this.myBackend.getContent(object, false);
        }
        return content;
    }

    @Nullable
    public InputStream getContentInputStream(@NotNull ObjectPath object, boolean original) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(20);
        }
        if (original) {
            return this.myBackend.getContentInputStream(object, false);
        }
        try {
            InputStream stream = this.myBackend.getContentInputStream(object, true);
            if (stream != null) {
                return stream;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return this.myBackend.getContentInputStream(object, false);
    }

    public void finish() {
        this.myBackend.finish();
    }

    public void drop() {
        this.myBackend.drop();
    }

    public void resetCaches() {
        this.myBackend.resetCaches();
    }

    public DbSrcBackend getBackend() {
        return this.myBackend;
    }

    public void flushToFs(boolean async) {
        Set<ObjectPath> dirtySrc = this.myDirtySrc.getAndSet(ContainerUtil.newConcurrentSet());
        Set<ObjectPath> dirtyDirs = this.myDirtyDirs.getAndSet(ContainerUtil.newConcurrentSet());
        Set<ObjectPath> dirtyDirsRec = this.myDirtyDirsRec.getAndSet(ContainerUtil.newConcurrentSet());
        DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
        HashSet<Object> needSynchronise = new HashSet<Object>();
        for (ObjectPath path : dirtySrc) {
            for (int i2 = 0; i2 < 2; ++i2) {
                NewVirtualFile p2;
                Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)this.getPath(path, i2 == 0 ? DbSrcFileSystem.ItemType.SRC : DbSrcFileSystem.ItemType.ORIG));
                VirtualFile vfile = (VirtualFile)ObjectUtils.chooseNotNull((Object)cached.first, (Object)cached.second);
                if (vfile == null || !needSynchronise.add(vfile)) continue;
                boolean recursive = cached.first == null;
                VfsUtil.markDirty((boolean)recursive, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
                NewVirtualFile newVirtualFile = p2 = cached.first == null ? null : ((NewVirtualFile)cached.first).getParent();
                if (p2 == null || !needSynchronise.add(p2)) continue;
                VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{p2});
            }
        }
        for (int i3 = 0; i3 < 2; ++i3) {
            boolean recursive = i3 == 0;
            for (ObjectPath path : recursive ? dirtyDirsRec : dirtyDirs) {
                if (path == ROOT_PATH) {
                    path = null;
                }
                Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)this.getPath(path, DbSrcFileSystem.ItemType.FOLDER));
                VirtualFile vfile = (VirtualFile)ObjectUtils.chooseNotNull((Object)cached.first, (Object)cached.second);
                if (vfile == null || !needSynchronise.add(vfile)) continue;
                VfsUtil.markDirty((recursive && cached.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
            }
        }
        if (!needSynchronise.isEmpty()) {
            RefreshQueue.getInstance().refresh(async, true, null, needSynchronise);
        }
    }

    @NotNull
    private String getPath(@Nullable ObjectPath path, @NotNull DbSrcFileSystem.ItemType t) {
        if (t == null) {
            DbSrcStorage.$$$reportNull$$$0(21);
        }
        String string = DbSrcFileSystem.getPathFromNormalized(this.myProjectId, this.myDataSourceId, path, t);
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(22);
        }
        return string;
    }

    public void consume(DbSrcStorage src) throws IOException {
        src.myBackend.finish();
        try (DbSrcBackendFiles.Locker lock1 = this.myBackend.writeLock();
             DbSrcBackendFiles.Locker lock2 = src.myBackend.writeLock();){
            this.moveArea(src, false);
            this.moveArea(src, true);
            this.myBackend.resetCaches();
            src.myBackend.drop();
        }
    }

    private void moveArea(DbSrcStorage src, boolean staging) throws IOException {
        this.myBackend.dropObject(null, staging);
        File srcDir = DbSrcBackendUtils.getDir(src.myBackend.getRoot(), staging, null, null, null).toFile();
        File dstDir = DbSrcBackendUtils.getDir(this.myBackend.getRoot(), staging, null, null, null).toFile();
        if (srcDir.exists()) {
            FileUtil.copyDir((File)srcDir, (File)dstDir);
        }
    }

    private static FileAttributes overrideWritable(@Nullable FileAttributes attrs, boolean writable) {
        if (attrs == null || attrs.isWritable() == writable) {
            return attrs;
        }
        return new FileAttributes(attrs.isDirectory(), attrs.isSpecial(), attrs.isSymLink(), attrs.isHidden(), attrs.length, attrs.lastModified, writable);
    }

    private static FileAttributes overrideTimestamp(@Nullable FileAttributes attrs, long timestamp) {
        if (attrs == null || attrs.lastModified == timestamp) {
            return attrs;
        }
        return new FileAttributes(attrs.isDirectory(), attrs.isSpecial(), attrs.isSymLink(), attrs.isHidden(), attrs.length, timestamp, attrs.isWritable());
    }

    @NotNull
    private static <T> Collection<T> cheapConcat(@Nullable List<T> l1, @Nullable List<T> l2) {
        boolean e2;
        boolean e1 = l1 == null || l1.isEmpty();
        boolean bl = e2 = l2 == null || l2.isEmpty();
        if (e1 && e2) {
            Set set = Collections.emptySet();
            if (set == null) {
                DbSrcStorage.$$$reportNull$$$0(23);
            }
            return set;
        }
        if (e1) {
            List<T> list = l2;
            if (list == null) {
                DbSrcStorage.$$$reportNull$$$0(24);
            }
            return list;
        }
        if (e2) {
            List<T> list = l1;
            if (list == null) {
                DbSrcStorage.$$$reportNull$$$0(25);
            }
            return list;
        }
        HashSet<T> res2 = new HashSet<T>();
        res2.addAll(l1);
        res2.addAll(l2);
        HashSet<T> hashSet = res2;
        if (hashSet == null) {
            DbSrcStorage.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    void putContentDirect(@NotNull ObjectPath object, boolean staging, @Nullable byte[] content) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(27);
        }
        this.myBackend.putContent(object, staging, content, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorage";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listGroups";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "cheapConcat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putContentOrRemove";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dropObject";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putOriginalContent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContentOutputStream";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContentInputStream";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putContentDirect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

