/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendFiles;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendZipWriter;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcZipFile;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSrcBackendZipData {
    private static final Logger LOG = Logger.getInstance(DbSrcBackendZipData.class);
    private final THashMap<ObjectPath, DirInfo> myStructure;
    private final THashMap<ObjectPath, FileInfo> myFileStamps;
    private final ObjectPath myRoot;
    private final int myRootDepth;
    private final DbSrcBackendFiles myFiles;
    private final DbSrcBackendZipWriter myWriter;
    private volatile boolean myLoaded;

    public DbSrcBackendZipData(@NotNull String path, @NotNull ObjectPath root2, @NotNull DbSrcBackendFiles files) {
        if (path == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(0);
        }
        if (root2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(1);
        }
        if (files == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(2);
        }
        this.myStructure = new THashMap();
        this.myFileStamps = new THashMap();
        this.myWriter = new DbSrcBackendZipWriter(path, this::scheduleClose);
        this.myRoot = root2;
        this.myRootDepth = ObjectPaths.getLength(root2);
        this.myFiles = files;
        this.myLoaded = !this.myWriter.isExists();
    }

    private void scheduleClose() {
        LazyData.ourCloseQueue.queue(new Update(this, false){

            public void run() {
                if (DbSrcBackendZipData.this.myWriter.canClose()) {
                    DbSrcBackendZipData.this.closeWriter();
                }
            }
        });
    }

    @NotNull
    public ObjectPath getRoot() {
        ObjectPath objectPath = this.myRoot;
        if (objectPath == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(3);
        }
        return objectPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
        synchronized (tHashMap) {
            if (this.myLoaded) {
                return;
            }
            if (!this.myWriter.isExists()) {
                this.myLoaded = true;
                return;
            }
            try (GuardedRef<DbSrcZipFile> zip = this.myWriter.openZip();){
                this.fillStructure(zip.get(), this.extractNamesMapping(zip.get()));
            }
            catch (IOException e) {
                LOG.warn("ZipData build failed", (Throwable)e);
            }
            finally {
                this.myLoaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Pair<List<ObjectPath>, List<ObjectPath>> list(@Nullable ObjectPath object, @NotNull ObjectKind group2) {
        if (group2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(4);
        }
        THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
        synchronized (tHashMap) {
            DirInfo info = this.getDirInfo(object);
            if (info == null) {
                return null;
            }
            Condition filter2 = p2 -> p2.kind == group2;
            return Pair.create((Object)ContainerUtil.filter(info.dirs, (Condition)filter2), (Object)ContainerUtil.filter(info.files, (Condition)filter2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Iterable<ObjectKind> listGroups(@Nullable ObjectPath object) {
        THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
        // MONITORENTER : tHashMap
        DirInfo info = this.getDirInfo(object);
        if (info == null) {
            JBIterable jBIterable = JBIterable.empty();
            // MONITOREXIT : tHashMap
            if (jBIterable != null) return jBIterable;
            DbSrcBackendZipData.$$$reportNull$$$0(5);
            return jBIterable;
        }
        Set set = JBIterable.from(info.dirs).append(info.files).transform(p2 -> p2.kind).toSet();
        // MONITOREXIT : tHashMap
        if (set != null) return set;
        DbSrcBackendZipData.$$$reportNull$$$0(6);
        return set;
    }

    public boolean hasChildren(@Nullable ObjectPath object) {
        DirInfo info = this.getDirInfo(object);
        return info != null && (!info.dirs.isEmpty() || !info.files.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGroup(@Nullable ObjectPath object, @NotNull ObjectKind group2) {
        if (group2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(7);
        }
        THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
        synchronized (tHashMap) {
            DirInfo info = this.getDirInfo(object);
            if (info == null) {
                return false;
            }
            for (ObjectPath dir : info.dirs) {
                if (dir.kind != group2) continue;
                return true;
            }
            for (ObjectPath file : info.files) {
                if (file.kind != group2) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMetaData(@NotNull ObjectPath object, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(8);
        }
        if (metaData == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(9);
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".meta");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
             GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
            byte[] data = DbSrcBackendUtils.serializeMetaData(object, metaData);
            ref.get().putData(path.toString(), data, System.currentTimeMillis(), DbSrcBackendZipData.getDisplayName(object));
            this.myFiles.putMetaDataToCache(object, metaData);
            THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
            synchronized (tHashMap) {
                DirInfo info = this.getOrCreateDirInfo(object.parent);
                if (info != null) {
                    info.dirs.add(object);
                }
            }
        }
        finally {
            this.myFiles.getListener().dirChanged(object, false, false);
            this.myFiles.getListener().fileChanged(object, false);
        }
    }

    @Nullable
    private DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull ObjectPath object) {
        DbSrcStorageDsMetadata.MetaData metaData;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(10);
        }
        if ((metaData = this.myFiles.getCachedMetaData(object)) == null && (metaData = this.readMetaData(object)) != null) {
            this.myFiles.putMetaDataToCache(object, metaData);
        }
        return metaData;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public DbSrcStorageDsMetadata.MetaData readMetaData(@NotNull ObjectPath object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized byte[] getEntryData(DbSrcZipFile file, String name2) throws IOException {
        return file.getData(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(@NotNull ObjectPath object, @Nullable byte[] content) throws IOException {
        block37: {
            if (object == null) {
                DbSrcBackendZipData.$$$reportNull$$$0(12);
            }
            StringBuilder path = new StringBuilder("/");
            DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
            path.append(".sql");
            try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
                 GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
                if (content != null) {
                    String comment = DbSrcBackendZipData.getDisplayName(object);
                    ref.get().putData(path.toString(), content, System.currentTimeMillis(), comment);
                    THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
                    synchronized (tHashMap) {
                        DirInfo info = this.getOrCreateDirInfo(object.parent);
                        this.myFileStamps.put((Object)object, (Object)new FileInfo(System.currentTimeMillis(), content.length));
                        if (info != null) {
                            info.files.add(object);
                        }
                        break block37;
                    }
                }
                ref.get().eraseEntry(path.toString());
                THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
                synchronized (tHashMap) {
                    DirInfo info = this.getDirInfo(object.parent);
                    if (info != null) {
                        info.files.remove(object);
                    }
                    this.myFileStamps.remove((Object)object);
                }
            }
            finally {
                this.myFiles.getListener().fileChanged(object, false);
            }
        }
    }

    private static String getDisplayName(@NotNull ObjectPath object) {
        String d2;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(13);
        }
        return (d2 = object.getIdentity()) != null ? object.getName() + "." + d2 : object.getName();
    }

    @NotNull
    public ObjectPath findCascadeRemovalRoot(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(14);
        }
        ObjectPath objectPath = this.findCascadeRemovalRootImpl(object);
        if (objectPath == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(15);
        }
        return objectPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ObjectPath findCascadeRemovalRootImpl(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(16);
        }
        if (object.equals((Object)this.myRoot)) {
            ObjectPath objectPath = object;
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(17);
            return objectPath;
        }
        ObjectPath parent2 = object.parent;
        if (parent2 == null) {
            ObjectPath objectPath = object;
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(18);
            return objectPath;
        }
        THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
        // MONITORENTER : tHashMap
        if (this.hasOtherChild(parent2, object)) {
            ObjectPath objectPath = object;
            // MONITOREXIT : tHashMap
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(19);
            return objectPath;
        }
        if (parent2.equals((Object)this.myRoot)) {
            ObjectPath objectPath = parent2;
            // MONITOREXIT : tHashMap
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(20);
            return objectPath;
        }
        if (this.myFileStamps.get((Object)parent2) != null) {
            ObjectPath objectPath = object;
            // MONITOREXIT : tHashMap
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(21);
            return objectPath;
        }
        // MONITOREXIT : tHashMap
        if (!((DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)this.getMetaData(object), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY)).equals(DbSrcStorageDsMetadata.MetaData.EMPTY)) {
            ObjectPath objectPath = object;
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(22);
            return objectPath;
        }
        ObjectPath objectPath = this.findCascadeRemovalRootImpl(parent2);
        if (objectPath != null) return objectPath;
        DbSrcBackendZipData.$$$reportNull$$$0(23);
        return objectPath;
    }

    private boolean hasOtherChild(@NotNull ObjectPath parent2, @NotNull ObjectPath object) {
        DirInfo info;
        if (parent2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(24);
        }
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(25);
        }
        if ((info = (DirInfo)this.myStructure.get((Object)parent2)) == null) {
            return false;
        }
        if (info.dirs.size() > 1 || info.files.size() > 1) {
            return true;
        }
        if (!info.dirs.isEmpty() && !info.dirs.contains(object)) {
            return true;
        }
        return !info.files.isEmpty() && !info.files.contains(object);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public byte[] getContent(@NotNull ObjectPath object) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileAttributes getSrcAttributes(@NotNull ObjectPath object) {
        FileInfo info;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(27);
        }
        THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
        synchronized (tHashMap) {
            info = (FileInfo)this.myFileStamps.get((Object)object);
        }
        if (info == null) {
            return null;
        }
        return new FileAttributes(false, false, false, false, info.size, info.stamp, !this.myWriter.isReadOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropObject(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(28);
        }
        ObjectPath root2 = object;
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();){
            if (object.equals((Object)this.myRoot)) {
                this.myFiles.dropSrcAndMeta(object);
            }
            root2 = this.findCascadeRemovalRoot(object);
            this.dropFromStructure(root2);
            this.clearSubEntries(root2);
            this.myFiles.removeCachedMetaDataRec(root2);
        }
        finally {
            this.myFiles.getListener().dirChanged(root2, false, true);
            this.myFiles.getListener().fileChanged(root2, false);
        }
    }

    private void clearSubEntries(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(29);
        }
        String prefix = null;
        String src = null;
        String meta = null;
        if (!object.equals((Object)this.myRoot)) {
            StringBuilder path = new StringBuilder("/");
            DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
            int len = path.length();
            prefix = path.append("/").toString();
            path.setLength(len);
            src = path.append(".sql").toString();
            path.setLength(len);
            meta = path.append(".meta").toString();
        }
        try (GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
            DbSrcZipFile.It it2 = ref.get().iterate();
            while (it2.advance()) {
                String name2 = it2.getName();
                if (prefix != null && !name2.startsWith(prefix) && !name2.equals(src) && !name2.equals(meta)) continue;
                it2.drop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropFromStructure(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(30);
        }
        this.myFiles.putMetaDataToCache(object, null);
        THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
        synchronized (tHashMap) {
            DirInfo children2 = (DirInfo)this.myStructure.remove((Object)object);
            this.myFileStamps.remove((Object)object);
            if (children2 != null) {
                for (ObjectPath file : children2.files) {
                    this.myFiles.putMetaDataToCache(object, null);
                    this.myFileStamps.remove((Object)file);
                }
                for (ObjectPath dir : children2.dirs) {
                    this.dropFromStructure(dir);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeWriter() {
        block19: {
            try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();){
                if (!this.myWriter.close() || !this.myWriter.isExists()) break block19;
                boolean empty = false;
                THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
                synchronized (tHashMap) {
                    if (!this.hasChildren(this.myRoot)) {
                        this.myStructure.clear();
                        this.myFileStamps.clear();
                        this.myLoaded = false;
                        empty = true;
                    }
                }
                if (!empty) break block19;
                try {
                    this.myWriter.dropFile();
                    if (!this.myFiles.hasSrcOrMeta(this.myRoot)) {
                        this.myFiles.dropObject(this.myRoot, false);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    private void fillStructure(@NotNull DbSrcZipFile file, @NotNull Map<CharSequence, Pair<String, String>> names) {
        if (file == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(31);
        }
        if (names == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(32);
        }
        HashMap<CharSequence, ObjectPath> paths = new HashMap<CharSequence, ObjectPath>();
        DbSrcZipFile.It it2 = file.iterate();
        while (it2.advance()) {
            String name2 = it2.getName();
            if (name2.isEmpty() || name2.charAt(0) != '/') continue;
            boolean dir = it2.isDirectory();
            if (!dir) {
                if (!name2.endsWith(".sql")) continue;
                name2 = StringUtil.trimEnd((String)name2, (String)".sql");
            } else {
                if (DbSrcBackendZipData.isGroup(name2)) continue;
                name2 = StringUtil.trimEnd((String)name2, (String)"/");
            }
            ObjectPath path = this.createSrcPath(name2, paths, names);
            if (path == null) {
                this.reportCorruptedEntry(name2);
                continue;
            }
            DirInfo parentDir = this.getOrCreateDirInfo((ObjectPath)ObjectUtils.assertNotNull((Object)path.parent));
            if (dir) {
                parentDir.dirs.add(path);
            } else {
                this.myFileStamps.put((Object)path, (Object)new FileInfo(it2.getTimestamp(), it2.getSize()));
                parentDir.files.add(path);
            }
            this.getOrCreateDirInfo(this.myRoot);
        }
    }

    private DirInfo getOrCreateDirInfo(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        DirInfo info = (DirInfo)this.myStructure.get((Object)path);
        if (info == null) {
            DirInfo parent2;
            if (!path.equals((Object)this.myRoot) && (parent2 = this.getOrCreateDirInfo(path.parent)) != null) {
                parent2.dirs.add(path);
            }
            info = new DirInfo();
            this.myStructure.put((Object)path, (Object)info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DirInfo getDirInfo(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
        synchronized (tHashMap) {
            return (DirInfo)this.myStructure.get((Object)path);
        }
    }

    private static boolean isGroup(String path) {
        return StringUtil.countChars((CharSequence)path, (char)'/') % 2 == 0;
    }

    @Nullable
    private ObjectPath createSrcPath(@NotNull CharSequence name2, @NotNull Map<CharSequence, ObjectPath> paths, @NotNull Map<CharSequence, Pair<String, String>> namesMapping) {
        ObjectPath parent2;
        ObjectPath path;
        if (name2 == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(33);
        }
        if (paths == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(34);
        }
        if (namesMapping == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(35);
        }
        if ((path = paths.get(name2)) != null) {
            return path;
        }
        assert (StringUtil.startsWith((CharSequence)name2, (CharSequence)"/"));
        Pair<String, String> realName = namesMapping.get(name2);
        if (realName == null) {
            return null;
        }
        int ns = StringUtil.lastIndexOf((CharSequence)name2, (char)'/', (int)0, (int)name2.length());
        if (ns == -1) {
            return null;
        }
        int gs = StringUtil.lastIndexOf((CharSequence)name2, (char)'/', (int)0, (int)ns);
        if (gs == -1) {
            return null;
        }
        String code = name2.subSequence(gs + 1, ns).toString();
        ObjectKind kind = DbSrcUtils.findKind(code);
        if (kind == null) {
            return null;
        }
        ObjectPath objectPath = parent2 = gs == 0 ? this.myRoot : this.createSrcPath(name2.subSequence(0, gs), paths, namesMapping);
        if (parent2 == null) {
            return null;
        }
        path = DbSrcBackendUtils.createPath(parent2, (String)realName.first, kind, (String)realName.second);
        paths.put(name2, path);
        return path;
    }

    @NotNull
    public Map<CharSequence, Pair<String, String>> extractNamesMapping(DbSrcZipFile file) {
        HashMap<CharSequence, Pair<String, String>> names = new HashMap<CharSequence, Pair<String, String>>();
        DbSrcZipFile.It it2 = file.iterate();
        while (it2.advance()) {
            Pair<String, String> fullName;
            String id;
            String name2 = it2.getName();
            if (it2.isDirectory() || !name2.endsWith(".meta") || names.containsKey(id = StringUtil.trimEnd((String)name2, (String)".meta"))) continue;
            try {
                fullName = DbSrcBackendUtils.extractNameAndIdentity(it2.getData());
            }
            catch (IOException e) {
                LOG.warn("Failed to read " + name2 + " from " + this.getPath(), (Throwable)e);
                fullName = null;
            }
            if (fullName != null) {
                names.put(id, fullName);
                continue;
            }
            this.reportCorruptedEntry(name2);
        }
        HashMap<CharSequence, Pair<String, String>> hashMap = names;
        if (hashMap == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(36);
        }
        return hashMap;
    }

    @NotNull
    public String getPath() {
        String string = this.myWriter.getPath();
        if (string == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(37);
        }
        return string;
    }

    private void reportCorruptedEntry(String name2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(@NotNull ObjectPath object, long timestamp) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(38);
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".sql");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
             GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
            String name2 = path.toString();
            byte[] data = ref.get().getData(name2);
            if (data == null) {
                return;
            }
            ref.get().putData(name2, data, timestamp, DbSrcBackendZipData.getDisplayName(object));
            THashMap<ObjectPath, DirInfo> tHashMap = this.myStructure;
            synchronized (tHashMap) {
                FileInfo info = (FileInfo)this.myFileStamps.get((Object)object);
                assert (info != null);
                this.myFileStamps.put((Object)object, (Object)new FileInfo(timestamp, info.size));
            }
        }
        finally {
            this.myFiles.getListener().fileChanged(object, false);
        }
    }

    public static void flushCloseQueue() {
        LazyData.ourCloseQueue.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendZipData";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendZipData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "listGroups";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findCascadeRemovalRoot";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findCascadeRemovalRootImpl";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNamesMapping";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 36: 
            case 37: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readMetaData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRoot";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRootImpl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasOtherChild";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "dropObject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "clearSubEntries";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "dropFromStructure";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fillStructure";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createSrcPath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class FileInfo {
        public final long stamp;
        public final long size;

        public FileInfo(long stamp, long size) {
            this.stamp = stamp - stamp % 2000L;
            this.size = size;
        }
    }

    public static final class DirInfo {
        public final Set<ObjectPath> dirs = new LinkedHashSet<ObjectPath>();
        public final Set<ObjectPath> files = new LinkedHashSet<ObjectPath>();
    }

    private static class LazyData {
        private static final MergingUpdateQueue ourCloseQueue = new MergingUpdateQueue("Close DbSrcBackend zips", 2000, true, null, (Disposable)ApplicationManager.getApplication(), null, Alarm.ThreadToUse.POOLED_THREAD);

        private LazyData() {
        }

        static {
            ourCloseQueue.setPassThrough(false);
            ourCloseQueue.setRestartTimerOnAdd(true);
        }
    }
}

