/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.Version;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\tH\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\b\u0010'\u001a\u00020\u001dH\u0016J\u0006\u0010(\u001a\u00020\u0005J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0019H\u0016J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u001dH\u0016J\u0010\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u001dH\u0016J\b\u00101\u001a\u00020+H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/database/dataSource/SimpleDatabaseConnection;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "jdbcConnection", "Ljava/sql/Connection;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "requestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Ljava/sql/Connection;Lcom/intellij/database/run/ConsoleRunConfiguration;Lcom/intellij/database/dataSource/connection/ConnectionRequestor;Lcom/intellij/openapi/project/Project;)V", "myAuditService", "Lcom/intellij/database/dataSource/connection/audit/AdvancedAuditService;", "myConfiguration", "myConnectionPoint", "myDbms", "Lcom/intellij/database/Dbms;", "myDriverVersion", "Lcom/intellij/database/util/Version;", "myJdbcConnection", "myRequestor", "myVersion", "cancelAll", "", "commit", "getAuditService", "getAutoCommit", "", "getConfiguration", "getConnectionPoint", "getDbms", "getDriverVersion", "getJdbcConnection", "getMetaData", "Ljava/sql/DatabaseMetaData;", "getRequestor", "getVersion", "isReadOnly", "release", "releaseSavepoint", "savepoint", "Ljava/sql/Savepoint;", "rollback", "setAutoCommit", "autoCommit", "setReadOnly", "only", "setSavepoint", "intellij.database.impl"})
public final class SimpleDatabaseConnection
implements DatabaseConnection {
    private final Connection myJdbcConnection;
    private final ConsoleRunConfiguration myConfiguration;
    private final DatabaseConnectionPoint myConnectionPoint;
    private final AdvancedAuditService myAuditService;
    private final ConnectionRequestor myRequestor;
    private final Dbms myDbms;
    private final Version myVersion;
    private final Version myDriverVersion;

    @Override
    @NotNull
    public ConnectionRequestor getRequestor() {
        return this.myRequestor;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        return this.myDbms;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return this.myVersion;
    }

    @Override
    @NotNull
    public Version getDriverVersion() {
        return this.myDriverVersion;
    }

    @Override
    @NotNull
    public AdvancedAuditService getAuditService() {
        return this.myAuditService;
    }

    @Override
    @NotNull
    public DatabaseConnectionPoint getConnectionPoint() {
        return this.myConnectionPoint;
    }

    @Override
    @Nullable
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.myJdbcConnection.getMetaData();
    }

    @Override
    @NotNull
    public Connection getJdbcConnection() {
        return this.myJdbcConnection;
    }

    @Override
    @NotNull
    public ConsoleRunConfiguration getConfiguration() {
        Object object = ObjectUtils.assertNotNull((Object)((Object)this.myConfiguration));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ObjectUtils.assertNotNull(myConfiguration)");
        return (ConsoleRunConfiguration)((Object)object);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.myJdbcConnection.setAutoCommit(autoCommit);
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.myJdbcConnection.getAutoCommit();
    }

    @Override
    public void setReadOnly(boolean only) throws SQLException {
        this.myJdbcConnection.setReadOnly(only);
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.myJdbcConnection.isReadOnly();
    }

    @Override
    public void rollback() throws SQLException {
        this.myJdbcConnection.rollback();
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    @Override
    public void rollback(@NotNull Savepoint savepoint) throws SQLException {
        Intrinsics.checkParameterIsNotNull((Object)savepoint, (String)"savepoint");
        this.myJdbcConnection.rollback(savepoint);
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    @Override
    public void releaseSavepoint(@NotNull Savepoint savepoint) throws SQLException {
        Intrinsics.checkParameterIsNotNull((Object)savepoint, (String)"savepoint");
        this.myJdbcConnection.releaseSavepoint(savepoint);
    }

    @Override
    @NotNull
    public Savepoint setSavepoint() throws SQLException {
        Savepoint savepoint = this.myJdbcConnection.setSavepoint();
        Intrinsics.checkExpressionValueIsNotNull((Object)savepoint, (String)"myJdbcConnection.setSavepoint()");
        return savepoint;
    }

    @Override
    public void commit() throws SQLException {
        this.myJdbcConnection.commit();
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    @NotNull
    public final Connection release() {
        JdbcUtil.closeSafe((AutoCloseable)this.myAuditService);
        return this.myJdbcConnection;
    }

    public final void cancelAll() {
        try {
            ((RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)this.myJdbcConnection, RemoteConnection.class)).cancelAll();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public SimpleDatabaseConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull Connection jdbcConnection, @NotNull ConsoleRunConfiguration configuration, @NotNull ConnectionRequestor requestor, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkParameterIsNotNull((Object)jdbcConnection, (String)"jdbcConnection");
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.myJdbcConnection = jdbcConnection;
        this.myConfiguration = configuration;
        this.myConnectionPoint = connectionPoint;
        this.myRequestor = requestor;
        DataSourceInfo.DetectedDbms detectedDbms = DataSourceInfo.getDetected(jdbcConnection);
        Intrinsics.checkExpressionValueIsNotNull((Object)detectedDbms, (String)"DataSourceInfo.getDetected(jdbcConnection)");
        DataSourceInfo.DetectedDbms detected = detectedDbms;
        Dbms dbms = detected.dbms;
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"detected.dbms");
        this.myDbms = dbms;
        Version version = detected.version;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"detected.version");
        this.myVersion = version;
        Version version2 = detected.driverVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"detected.driverVersion");
        this.myDriverVersion = version2;
        this.myAuditService = new AdvancedAuditService(this, requestor, project);
    }
}

