/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.sql.SqlFileType;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceOptionsPanel {
    private final DataSourceConfigurable myConfigurable;
    private JBScrollPane myRoot;
    private JBCheckBox myGenericIntrospector;
    private ComboBox<DBIntrospectionOptions.SourceLoading> mySourceLoading;
    private ComboBox<DatabaseDriver.SchemaControl> mySwitchControlBox;
    private JBCheckBox mySingleDatabase;
    private ComboBox<String> myCodeStyleComboBox;
    private JBCheckBox mySingleConnectionCheckBox;
    private JBCheckBox myCheckOutdatedCheckBox;
    private JBCheckBox myKeepAliveEnable;
    private JBTextField myKeepAliveTimeout;
    private JBCheckBox myAutoCloseEnable;
    private EditorTextField myInitScript;
    private JBTextField myAutoCloseTimeout;
    private JBCheckBox myAutoSyncCheckBox;
    private JBCheckBox myReadOnlyCheckBox;
    private JPanel myTxControlPanel;
    private JPanel myTxControlHolder;
    private TextFieldWithAutoCompletion<String> myTimeZoneField;
    private JLabel myTimeZoneLabel;
    private JBCheckBox myUseMiniCat;
    private final DataSourceGeneralPanel.MyTxIsolationSelector mySelector;

    public DataSourceOptionsPanel(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(0);
        }
        this.mySelector = new DataSourceGeneralPanel.MyTxIsolationSelector();
        this.myConfigurable = configurable;
        this.$$$setupUI$$$();
        this.mySourceLoading.setModel((ComboBoxModel)new EnumComboBoxModel(DBIntrospectionOptions.SourceLoading.class));
        this.mySourceLoading.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"None", value -> value == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES ? "All schemas" : (value == DBIntrospectionOptions.SourceLoading.USER_SOURCES ? "All excl. system schemas" : "None")));
        this.mySwitchControlBox.setModel((ComboBoxModel)new EnumComboBoxModel(DatabaseDriver.SchemaControl.class));
        this.mySwitchControlBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"Automatic", value -> StringUtil.capitalize((String)StringUtil.toLowerCase((String)value.displayName()))));
        LocalDataSource dataSource = (LocalDataSource)this.myConfigurable.getDataSource();
        Dbms dbms = dataSource.getDbms();
        boolean tzVisible = ((ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(dbms)).getTimeZoneManager().canChange();
        this.myTimeZoneField.setVisible(tzVisible);
        this.myTimeZoneLabel.setVisible(tzVisible);
        this.myGenericIntrospector.setVisible(DBIntrospectorFactory.hasNativeIntrospector(dbms));
        this.mySingleDatabase.setVisible(JdbcUrlParserUtil.isDatabaseBounded(dataSource));
        new ExpandableEditorSupport(this.myInitScript);
        DatabaseDialogsHelper.setTextFieldLanguage(this.myInitScript, DbSqlUtil.getSqlDialect(dataSource));
        this.myKeepAliveEnable.addActionListener(this::update);
        this.myAutoCloseEnable.addActionListener(this::update);
        SortedComboBoxModel codeStyleNamesModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        List allSchemes = CodeStyleSchemesImpl.getSchemeManager().getAllSchemes();
        for (CodeStyleScheme scheme : allSchemes) {
            codeStyleNamesModel.add((Object)scheme.getName());
        }
        this.myCodeStyleComboBox.setModel((ComboBoxModel)codeStyleNamesModel);
        JComponent txComponent = DbUIUtil.createActionComponent((AnAction)new DataSourceGeneralPanel.DataSourceTxModeAction(this.mySelector, dbms));
        this.myTxControlPanel.setLayout(new BorderLayout());
        this.myTxControlPanel.add((Component)txComponent, "Center");
        this.myTxControlHolder.setVisible(TransactionAction.isTransactionsSupported(dbms));
        DatabaseDialogsHelper.setupEnclosingScrollPane((JScrollPane)this.myRoot);
        new UiNotifyConnector((Component)this.myRoot, new Activatable(){

            public void showNotify() {
                DatabaseDialogsHelper.setTextFieldLanguage(DataSourceOptionsPanel.this.myInitScript, DbSqlUtil.getSqlDialect(DataSourceOptionsPanel.this.myConfigurable.getTempDataSource()));
            }

            public void hideNotify() {
            }
        });
    }

    private void createUIComponents() {
        this.myInitScript = new EditorTextField("", this.myConfigurable.getProject(), (FileType)SqlFileType.INSTANCE);
        ExecutionEnvironmentHelper.TimeZoneManager manager = ((ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(((LocalDataSource)this.myConfigurable.getDataSource()).getDbms())).getTimeZoneManager();
        Collection<String> zones = manager.getAvailableTimeZones();
        TimeZoneCompletionProvider zonesProvider = new TimeZoneCompletionProvider(zones);
        this.myTimeZoneField = new TextFieldWithAutoCompletion(this.myConfigurable.getProject(), (TextFieldWithAutoCompletionListProvider)zonesProvider, !zones.isEmpty(), "");
        this.myTimeZoneField.setPreferredWidth(this.computePreferredWidth(ZoneId.getAvailableZoneIds()));
    }

    private int computePreferredWidth(@NotNull Collection<String> zones) {
        if (zones == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(1);
        }
        int maxLength = Integer.MIN_VALUE;
        String maxZone = null;
        for (String zone : zones) {
            if (zone.length() <= maxLength) continue;
            maxLength = zone.length();
            maxZone = zone;
        }
        this.myTimeZoneField.setText(maxZone);
        this.myTimeZoneField.ensureWillComputePreferredSize();
        return this.myTimeZoneField.getPreferredSize().width;
    }

    private void update(ActionEvent ignore) {
        this.myKeepAliveTimeout.setEnabled(this.myKeepAliveEnable.isSelected());
        this.myAutoCloseTimeout.setEnabled(this.myAutoCloseEnable.isSelected());
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(2);
        }
        this.mySourceLoading.setSelectedItem((Object)mode);
    }

    public JComponent getComponent() {
        return this.myRoot;
    }

    public void saveData(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceOptionsPanel.$$$reportNull$$$0(3);
        }
        dataSource.setAutoCommit(this.mySelector.isAuto());
        dataSource.setTxIsolation(this.mySelector.getIsolation().getIsolation());
        dataSource.setAutoSynchronize(this.myAutoSyncCheckBox.isSelected());
        dataSource.setReadOnly(this.myReadOnlyCheckBox.isSelected());
        dataSource.setUseLegacyIntrospector(this.myGenericIntrospector.isSelected());
        dataSource.getSchemaMapping().setUseMiniCat(this.myUseMiniCat.isSelected());
        dataSource.setRewriteBounds(!this.mySingleDatabase.isSelected());
        dataSource.setSourceLoading((DBIntrospectionOptions.SourceLoading)((Object)ObjectUtils.notNull((Object)((Object)((DBIntrospectionOptions.SourceLoading)((Object)this.mySourceLoading.getSelectedItem()))), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES))));
        dataSource.setSchemaControl((DatabaseDriver.SchemaControl)((Object)ObjectUtils.notNull((Object)((Object)((DatabaseDriver.SchemaControl)((Object)this.mySwitchControlBox.getSelectedItem()))), (Object)((Object)DatabaseDriver.SchemaControl.AUTOMATIC))));
        dataSource.setCodeStyleName(StringUtil.nullize((String)((String)this.myCodeStyleComboBox.getSelectedItem()), (String)"Default"));
        dataSource.setSingleConnection(this.mySingleConnectionCheckBox.isSelected());
        dataSource.setCheckOutdated(this.myCheckOutdatedCheckBox.isSelected());
        dataSource.setInitScript(this.myInitScript.getText());
        dataSource.setKeepAlive(this.myKeepAliveEnable.isSelected());
        dataSource.setAutoClose(this.myAutoCloseEnable.isSelected());
        dataSource.setKeepAliveTimeout(StringUtil.parseInt((String)this.myKeepAliveTimeout.getText(), (int)0));
        dataSource.setAutoCloseTimeout(StringUtil.parseInt((String)this.myAutoCloseTimeout.getText(), (int)0));
        dataSource.setTimeZone(StringUtil.nullize((String)StringUtil.trim((String)this.myTimeZoneField.getText()), (boolean)true));
    }

    public void reset(LocalDataSource dataSource) {
        this.mySelector.toggle(null, dataSource.isAutoCommit());
        this.mySelector.select(TransactionAction.TxIsolation.of(dataSource.getTxIsolation()), null);
        this.myAutoSyncCheckBox.setSelected(dataSource.isAutoSynchronize());
        this.myReadOnlyCheckBox.setSelected(dataSource.isReadOnly());
        this.mySourceLoading.setSelectedItem((Object)dataSource.getSourceLoading());
        this.mySwitchControlBox.setSelectedItem((Object)dataSource.getSchemaControl());
        this.myGenericIntrospector.setSelected(dataSource.useLegacyIntrospector());
        this.myUseMiniCat.setSelected(dataSource.getSchemaMapping().isUseMiniCat());
        this.mySingleDatabase.setSelected(!dataSource.isRewriteBounds());
        this.myCodeStyleComboBox.setSelectedItem((Object)StringUtil.notNullize((String)dataSource.getCodeStyleName(), (String)"Default"));
        this.mySingleConnectionCheckBox.setSelected(dataSource.isSingleConnection());
        this.myCheckOutdatedCheckBox.setSelected(dataSource.shouldCheckOutdated());
        this.myCheckOutdatedCheckBox.setEnabled(DBIntrospectorFactory.isOutdatedCheckSupported(dataSource.getDbms(), false, null));
        this.myCheckOutdatedCheckBox.setToolTipText(this.myCheckOutdatedCheckBox.isEnabled() ? null : "Unsupported");
        this.myInitScript.setText(dataSource.getInitScript());
        this.myKeepAliveEnable.setSelected(dataSource.isKeepAlive());
        this.myAutoCloseEnable.setSelected(dataSource.isAutoClose());
        this.myKeepAliveTimeout.setText(String.valueOf(dataSource.getKeepAliveTimeout()));
        this.myAutoCloseTimeout.setText(String.valueOf(dataSource.getAutoCloseTimeout()));
        this.myTimeZoneField.setText(StringUtil.notNullize((String)dataSource.getTimeZone()));
        this.update(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zones";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "computePreferredWidth";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSourceLoading";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "saveData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        ComboBox comboBox;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        ComboBox comboBox2;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBCheckBox jBCheckBox7;
        ComboBox comboBox3;
        JBTextField jBTextField;
        JBCheckBox jBCheckBox8;
        JBTextField jBTextField2;
        JBCheckBox jBCheckBox9;
        JBScrollPane jBScrollPane;
        this.createUIComponents();
        this.myRoot = jBScrollPane = new JBScrollPane();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Connection", (int)0, (int)0, null, null));
        this.myKeepAliveEnable = jBCheckBox9 = new JBCheckBox();
        jBCheckBox9.setText("Run keep-alive query each");
        jPanel4.add((Component)jBCheckBox9, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myKeepAliveTimeout = jBTextField2 = new JBTextField();
        jPanel4.add((Component)jBTextField2, new GridConstraints(5, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("sec.");
        jPanel4.add((Component)jBLabel, new GridConstraints(5, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoCloseEnable = jBCheckBox8 = new JBCheckBox();
        jBCheckBox8.setText("Auto-disconnect after ");
        jPanel4.add((Component)jBCheckBox8, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myAutoCloseTimeout = jBTextField = new JBTextField();
        jPanel4.add((Component)jBTextField, new GridConstraints(6, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(5, 4, 1, 1, 0, 1, 2, 1, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("sec.");
        jPanel4.add((Component)jBLabel2, new GridConstraints(6, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Switch schema:");
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySwitchControlBox = comboBox3 = new ComboBox();
        jPanel4.add((Component)comboBox3, new GridConstraints(2, 1, 1, 2, 8, 0, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Startup script:");
        jPanel4.add((Component)jLabel3, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myInitScript;
        jPanel4.add((Component)editorTextField, new GridConstraints(8, 1, 1, 4, 0, 1, 3, 0, null, null, null));
        this.myReadOnlyCheckBox = jBCheckBox7 = new JBCheckBox();
        jBCheckBox7.setText("Read-only");
        jPanel4.add((Component)jBCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySingleConnectionCheckBox = jBCheckBox6 = new JBCheckBox();
        jBCheckBox6.setText("Single connection mode");
        jPanel4.add((Component)jBCheckBox6, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySingleDatabase = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setText("Single database mode");
        jBCheckBox5.setMnemonic('S');
        jBCheckBox5.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jBCheckBox5, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myTxControlHolder = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Transaction control:");
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTxControlPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 0, null, null, null));
        this.myTimeZoneLabel = jLabel = new JLabel();
        jLabel.setText("Time zone:");
        jPanel4.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithAutoCompletion<String> textFieldWithAutoCompletion = this.myTimeZoneField;
        jPanel4.add((Component)textFieldWithAutoCompletion, new GridConstraints(3, 1, 1, 4, 8, 0, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Other", (int)0, (int)0, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Code style:");
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCodeStyleComboBox = comboBox2 = new ComboBox();
        comboBox2.setEnabled(true);
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Introspection", (int)0, (int)0, null, null));
        this.myGenericIntrospector = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Introspect using JDBC metadata");
        jBCheckBox4.setMnemonic('M');
        jBCheckBox4.setDisplayedMnemonicIndex(22);
        jPanel6.add((Component)jBCheckBox4, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myCheckOutdatedCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Warn when editing outdated DDL");
        jPanel6.add((Component)jBCheckBox3, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.mySourceLoading = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel6.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myAutoSyncCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Auto sync");
        jPanel6.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Load sources for:");
        jPanel6.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseMiniCat = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use pre-introspected objects for system catalogs that are not introspected");
        jPanel6.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor((Component)comboBox3);
        jLabel3.setLabelFor((Component)editorTextField);
        jLabel.setLabelFor((Component)comboBox3);
        jBLabel3.setLabelFor((Component)comboBox2);
        jBLabel4.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static class TimeZonePrefixMatcher
    extends PlainPrefixMatcher {
        private final MinusculeMatcher myMatcher;

        TimeZonePrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(0);
            }
            super(prefix);
            this.myMatcher = NameUtil.buildMatcher((String)prefix).build();
        }

        public boolean prefixMatches(@NotNull String name2) {
            if (name2 == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(1);
            }
            return super.prefixMatches(name2) || this.myMatcher.matches(name2);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(2);
            }
            TimeZonePrefixMatcher timeZonePrefixMatcher = new TimeZonePrefixMatcher(prefix);
            if (timeZonePrefixMatcher == null) {
                TimeZonePrefixMatcher.$$$reportNull$$$0(3);
            }
            return timeZonePrefixMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceOptionsPanel$TimeZonePrefixMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsPanel$TimeZonePrefixMatcher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cloneWithPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "prefixMatches";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneWithPrefix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TimeZoneCompletionProvider
    extends TextFieldWithAutoCompletion.StringsCompletionProvider {
        TimeZoneCompletionProvider(@NotNull Collection<String> variants) {
            if (variants == null) {
                TimeZoneCompletionProvider.$$$reportNull$$$0(0);
            }
            super(variants, null);
        }

        @Nullable
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                TimeZoneCompletionProvider.$$$reportNull$$$0(1);
            }
            return new TimeZonePrefixMatcher(prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variants";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DataSourceOptionsPanel$TimeZoneCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPrefixMatcher";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

