/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.KeepAliveActionDescriptor;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DataSourceSchemasPanel;
import com.intellij.database.dataSource.DataSourceSshSslPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceTestConnectionPanel;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.ui.AdvancedPropertiesPanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceConfigurable
extends AbstractDataSourceConfigurable<LocalDataSourceManager, LocalDataSource> {
    private static final Key<Boolean> RESET_CONNECTION_YES_FOR_ALL_KEY = Key.create((String)"RESET_CONNECTION_YES_FOR_ALL_KEY");
    public static final Key<Function<LocalDataSource, Collection<DatabaseDriver>>> DRIVER_VARIANTS_PROVIDER = Key.create((String)"DRIVER_VARIANTS_PROVIDER");
    private final JPanel myPanel = new JPanel(new BorderLayout(0, 5));
    private JBTabbedPane myTabbedPane;
    private final LocalDataSource myTempDataSource;
    private long myLastSaveStamp;
    private DatabaseNameComponent myNameComponent;
    private DataSourceGeneralPanel myGeneralPanel;
    private DataSourceSchemasPanel mySchemasPanel;
    private DataSourceOptionsPanel myOptionsPanel;
    private DataSourceSshSslPanel mySshSslPanel;
    private AdvancedPropertiesPanel myAdvancedPanel;
    private boolean myGlobal;
    private final MyTestAction myTestAction = this.createTestAction();

    public DataSourceConfigurable(LocalDataSourceManager manager, LocalDataSource dataSource, Project project) {
        super(manager, dataSource, project);
        this.myTempDataSource = dataSource.copy(true);
    }

    Object createKey(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(0);
        }
        StringBuilder cpString = new StringBuilder();
        for (SimpleClasspathElement cpe : dataSource.getClasspathElements()) {
            cpString.append(cpe.getClassesRootUrls()).append(";");
        }
        Credentials credentials = dataSource == this.myTempDataSource ? new Credentials(this.myGeneralPanel.getUserName(), this.myGeneralPanel.getPassword()) : this.getSecretService().getCredentials(dataSource);
        String cre = StringUtil.notNullize((String)(credentials == null ? null : credentials.getUserName())) + "@" + StringHash.calc((String)StringUtil.notNullize((String)(credentials == null ? null : credentials.getPasswordAsString())));
        return "auth:" + cre + ";driver:" + dataSource.getDriverClass() + "; url:" + dataSource.getUrl() + "; cp:" + cpString + "; vm-options: " + dataSource.getVmOptions();
    }

    @Nullable
    String getUserName() {
        return this.myGeneralPanel.getUserName();
    }

    void updateDatabaseInfo(@NotNull LocalDataSource source) {
        if (source == null) {
            DataSourceConfigurable.$$$reportNull$$$0(1);
        }
        if (Comparing.equal((Object)this.createKey(source), (Object)this.createKey((LocalDataSource)this.myDataSource))) {
            ((LocalDataSource)this.myDataSource).copyDatabaseInfo(source);
        }
    }

    @Override
    @NotNull
    public LocalDataSource getTempDataSource() {
        long curStamp = this.myController.getModificationTracker().getModificationCount();
        if (curStamp != this.myLastSaveStamp) {
            this.myLastSaveStamp = curStamp;
            this.saveData(this.myTempDataSource, false, true);
        }
        LocalDataSource localDataSource = this.myTempDataSource;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(2);
        }
        return localDataSource;
    }

    @NotNull
    public LocalDataSource getTempDataSourceForConnection() {
        LocalDataSource ds = ((LocalDataSource)this.myDataSource).copy(true);
        this.saveData(ds, true, true);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(3);
        }
        return localDataSource;
    }

    @Nullable
    public CompletionStage<?> testConnection(boolean checkConfiguration) {
        this.setConnectionStatus(null);
        LocalDataSource tempDataSource = this.getTempDataSourceForConnection();
        if (checkConfiguration && !DbImplUtil.canConnectTo(tempDataSource) && !this.handleIncompleteConfiguration(tempDataSource)) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)tempDataSource.getUrl())) {
            Messages.showErrorDialog((String)DatabaseMessages.message((String)"message.text.specify.database.url", (Object[])new Object[0]), (String)"Connect to Database...");
            this.myGeneralPanel.requestUrlFocus();
            return null;
        }
        this.hidePasswords();
        OneTimeString prevPassword = this.getSecretService().getPassword(tempDataSource);
        OneTimeString prevSshPassword = this.getSecretService().getSshPassword(tempDataSource);
        OneTimeString prevSshPassphrase = this.getSecretService().getSshPassphrase(tempDataSource);
        LocalDataSource prevDs = tempDataSource.copy(true);
        ErrorHandler handler = new ErrorHandler();
        CompletionStage<TestConnectionResult> testResult = this.performTestConnection(tempDataSource, handler);
        this.myTestAction.setBusy(true);
        return testResult.whenCompleteAsync((r, e) -> {
            this.myTestAction.setBusy(false);
            AsyncUtil.addUnhandledError(handler, e, tempDataSource.getName(), tempDataSource.getDbms());
            if (!prevDs.equalConfiguration(tempDataSource)) {
                this.reset(tempDataSource, false);
            }
            if (!Comparing.equal((CharSequence)this.getSecretService().getPassword(tempDataSource), (CharSequence)prevPassword)) {
                this.myGeneralPanel.getUrlEditor().getAuthPanel().passwordChanged();
            }
            if (!Comparing.equal((CharSequence)this.getSecretService().getSshPassword(tempDataSource), (CharSequence)prevSshPassword) || !Comparing.equal((CharSequence)this.getSecretService().getSshPassphrase(tempDataSource), (CharSequence)prevSshPassphrase)) {
                this.mySshSslPanel.getSshPanel().passwordsChangedInStorage();
            }
            this.applyTestConnectionResult(tempDataSource, handler, (TestConnectionResult)r, (Throwable)e);
        }, AsyncUtil.EDT_EXECUTOR);
    }

    @NotNull
    private CompletionStage<TestConnectionResult> performTestConnection(LocalDataSource tempDataSource, ErrorHandler handler) {
        CompletionStage<TestConnectionResult> completionStage = AsyncUtil.runTask(() -> AsyncUtil.supplyAsync(() -> DatabaseConnectionManager.getInstance().build(this.getProject(), tempDataSource).setCredentialsStore(this.getSecretService()).async(connection2 -> this.pingDatabase(connection2), handler), AsyncUtil.POOL_EXECUTOR), AsyncUtil.createBackgroundIndicator(this.getProject(), "Test Connection"));
        if (completionStage == null) {
            DataSourceConfigurable.$$$reportNull$$$0(4);
        }
        return completionStage;
    }

    private void applyTestConnectionResult(LocalDataSource tempDataSource, ErrorHandler handler, TestConnectionResult r, Throwable e) {
        if (AsyncUtil.isCancellation(e) && !handler.hasErrors()) {
            return;
        }
        boolean failed = handler.hasErrors();
        String summary = handler.getSummary();
        this.updateDatabaseInfo(tempDataSource);
        if (!failed) {
            summary = DataSourceUiUtil.formatDataSourceInfoString(tempDataSource);
            summary = summary + "\nPing: " + StringUtil.formatDuration((long)r.ping);
            if (!r.keepAliveResult) {
                summary = summary + " (keep-alive query results in error)";
            }
            if (r.sslState != null && r.sslState != ThreeState.UNSURE) {
                summary = summary + "\nSSL: " + StringUtil.toLowerCase((String)r.sslState.toString());
            }
        }
        this.setConnectionStatus(new DataSourceTestConnectionPanel.Status(failed, summary));
    }

    @NotNull
    private TestConnectionResult pingDatabase(@NotNull DatabaseConnection connection2) {
        if (connection2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(5);
        }
        TestConnectionResult result2 = new TestConnectionResult();
        String query = KeepAliveActionDescriptor.getKeepAliveQuery(this.getProject(), connection2.getConnectionPoint().getDataSource());
        BarrenStatement<String> stmt = SmartStatements.poweredBy(connection2).simple(Configuration.sourced(SmartStatements.Source.SYSTEM)).barren();
        long start = System.currentTimeMillis();
        try {
            stmt.execute(query);
            result2.keepAliveResult = true;
        }
        catch (Exception e) {
            result2.keepAliveResult = false;
        }
        result2.ping = System.currentTimeMillis() - start;
        result2.sslState = ((ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(connection2.getDbms())).getSslState(connection2);
        TestConnectionResult testConnectionResult = result2;
        if (testConnectionResult == null) {
            DataSourceConfigurable.$$$reportNull$$$0(6);
        }
        return testConnectionResult;
    }

    private void hidePasswords() {
        this.myGeneralPanel.hidePassword();
        this.mySshSslPanel.getSshPanel().hidePasswords();
    }

    private boolean handleIncompleteConfiguration(LocalDataSource source) {
        if (StringUtil.isEmptyOrSpaces((String)source.getUrl())) {
            Messages.showDialog((Project)this.getProject(), (String)"No database URL provided", (String)"Incomplete Configuration", (String[])new String[]{Messages.OK_BUTTON}, (int)0, (Icon)Messages.getErrorIcon());
            return false;
        }
        if (!DbImplUtil.hasDriverFiles(source)) {
            DatabaseDriver.ArtifactRef artifact;
            DatabaseDriver driver = source.getDatabaseDriver();
            DatabaseDriver.ArtifactRef artifactRef = artifact = driver == null ? null : driver.getArtifact();
            if (artifact == null) {
                int res2 = Messages.showYesNoDialog((Project)this.getProject(), (String)"No driver files provided", (String)"Incomplete Configuration", (String)"Configure Driver", (String)"Cancel", (Icon)Messages.getErrorIcon());
                if (driver != null && res2 == 0) {
                    this.myController.navigateTo(driver, true);
                }
                return false;
            }
            boolean downloaded = artifact.isRolling() && DatabaseDriverValidator.isDriverFilesUpToDate(artifact.getName(), "latest", artifact.isRolling(), driver.getClasspathElements());
            int res3 = Messages.showYesNoDialog((Project)this.getProject(), (String)("Driver files are not " + (downloaded ? "configured" : "downloaded")), (String)"Incomplete Configuration", (String)(downloaded ? "Switch to Latest Driver" : "Download Driver Files"), (String)"Cancel", (Icon)Messages.getErrorIcon());
            if (res3 == 0) {
                final NamedProgressive task = DatabaseDriverValidator.createDownloaderTask(source, this.myController);
                new Task.Modal(this.getProject(), task.getName(), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        task.run(indicator);
                    }

                    public void onSuccess() {
                        ApplicationManager.getApplication().invokeLater(() -> DataSourceConfigurable.this.testConnection(true));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DataSourceConfigurable$1", "run"));
                    }
                }.queue();
                return false;
            }
        }
        return false;
    }

    private void setConnectionStatus(@Nullable DataSourceTestConnectionPanel.Status status) {
        this.myGeneralPanel.getUrlEditor().getTestConnectionPanel().setState(status);
        this.mySshSslPanel.getTestConnectionPanel().setState(status);
    }

    protected JComponent createCenterPanel() {
        this.myNameComponent = new DatabaseNameComponent(this, this.myController, true);
        this.myPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myTabbedPane = new JBTabbedPane(1);
        this.myTabbedPane.setTabComponentInsets(null);
        this.myPanel.add((Component)this.myTabbedPane, "Center");
        this.myGeneralPanel = new DataSourceGeneralPanel(this);
        this.mySchemasPanel = new DataSourceSchemasPanel(this);
        this.myOptionsPanel = new DataSourceOptionsPanel(this);
        this.myAdvancedPanel = new AdvancedPropertiesPanel(this.myProject, ((LocalDataSource)this.myDataSource).getDriverProperties(), this, this.myController);
        this.mySshSslPanel = new DataSourceSshSslPanel(this.myProject, (LocalDataSource)this.myDataSource, this);
        this.myTabbedPane.addTab("General", (Component)this.myGeneralPanel.getComponent());
        this.myTabbedPane.addTab("Options", (Component)this.myOptionsPanel.getComponent());
        this.myTabbedPane.addTab("SSH/SSL", (Component)this.mySshSslPanel.getComponent());
        this.myTabbedPane.addTab("Schemas", (Component)this.mySchemasPanel.getComponent());
        this.myTabbedPane.addTab("Advanced", (Component)this.myAdvancedPanel.getComponent());
        DataSourceConfigurable.initTabbedPane(this.myTabbedPane, this.myController);
        return this.myPanel;
    }

    @Override
    public void beforeShowNotify() {
        super.beforeShowNotify();
        this.myTabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(this.myTabbedPane, this.myController));
    }

    @Override
    public void onUserActivity() {
        this.saveGeneralSettings(this.myTempDataSource, false, true);
        this.setConnectionStatus(null);
        this.mySshSslPanel.getSshPanel().updateInfoLabel();
        this.myGeneralPanel.updateDriverLink();
        this.myGeneralPanel.onActivity();
    }

    public static void initTabbedPane(final @NotNull JBTabbedPane tabbedPane, final @NotNull DatabaseConfigEditor controller) {
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(7);
        }
        if (controller == null) {
            DataSourceConfigurable.$$$reportNull$$$0(8);
        }
        UIUtil.uiChildren((Component)tabbedPane).consumeEach(UIUtil::removeScrollBorder);
        tabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(tabbedPane, controller));
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                int index2;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                controller.putUserData(DatabaseConfigEditor.SELECTED_TAB_KEY, Pair.create((Object)((index2 = tabbedPane.getSelectedIndex()) < 0 ? null : tabbedPane.getTitleAt(index2)), (Object)index2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceConfigurable$2", "stateChanged"));
            }
        });
    }

    public static int getDefaultTabIndex(@NotNull JBTabbedPane tabbedPane, @NotNull DatabaseConfigEditor controller) {
        Pair p2;
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(9);
        }
        if (controller == null) {
            DataSourceConfigurable.$$$reportNull$$$0(10);
        }
        if ((p2 = (Pair)controller.getUserData(DatabaseConfigEditor.SELECTED_TAB_KEY)) == null) {
            return 0;
        }
        if ((Integer)p2.second < tabbedPane.getTabCount() && (Integer)p2.second >= 0 && Comparing.equal((String)((String)p2.first), (String)tabbedPane.getTitleAt(((Integer)p2.second).intValue()))) {
            return (Integer)p2.second;
        }
        for (int i2 = tabbedPane.getTabCount() - 1; i2 > 0; --i2) {
            if (!Comparing.equal((String)((String)p2.first), (String)tabbedPane.getTitleAt(i2))) continue;
            return i2;
        }
        return 0;
    }

    public String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    public void setGeneratedName(@NotNull String name2) {
        if (name2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(11);
        }
        this.myNameComponent.setGeneratedName(name2);
    }

    public void saveData(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(12);
        }
        this.saveGeneralSettings(dataSource, copyCredentials, actual);
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.saveData(dataSource);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.saveProperties(dataSource.getDriverProperties());
            dataSource.setVmOptions(StringUtil.nullize((String)this.myAdvancedPanel.getVmOptions()));
            dataSource.setVmEnv(this.myAdvancedPanel.getVmEnv());
        }
        if (this.mySshSslPanel != null) {
            this.mySshSslPanel.saveData(dataSource, copyCredentials);
        }
    }

    public void saveGeneralSettings(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(13);
        }
        dataSource.setGlobal(this.myGlobal);
        this.myNameComponent.save(dataSource);
        this.myGeneralPanel.saveSettings(dataSource, copyCredentials, actual);
        this.mySchemasPanel.saveSettings(dataSource);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "com.intellij.database.dataSource.DataSourceConfigurable";
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "Connecting_to_a_database";
    }

    @Nullable
    public JComponent createComponent() {
        return this.createCenterPanel();
    }

    public void apply() throws ConfigurationException {
        int ret;
        LocalDataSource tempDataSource = ((LocalDataSource)this.myDataSource).copy(true);
        this.saveData(tempDataSource, true, true);
        String error2 = StringUtil.isEmpty((String)tempDataSource.getDriverClass()) ? DatabaseMessages.message((String)"error.text.database.driver.not.configured", (Object[])new Object[0]) : null;
        if (error2 != null && (ret = Messages.showYesNoDialog((String)DatabaseMessages.message((String)"confirmation.text.error.occurred.save.datasource", (Object[])new Object[]{error2}), (String)DatabaseMessages.message((String)"message.title.invalid.datasource", (Object[])new Object[0]), (Icon)Messages.getErrorIcon())) != 0) {
            return;
        }
        boolean newDataSource = this.isNewDataSource();
        boolean isGlobalChanged = !newDataSource && tempDataSource.isGlobal() != ((LocalDataSource)this.myDataSource).isGlobal();
        boolean isUrlChanged = !Comparing.strEqual((String)tempDataSource.getUrl(), (String)((LocalDataSource)this.myDataSource).getUrl());
        DataSourceSshTunnelConfiguration prevSshConfiguration = ((LocalDataSource)this.myDataSource).getSshConfiguration();
        boolean isAuthChanged = !this.equalCredentials(tempDataSource) || !DataSourceSshTunnelConfiguration.equal(tempDataSource.getSshConfiguration(), prevSshConfiguration) || !DataSourceSslConfiguration.equal(tempDataSource.getSslCfg(), ((LocalDataSource)this.myDataSource).getSslCfg());
        boolean resetConnections = isAuthChanged || tempDataSource.isSingleConnection() != ((LocalDataSource)this.myDataSource).isSingleConnection() || !Comparing.equal((String)tempDataSource.getDriverClass(), (String)((LocalDataSource)this.myDataSource).getDriverClass()) || !tempDataSource.getClasspathElements().equals(((LocalDataSource)this.myDataSource).getClasspathElements()) || !tempDataSource.getConnectionProperties().equals(((LocalDataSource)this.myDataSource).getConnectionProperties()) || !tempDataSource.getAdditionalJdbcProperties().equals(((LocalDataSource)this.myDataSource).getAdditionalJdbcProperties());
        boolean isSchemaChanged = newDataSource || isAuthChanged || isUrlChanged || tempDataSource.isAutoSynchronize() && !((LocalDataSource)this.myDataSource).isAutoSynchronize() || !this.equalCredentials(tempDataSource) || !Comparing.equal((Object)this.myTempDataSource.getIntrospectionScope(), (Object)((LocalDataSource)this.myDataSource).getIntrospectionScope()) || !Comparing.strEqual((String)tempDataSource.getObjectPattern(), (String)((LocalDataSource)this.myDataSource).getObjectPattern());
        this.saveData((LocalDataSource)this.myDataSource, true, false);
        this.applyCredentials(tempDataSource);
        this.myGeneralPanel.onApply();
        this.mySshSslPanel.onApply();
        this.myNameComponent.apply((AbstractDataSource)this.myDataSource);
        this.updateDatabaseInfo(tempDataSource);
        if (isGlobalChanged) {
            this.myController.onChangesApplied(indicator -> {
                try {
                    indicator.setText("Moving storage of " + ((LocalDataSource)this.myDataSource).getName());
                    if (((LocalDataSource)this.myDataSource).isGlobal()) {
                        DbSrcUtils.moveStorage((LocalDataSource)this.myDataSource, this.getProject(), null);
                    } else {
                        DbSrcUtils.moveStorage((LocalDataSource)this.myDataSource, null, this.getProject());
                    }
                }
                catch (IOException e) {
                    DbUIUtil.createNotification(this.myDataSource, "Failed to move storage: " + e.getMessage(), NotificationType.ERROR).notify(this.myProject);
                }
            });
        }
        JdbcDriverManager manager = JdbcDriverManager.getDriverManager(this.myProject);
        if (resetConnections && !manager.getActiveConfigurations((LocalDataSource)this.myDataSource).isEmpty()) {
            boolean yesForAll;
            int answer = Boolean.TRUE.equals(this.myController.getUserData(RESET_CONNECTION_YES_FOR_ALL_KEY)) ? 0 : Messages.showYesNoCancelDialog((Component)this.myPanel, (String)("Confirm closing all existing connections to '" + ((LocalDataSource)this.myDataSource).getName() + "'"), (String)"Apply Changes", (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (String)CommonBundle.getYesForAllButtonText(), (Icon)Messages.getQuestionIcon());
            boolean bl = yesForAll = answer == 2;
            if (yesForAll) {
                this.myController.putUserData(RESET_CONNECTION_YES_FOR_ALL_KEY, true);
            }
            if (answer == 0 || yesForAll) {
                this.myController.onChangesApplied(indicator -> {
                    this.myController.putUserData(RESET_CONNECTION_YES_FOR_ALL_KEY, null);
                    manager.releaseDriver((LocalDataSource)this.myDataSource, null);
                });
            }
        }
        if (isUrlChanged) {
            ((LocalDataSource)this.myDataSource).getInfo().dbms = null;
        }
        if (isSchemaChanged && DbImplUtil.canConnectTo((LocalDataSource)this.myDataSource)) {
            this.myController.onChangesApplied(indicator -> DataSourceUiUtil.performAutoSyncTask(LoaderContext.loadAll(this.myProject, (LocalDataSource)this.myDataSource), true));
        }
        if (newDataSource) {
            ((LocalDataSourceManager)this.myManager).addDataSource((LocalDataSource)this.myDataSource);
        } else {
            ((LocalDataSourceManager)this.myManager).fireDataSourceUpdated((LocalDataSource)this.myDataSource);
        }
    }

    private void applyCredentials(LocalDataSource tempDataSource) {
        DatabaseCredentials dc = DatabaseCredentials.getInstance();
        DatabaseCredentials local = this.myController.getSecretService();
        dc.setPassword(this.myDataSource, local.getPassword(tempDataSource));
        dc.setSshPassword(this.myDataSource, local.getSshPassword(tempDataSource));
        dc.setSshPassphrase(this.myDataSource, local.getSshPassphrase(tempDataSource));
    }

    public void resetFromTemp() {
        ((SettingsEditor)this.myController).bulkUpdate(() -> {
            this.myGeneralPanel.reset(this.myTempDataSource, false);
            this.mySchemasPanel.reset(this.myTempDataSource);
        });
    }

    @Override
    public void init() {
        ((SettingsEditor)this.myController).bulkUpdate(() -> this.reset((LocalDataSource)this.getTarget(), false));
    }

    @Override
    protected void reset(@NotNull LocalDataSource o) {
        if (o == null) {
            DataSourceConfigurable.$$$reportNull$$$0(14);
        }
        this.reset(o, true);
    }

    private void reset(@NotNull LocalDataSource o, boolean resetCredentials) {
        if (o == null) {
            DataSourceConfigurable.$$$reportNull$$$0(15);
        }
        this.setGlobal(o.isGlobal());
        this.myGeneralPanel.reset(o, resetCredentials);
        this.myAdvancedPanel.setProperties(o.getDriverProperties());
        this.myAdvancedPanel.setVmOptions(o.getVmOptions());
        this.myAdvancedPanel.setVmEnv(o.getVmEnv());
        this.myNameComponent.reset(o, (Computable<String>)((Computable)() -> this.myGeneralPanel.generateNameFromParameters()));
        this.mySshSslPanel.reset(o, resetCredentials);
        this.myOptionsPanel.reset(o);
        this.mySchemasPanel.reset(o);
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        LocalDataSource tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((LocalDataSource)this.myDataSource).getName())) {
            return true;
        }
        if (!tempDataSource.equalConfiguration((LocalDataSource)this.myDataSource)) {
            return true;
        }
        if (this.myGeneralPanel.isPasswordChanged()) {
            return true;
        }
        if (this.mySshSslPanel.getSshPanel().isPasswordChanged() || this.mySshSslPanel.getSshPanel().isPassphraseChanged()) {
            return true;
        }
        return this.myNameComponent.isModified();
    }

    private boolean equalCredentials(LocalDataSource d1) {
        OneTimeString ssh2;
        OneTimeString ssh1;
        Credentials c2;
        Credentials c1;
        LocalDataSource d2 = (LocalDataSource)this.myDataSource;
        if (!d1.isAuthRequired() || !d2.isAuthRequired()) {
            return !d1.isAuthRequired() && !d2.isAuthRequired();
        }
        if (d1.getPasswordStorage() != d2.getPasswordStorage()) {
            return false;
        }
        if (!Comparing.equal((String)d1.getUsername(), (String)d2.getUsername())) {
            return false;
        }
        DatabaseCredentials cre1 = this.getSecretService();
        DatabaseCredentials cre2 = DatabaseCredentials.getInstance();
        if (this.myGeneralPanel.isPasswordChanged() && !Comparing.equal((Object)(c1 = cre1.getCredentials(d1)), (Object)(c2 = cre2.getCredentials(d2)))) {
            return false;
        }
        if (this.mySshSslPanel.getSshPanel().isPasswordChanged()) {
            ssh1 = cre1.getSshPassword(d1);
            return !Comparing.equal((CharSequence)ssh1, (CharSequence)(ssh2 = cre2.getSshPassword(d2)));
        }
        if (this.mySshSslPanel.getSshPanel().isPassphraseChanged()) {
            ssh1 = cre1.getSshPassphrase(d1);
            return !Comparing.equal((CharSequence)ssh1, (CharSequence)(ssh2 = cre2.getSshPassphrase(d2)));
        }
        return true;
    }

    public void showErrorNotification(String message2, @NotNull Object id) {
        if (id == null) {
            DataSourceConfigurable.$$$reportNull$$$0(16);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myController.showErrorNotification(this, id, message2 == null ? null : "Error", message2, new Object[0]));
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        DatabaseDriver prevActualDriver = this.myGeneralPanel.getActualDriver();
        this.myGeneralPanel.setDriver(driver);
        DatabaseDriver newActualDriver = this.myGeneralPanel.getActualDriver();
        if (prevActualDriver != newActualDriver) {
            this.myAdvancedPanel.migrateDriver(prevActualDriver, newActualDriver);
        }
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    @NotNull
    private MyTestAction createTestAction() {
        MyTestAction myTestAction = new MyTestAction();
        if (myTestAction == null) {
            DataSourceConfigurable.$$$reportNull$$$0(17);
        }
        return myTestAction;
    }

    public Action getTestAction() {
        return this.myTestAction;
    }

    public void actualizeDriver() {
        this.setDriver(this.getDriver());
    }

    @Nullable
    DatabaseDriver getDriver() {
        return this.myGeneralPanel.getDriver();
    }

    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.myGeneralPanel.getUrlEditorModel().getMeaningfulParser();
    }

    @NotNull
    public ParametersHolder getActualParameter() {
        UrlEditorModel urlEditorModel = this.myGeneralPanel.getUrlEditorModel();
        if (urlEditorModel == null) {
            DataSourceConfigurable.$$$reportNull$$$0(18);
        }
        return urlEditorModel;
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceConfigurable.$$$reportNull$$$0(19);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.setSourceLoading(mode);
        }
    }

    @Nullable
    public String getVisiblePassword() {
        char[] chars = this.myGeneralPanel.getUrlEditor().getAuthPanel().getVisiblePassword();
        return chars == null ? null : new String(chars);
    }

    public void enterPassword(@Nullable String password) {
        this.myGeneralPanel.getUrlEditor().getAuthPanel().setPassword(password);
    }

    @Nullable
    public String getVisibleSshPassword() {
        return this.mySshSslPanel.getSshPanel().getVisiblePassword();
    }

    public void enterSshPassword(@Nullable String password) {
        this.mySshSslPanel.getSshPanel().setPassword(password);
    }

    @Nullable
    public String getVisibleSshPassphrase() {
        return this.mySshSslPanel.getSshPanel().getVisiblePassphrase();
    }

    public void enterSshPassphrase(@Nullable String password) {
        this.mySshSslPanel.getSshPanel().setPassphrase(password);
    }

    public void setPasswordStorage(LocalDataSource.Storage storage) {
        this.myGeneralPanel.getUrlEditor().getAuthPanel().setPasswordStorage(storage);
    }

    public void setSshPasswordStorage(LocalDataSource.Storage storage) {
        this.mySshSslPanel.getSshPanel().setPasswordStorage(storage);
    }

    public String getUrl() {
        return this.myGeneralPanel.getUrlEditor().getUrl();
    }

    public void setUrl(String url) {
        this.myGeneralPanel.getUrlEditor().setUrl(url, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedPane";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSourceForConnection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "performTestConnection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "pingDatabase";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestAction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateDatabaseInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pingDatabase";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "initTabbedPane";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTabIndex";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setGeneratedName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveGeneralSettings";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTestAction
    extends AbstractAction {
        private boolean myBusy;

        MyTestAction() {
            super(DatabaseMessages.message((String)"button.test.connection", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            if (e == null) {
                MyTestAction.$$$reportNull$$$0(0);
            }
            DataSourceConfigurable.this.testConnection(true);
        }

        public void setBusy(boolean busy) {
            boolean o = this.isEnabled();
            this.myBusy = busy;
            boolean n = this.isEnabled();
            this.firePropertyChange("enabled", o, n);
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && !this.myBusy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceConfigurable$MyTestAction", "actionPerformed"));
        }
    }

    private static class TestConnectionResult {
        long ping;
        boolean keepAliveResult;
        ThreeState sslState = ThreeState.UNSURE;

        private TestConnectionResult() {
        }
    }
}

