/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.GlobalSessionStateListener;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcConsoleProvider
extends PersistenceConsoleProvider {
    public boolean hasRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(0);
        }
        return false;
    }

    public boolean hasRunners(@NotNull PsiElement element2, @Nullable Editor editor) {
        PsiFile file;
        if (element2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(1);
        }
        if (DbImplUtil.getDataSourcesForExec(file = element2.getContainingFile(), true, false).isEmpty()) {
            return false;
        }
        return JdbcConsoleProvider.isSqlAtPlace(file, JdbcConsoleProvider.elementAt(file, element2, editor));
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(2);
        }
        List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
        if (list == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element2, @Nullable Editor editor) {
        PsiElement elementAt;
        PsiFile file;
        if (element2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(4);
        }
        if (!JdbcConsoleProvider.isSqlAtPlace(file = element2.getContainingFile(), elementAt = JdbcConsoleProvider.elementAt(file, element2, editor))) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JdbcConsoleProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        DatabaseSettings.ExecOption execOption = DatabaseSettings.getSettings().execOptions.get(0);
        List<PersistenceConsoleProvider.Runner> list = DatabaseRunners.createRunners(JdbcConsoleProvider.findScriptModel(file, elementAt, editor, execOption), true);
        if (list == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static JBIterable<JdbcConsole> getRunningConsoles(Project project) {
        JBIterable jBIterable = JBIterable.from(JdbcConsole.getActiveConsoles(project));
        if (jBIterable == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Nullable
    public static Info findScriptModel(@NotNull PsiFile file, @NotNull PsiElement elementAt, @Nullable Editor editor, @NotNull DatabaseSettings.ExecOption execOption) {
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(8);
        }
        if (elementAt == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(9);
        }
        if (execOption == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(10);
        }
        if (!JdbcConsoleProvider.isSqlAtPlace(file, elementAt)) {
            return null;
        }
        TextRange selectionRange = ScriptModelUtil.getSelectionForConsole(editor, execOption);
        Project project = file.getProject();
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)elementAt);
        if (documentWindow != null && elementAt.getContainingFile() instanceof SqlFile) {
            return JdbcConsoleProvider.findScriptModelInInjection(project, file, elementAt, editor, selectionRange, documentWindow, execOption);
        }
        return JdbcConsoleProvider.findScriptModelNoInject(project, file, editor, selectionRange, execOption);
    }

    @Nullable
    private static Info findScriptModelNoInject(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull TextRange selectionRange, @NotNull DatabaseSettings.ExecOption execOption) {
        Document document;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(11);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(12);
        }
        if (selectionRange == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(13);
        }
        if (execOption == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(14);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file.getVirtualFile())) {
            return null;
        }
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, virtualFile);
        ScriptModel model = console != null ? console.getScriptModel() : SqlPsiFacade.getInstance((Project)project).createScriptModel(file);
        ScriptModel m = ScriptModelUtil.adjustModelForSelection(model, document, selectionRange, execOption);
        return new Info(file, file, (EditorEx)editor, m, execOption, null);
    }

    @Nullable
    private static Info findScriptModelInInjection(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement elementAt, @Nullable Editor editor, @NotNull TextRange selection0, @NotNull DocumentWindow documentWindow, @NotNull DatabaseSettings.ExecOption execOption) {
        SqlFile sqlFile;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(15);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(16);
        }
        if (elementAt == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(17);
        }
        if (selection0 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(18);
        }
        if (documentWindow == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(19);
        }
        if (execOption == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(20);
        }
        if ((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)elementAt.getContainingFile(), SqlFile.class)) == null) {
            return null;
        }
        TextRange selectionInj = editor instanceof EditorWindow || editor == null ? selection0 : EditorUtil.getSelectionInAnyMode((Editor)InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)sqlFile));
        SyntaxTraverser s = (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)sqlFile)).withTraversal(TreeTraversal.LEAVES_DFS);
        StringBuilder unescaped = new StringBuilder();
        int count2 = s.traverse().size();
        int[] injectedOffsets = new int[count2 + 1];
        int[] copyOffsets = new int[count2 + 1];
        copyOffsets[0] = 0;
        injectedOffsets[0] = 0;
        int i2 = 1;
        int unescEnd = -1;
        int unescStart = -1;
        for (PsiElement e : s) {
            String leafText = InjectedLanguageUtil.getUnescapedLeafText((PsiElement)e, (boolean)false);
            if (leafText == null) continue;
            TextRange r = e.getTextRange();
            if (r.contains(selectionInj.getStartOffset())) {
                unescStart = unescaped.length() + selectionInj.getStartOffset() - r.getStartOffset();
            }
            if (r.contains(selectionInj.getEndOffset())) {
                unescEnd = unescaped.length() + selectionInj.getEndOffset() - r.getStartOffset();
            }
            unescaped.append(leafText);
            injectedOffsets[i2] = r.getEndOffset();
            copyOffsets[i2] = unescaped.length();
            ++i2;
        }
        if (unescStart < 0 || unescEnd < 0) {
            return null;
        }
        TextRange selectionRange = TextRange.create((int)unescStart, (int)unescEnd);
        SqlFile subFile = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)sqlFile.getSqlLanguage(), (CharSequence)unescaped.toString(), true, false);
        LightVirtualFile subVirtualFile = (LightVirtualFile)ObjectUtils.assertNotNull((Object)((LightVirtualFile)subFile.getVirtualFile()));
        subVirtualFile.setOriginalFile(PsiUtilCore.getVirtualFile((PsiElement)sqlFile));
        if (editor instanceof EditorImpl) {
            editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)sqlFile);
        }
        ScriptModel model = SqlPsiFacade.getInstance((Project)project).createScriptModel((PsiFile)subFile);
        ScriptModel m = ScriptModelUtil.adjustModelForSelection(model, (Document)documentWindow, selectionRange, execOption);
        return new Info(file, (PsiFile)subFile, (EditorEx)editor, m, execOption, (NotNullFunction<PsiElement, TextRange>)((NotNullFunction)dom -> JdbcConsoleProvider.calcRangeInInjected(dom, copyOffsets, injectedOffsets)));
    }

    @NotNull
    private static TextRange calcRangeInInjected(PsiElement e, int[] copy, int[] injected) {
        TextRange range = e.getTextRange();
        int i1 = Arrays.binarySearch(copy, range.getStartOffset());
        int i2 = Arrays.binarySearch(copy, range.getEndOffset());
        if (i1 < 0 || i2 < 0) {
            throw new IndexOutOfBoundsException(range + " not found in " + Arrays.toString(copy));
        }
        TextRange textRange = TextRange.create((int)injected[i1], (int)injected[i2]);
        if (textRange == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(21);
        }
        return textRange;
    }

    public static void chooseStatements(final @NotNull Info info, @Nullable String nothingToRunText, boolean allowOutsideOption, final @NotNull Consumer<ScriptModel<?>> consumer2) {
        boolean noUI;
        if (info == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(22);
        }
        if (consumer2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(23);
        }
        DatabaseSettings.ExecOption execOption = info.execOption;
        final LinkedHashMap<PsiElement, TextRange> map2 = new LinkedHashMap<PsiElement, TextRange>();
        for (ScriptModel.StatementIt it2 : info.model.statements()) {
            if (map2.values().contains(it2.range())) continue;
            long offset = it2.rangeOffset();
            map2.put((PsiElement)it2.object(), (TextRange)new ScriptModel.ChosenRange(offset > 0L ? it2.range().shiftRight((int)offset) : it2.range()));
        }
        boolean modelAtCaret = info.model.getTextRange() instanceof ScriptModel.PositionRange;
        boolean mapEmptyOrBatches = JBIterable.from(map2.keySet()).filter(modelAtCaret ? Conditions.not((Condition)Conditions.instanceOf((Class[])new Class[]{SqlBatchBlock.class, SqlFile.class})) : Conditions.alwaysTrue()).isEmpty();
        boolean bl = noUI = nothingToRunText == null;
        if (mapEmptyOrBatches) {
            boolean doDefault = true;
            int option = allowOutsideOption ? execOption.execOutside : -1;
            TextRange range = info.model.getTextRange();
            ScriptModel m = info.model.subModel(null);
            if (modelAtCaret && !m.statements().isEmpty()) {
                TextRange tailRange;
                ScriptModel m1;
                TextRange r;
                if (option == 1) {
                    doDefault = false;
                } else if (option == 2) {
                    consumer2.consume((Object)m);
                    doDefault = false;
                } else if (option == 3 && (r = (TextRange)m.statements().transform(ScriptModelUtil.TO_RANGE).last()) != null && range.getStartOffset() < r.getEndOffset() && !(m1 = m.subModel(tailRange = TextRange.create((int)range.getStartOffset(), (int)r.getEndOffset()))).statements().isEmpty()) {
                    consumer2.consume((Object)m1);
                    doDefault = false;
                }
            }
            if (!doDefault) {
                return;
            }
            if (noUI) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showErrorHint((Editor)info.editor, nothingToRunText));
        } else if (!modelAtCaret) {
            consumer2.consume(info.model);
        } else {
            PsiElement element2;
            int option = execOption.execInside;
            boolean doDefault = true;
            if (option == 2 || option == 1 && noUI) {
                element2 = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).filter(Conditions.instanceOf(SqlStatement.class)).first();
                consumer2.consume((Object)info.model.subModel((TextRange)map2.get(element2)));
                doDefault = false;
            } else if (option == 3) {
                element2 = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).filter(Conditions.instanceOf(SqlStatement.class)).last();
                consumer2.consume((Object)info.model.subModel((TextRange)map2.get(element2)));
                doDefault = false;
            } else if (option == 4) {
                element2 = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).filter(Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlBatchBlock.class})).last();
                consumer2.consume((Object)info.model.subModel((TextRange)map2.get(element2)));
                doDefault = false;
            } else if (option == 5) {
                consumer2.consume((Object)info.model.subModel(null));
                doDefault = false;
            } else if (option == 6) {
                element2 = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).filter(Conditions.instanceOf(SqlStatement.class)).last();
                TextRange range = TextRange.create((int)((TextRange)map2.get(element2)).getStartOffset(), (int)info.file.getTextLength());
                consumer2.consume((Object)info.model.subModel(range));
                doDefault = false;
            } else if (map2.size() == 1) {
                consumer2.consume((Object)info.model.subModel((TextRange)ContainerUtil.getFirstItem(map2.values())));
                doDefault = false;
            }
            if (!doDefault) {
                return;
            }
            if (!info.editor.getComponent().isShowing()) {
                return;
            }
            Pass<PsiElement> pass = new Pass<PsiElement>(){

                public void pass(PsiElement element2) {
                    consumer2.consume((Object)info.model.subModel((TextRange)map2.get(element2)));
                }
            };
            PsiElement selection = (PsiElement)JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).filter(Conditions.instanceOf(SqlStatement.class)).first();
            List<PsiElement> items = JdbcConsoleProvider.smallToLarge(map2);
            IntroduceTargetChooser.showChooser((Editor)info.editor, items, (Pass)pass, expression -> StringUtil.first((String)expression.getText().replaceAll("\\s+", " "), (int)50, (boolean)true), (String)"Statements", (int)items.indexOf(selection), (NotNullFunction)((NotNullFunction)ObjectUtils.notNull(info.ranger, (Object)ScopeHighlighter.NATURAL_RANGER)));
        }
    }

    @NotNull
    private static List<PsiElement> smallToLarge(@NotNull Map<PsiElement, TextRange> map2) {
        if (map2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(24);
        }
        List list = ContainerUtil.reverse(new ArrayList<PsiElement>(map2.keySet()));
        if (list == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(25);
        }
        return list;
    }

    public static boolean isSqlAtPlace(@Nullable PsiFile file, @Nullable Editor editor) {
        return JdbcConsoleProvider.isSqlAtPlace(file, JdbcConsoleProvider.elementAt(file, null, editor));
    }

    private static boolean isSqlAtPlace(@Nullable PsiFile file, @Nullable PsiElement elementAt) {
        boolean isInjected = elementAt != null && InjectedLanguageUtil.getDocumentWindow((PsiElement)elementAt) != null;
        return isInjected && PsiTreeUtil.getContextOfType((PsiElement)elementAt, (Class[])new Class[]{SqlFile.class}) != null || file instanceof SqlFile || file != null && file.getFileType() == SqlFileType.INSTANCE;
    }

    @Contract(value="null, _, _->null; _, null, null->null")
    public static PsiElement elementAt(@Nullable PsiFile file, @Nullable PsiElement element2, @Nullable Editor editor) {
        int offset;
        int n = offset = file == null ? -1 : JdbcConsoleProvider.getOffset(element2, editor);
        if (offset < 0) {
            return null;
        }
        if (file instanceof SqlFile) {
            PsiElement e = file.findElementAt(offset);
            return e != null || offset == 0 ? e : file.findElementAt(offset - 1);
        }
        PsiElement e = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)offset);
        return e != null || offset == 0 ? e : InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)(offset - 1));
    }

    private static int getOffset(@Nullable PsiElement element2, @Nullable Editor editor) {
        if (editor != null) {
            return editor.getCaretModel().getOffset();
        }
        if (element2 != null) {
            return element2.getTextRange().getStartOffset();
        }
        return -1;
    }

    public static void doRunQueryInConsole(@NotNull JdbcConsole console, @NotNull Info info) {
        if (console == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(26);
        }
        if (info == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(27);
        }
        JdbcConsoleProvider.chooseStatements(info, "Nothing to run", true, scriptModel -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            if (((EditorEx)ObjectUtils.notNull((Object)info.editor)).isDisposed()) {
                return;
            }
            if (!console.isValid()) {
                return;
            }
            if (console.beforeExecuteQueries((ScriptModel<?>)scriptModel)) {
                VirtualFile file = info.editor.getVirtualFile();
                SearchPath before2 = null;
                try {
                    if (DbImplUtil.isDatabaseVirtualFile(file)) {
                        SearchPath searchPath = DatabaseEditorHelper.dbSrcSearchPath(console.getProject(), file, false);
                        searchPath = DbImplUtil.getAutoSwitchPath(console.getDataSource(), searchPath);
                        before2 = JdbcConsoleProvider.ensureSearchPath(console, searchPath);
                    }
                    console.executeQueries((Editor)info.editor, (ScriptModel<?>)scriptModel, info.execOption);
                }
                finally {
                    JdbcConsoleProvider.ensureSearchPath(console, before2);
                }
            }
        });
    }

    @Nullable
    private static SearchPath ensureSearchPath(@NotNull JdbcConsole console, @Nullable SearchPath searchPath) {
        if (console == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(28);
        }
        SearchPath currentPath = console.getSearchPath();
        if (searchPath != null && !searchPath.equals((Object)currentPath)) {
            console.switchSchema(searchPath, false);
        }
        return currentPath;
    }

    public static void detachConsole(@NotNull Project project, @NotNull VirtualFile file) {
        JdbcConsole console;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(29);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(30);
        }
        if ((console = JdbcConsoleProvider.getConsole(project, file)) != null) {
            Disposer.dispose((Disposable)console);
        }
    }

    @Nullable
    public static JdbcConsole attachConsole(@NotNull Project project, @Nullable DatabaseSession session2, @NotNull VirtualFile file) {
        JdbcConsole console;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(31);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(32);
        }
        if (!JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file) || !file.isValid()) {
            return null;
        }
        JdbcConsole old = JdbcConsoleProvider.getConsole(project, file);
        DatabaseSession oldSession = old == null ? null : old.getSession();
        JdbcConsoleProvider.detachConsole(project, file);
        JdbcConsole jdbcConsole = console = session2 == null ? null : JdbcConsoleProvider.createConsole(project, session2, file, oldSession);
        if (console != null) {
            ChooseSchemaAction.scheduleSavedSchemaSwitch(console);
        }
        DatabaseEditorHelper.configureConsoleToolbar(project, console, file);
        if (console == null) {
            DatabaseEditorHelper.removeConsoleToolbar(project, file);
        }
        TransactionGuard.submitTransaction((Disposable)project, () -> FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file}));
        return console;
    }

    @NotNull
    private static JdbcConsole createConsole(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull VirtualFile file, @Nullable DatabaseSession oldSession) {
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(33);
        }
        if (session2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(34);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(35);
        }
        JdbcConsole jdbcConsole = JdbcConsole.newConsole(project).fromDataSource((DasDataSource)session2.getTarget()).forFile(file).useSession(session2).insteadOf(oldSession).build();
        if (jdbcConsole == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(36);
        }
        return jdbcConsole;
    }

    public static boolean isItPossibleToAttachConsoleTo(@NotNull VirtualFile file) {
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(37);
        }
        return !DbImplUtil.isTableFile(file) && !SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file);
    }

    @Nullable
    public static JdbcConsole getValidConsole(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null || file.isDirectory()) {
            return null;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file)) {
            return null;
        }
        JdbcConsole console = JdbcConsoleProvider.getConsole(project, file);
        return console != null && console.isValid() ? console : null;
    }

    @Nullable
    public static JdbcConsole getConsole(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(38);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(39);
        }
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            if (!console.getVirtualFile().equals(file)) continue;
            return console;
        }
        return null;
    }

    @Nullable
    public static DatabaseSession findOrCreateSession(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file)) {
            return null;
        }
        GlobalSessionStateListener.SavedSession sessionInfo = GlobalSessionStateListener.getSessionInfo(project, file);
        if (sessionInfo == null) {
            return null;
        }
        LocalDataSource dataSource = sessionInfo.getDataSource();
        String sessionTitle = sessionInfo.getSessionName();
        if (!sessionInfo.getStrict()) {
            return DatabaseSessionManager.getSession(project, dataSource, sessionTitle);
        }
        return DatabaseSessionManager.getExactSession(project, dataSource, sessionTitle);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsoleProvider";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 11: 
            case 15: 
            case 29: 
            case 31: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection0";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsoleProvider";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningConsoles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRangeInInjected";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "smallToLarge";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasRunners";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 36: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findScriptModel";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findScriptModelNoInject";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findScriptModelInInjection";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "chooseStatements";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "smallToLarge";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doRunQueryInConsole";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureSearchPath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "detachConsole";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "attachConsole";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isItPossibleToAttachConsoleTo";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 25: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Info {
        public final PsiFile originalFile;
        public final PsiFile file;
        public final ScriptModel<?> model;
        public final EditorEx editor;
        public final DatabaseSettings.ExecOption execOption;
        public final NotNullFunction<PsiElement, TextRange> ranger;

        public Info(PsiFile originalFile, PsiFile file, EditorEx editor, ScriptModel<?> model, DatabaseSettings.ExecOption execOption, NotNullFunction<PsiElement, TextRange> ranger) {
            this.originalFile = originalFile;
            this.file = file;
            this.model = model;
            this.editor = editor;
            this.execOption = execOption;
            this.ranger = ranger;
        }
    }
}

