/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project.actions;

import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.uml.project.ui.ModulesListCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class ModulesChooseByNameModel
extends SimpleChooseByNameModel
implements DumbAware {
    private final Map<String, Module> modules;
    private final Map<String, Library> libraries;

    ModulesChooseByNameModel(@NotNull Project project) {
        if (project == null) {
            ModulesChooseByNameModel.$$$reportNull$$$0(0);
        }
        super(project, "Enter module name", null);
        this.modules = new HashMap<String, Module>();
        this.libraries = new HashMap<String, Library>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            this.modules.put(module.getName(), module);
        }
        for (Module module : LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries()) {
            this.libraries.put(module.getName(), (Library)module);
        }
    }

    public String[] getNames() {
        return ArrayUtil.mergeArrays((String[])ArrayUtilRt.toStringArray(this.modules.keySet()), (String[])ArrayUtilRt.toStringArray(this.libraries.keySet()));
    }

    protected Object[] getElementsByName(String name, String pattern) {
        Object[] objectArray;
        Module module = this.modules.get(name);
        Library library = this.libraries.get(name);
        if (module == null && library == null) {
            objectArray = AnAction.EMPTY_ARRAY;
        } else if (module != null && library == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = module;
        } else if (module == null) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = library;
        } else {
            Object[] objectArray4 = new Object[2];
            objectArray4[0] = module;
            objectArray = objectArray4;
            objectArray4[1] = library;
        }
        return objectArray;
    }

    @NotNull
    public ListCellRenderer getListCellRenderer() {
        ModulesListCellRenderer modulesListCellRenderer = new ModulesListCellRenderer();
        if (modulesListCellRenderer == null) {
            ModulesChooseByNameModel.$$$reportNull$$$0(1);
        }
        return modulesListCellRenderer;
    }

    public String getElementName(@NotNull Object element) {
        if (element == null) {
            ModulesChooseByNameModel.$$$reportNull$$$0(2);
        }
        return element instanceof Module ? ((Module)element).getName() : (element instanceof Library ? ((Library)element).getName() : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/project/actions/ModulesChooseByNameModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/project/actions/ModulesChooseByNameModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

