/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.presentation;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;

public class DiagramSelectionModePresentationModelImpl
extends DiagramPresentationModelImpl {
    public DiagramSelectionModePresentationModelImpl(Graph2D graph, Project project, DiagramProvider provider) {
        super(graph, project, provider);
        graph.addGraph2DSelectionListener(new Graph2DSelectionListener(){

            public void onGraph2DSelectionEvent(Graph2DSelectionEvent e) {
                if (e.isNodeSelection()) {
                    ApplicationManager.getApplication().invokeLater(() -> DiagramSelectionModePresentationModelImpl.this.updateDataModel());
                }
            }
        });
    }

    private void updateDataModel() {
        DiagramBuilder builder = this.getBuilder();
        DiagramDataModel dataModel = builder.getDataModel();
        if (DiagramUtils.isSelectionMode((DiagramBuilder)builder) || builder.getPresentation().isCategoryEnabled(CommonDiagramExtras.PATH_TO_ROOT)) {
            dataModel.refreshDataModel();
            builder.updateGraph();
            builder.getGraph().fitGraph2DView();
        }
    }
}

