/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.indexing.SubstitutedFileType;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends UserDataHolderBase
implements PsiDependentFileContent {
    private final VirtualFile myFile;
    private final String myFileName;
    private final FileType myFileType;
    private Charset myCharset;
    private byte[] myContent;
    private CharSequence myContentAsText;
    private final long myStamp;
    private byte[] myHash;
    private boolean myLighterASTShouldBeThreadSafe;
    private final boolean myPhysicalContent;
    private static final Key<PsiFile> CACHED_PSI = Key.create((String)"cached psi from content");

    public FileContentImpl(@NotNull VirtualFile file2, @NotNull CharSequence contentAsText, long documentStamp) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(0);
        }
        if (contentAsText == null) {
            FileContentImpl.$$$reportNull$$$0(1);
        }
        this(file2, contentAsText, null, documentStamp, false);
    }

    public FileContentImpl(@NotNull VirtualFile file2, @NotNull byte[] content2) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(2);
        }
        if (content2 == null) {
            FileContentImpl.$$$reportNull$$$0(3);
        }
        this(file2, null, content2, -1L, true);
    }

    FileContentImpl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(4);
        }
        this(file2, null, null, -1L, true);
    }

    /*
     * WARNING - void declaration
     */
    private FileContentImpl(@NotNull VirtualFile file2, CharSequence contentAsText, byte[] content2, long stamp, boolean bl) {
        void physicalContent;
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(5);
        }
        this.myFile = file2;
        this.myContentAsText = contentAsText;
        this.myContent = content2;
        this.myFileType = file2.getFileType();
        this.myFileName = file2.getName();
        this.myStamp = stamp;
        this.myPhysicalContent = physicalContent;
    }

    public Project getProject() {
        return (Project)this.getUserData(IndexingDataKeys.PROJECT);
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.getPsiFileForPsiDependentIndex();
        if (psiFile == null) {
            FileContentImpl.$$$reportNull$$$0(6);
        }
        return psiFile;
    }

    @NotNull
    private PsiFile getFileFromText() {
        PsiFile psi = (PsiFile)this.getUserData(IndexingDataKeys.PSI_FILE);
        if (psi == null) {
            psi = (PsiFile)this.getUserData(CACHED_PSI);
        }
        if (psi == null) {
            psi = this.createFileFromText(this.getContentAsText());
            psi.putUserData(IndexingDataKeys.VIRTUAL_FILE, (Object)this.getFile());
            this.putUserData(CACHED_PSI, psi);
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            FileContentImpl.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    @NotNull
    public LighterAST getLighterAST() {
        LighterAST lighterAST = (LighterAST)this.getUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY);
        if (lighterAST == null) {
            FileASTNode node = this.getPsiFile().getNode();
            lighterAST = this.myLighterASTShouldBeThreadSafe ? new TreeBackedLighterAST(node) : node.getLighterAST();
            this.putUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY, lighterAST);
        }
        LighterAST lighterAST2 = lighterAST;
        if (lighterAST2 == null) {
            FileContentImpl.$$$reportNull$$$0(8);
        }
        return lighterAST2;
    }

    void ensureThreadSafeLighterAST() {
        this.myLighterASTShouldBeThreadSafe = true;
    }

    public PsiFile createFileFromText(@NotNull CharSequence text2) {
        Project project;
        if (text2 == null) {
            FileContentImpl.$$$reportNull$$$0(9);
        }
        if ((project = this.getProject()) == null) {
            project = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        return FileContentImpl.createFileFromText(project, text2, (LanguageFileType)this.getFileTypeWithoutSubstitution(), this.myFile, this.myFileName);
    }

    @NotNull
    public static PsiFile createFileFromText(@NotNull Project project, @NotNull CharSequence text2, @NotNull LanguageFileType fileType, @NotNull VirtualFile file2, @NotNull String fileName2) {
        if (project == null) {
            FileContentImpl.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            FileContentImpl.$$$reportNull$$$0(11);
        }
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(13);
        }
        if (fileName2 == null) {
            FileContentImpl.$$$reportNull$$$0(14);
        }
        Language language = fileType.getLanguage();
        Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, file2, project);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName2, substitutedLanguage, text2, false, false, false, file2);
        if (psiFile == null) {
            throw new IllegalStateException("psiFile is null. language = " + language.getID() + ", substitutedLanguage = " + substitutedLanguage.getID());
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            FileContentImpl.$$$reportNull$$$0(15);
        }
        return psiFile2;
    }

    @NotNull
    private FileType getSubstitutedFileType() {
        FileType fileType = SubstitutedFileType.substituteFileType(this.myFile, this.myFileType, this.getProject());
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(16);
        }
        return fileType;
    }

    public static FileContent createByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileContentImpl.$$$reportNull$$$0(17);
        }
        try {
            return new FileContentImpl(file2, file2.contentsToByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private FileType getFileTypeWithoutSubstitution() {
        return this.myFileType;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getSubstitutedFileType();
        if (fileType == null) {
            FileContentImpl.$$$reportNull$$$0(18);
        }
        return fileType;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            FileContentImpl.$$$reportNull$$$0(19);
        }
        return virtualFile;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            FileContentImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            this.myCharset = charset = this.myFile.getCharset();
        }
        Charset charset2 = charset;
        if (charset2 == null) {
            FileContentImpl.$$$reportNull$$$0(21);
        }
        return charset2;
    }

    public long getStamp() {
        return this.myStamp;
    }

    @NotNull
    public byte[] getContent() {
        byte[] content2 = this.myContent;
        if (content2 == null) {
            this.myContent = content2 = this.myContentAsText.toString().getBytes(this.getCharset());
        }
        if (content2 == null) {
            FileContentImpl.$$$reportNull$$$0(22);
        }
        return content2;
    }

    @NotNull
    public CharSequence getContentAsText() {
        if (this.myFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + this.myFileType.getDescription());
        }
        CharSequence content2 = (CharSequence)this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content2 != null) {
            CharSequence charSequence = content2;
            if (charSequence == null) {
                FileContentImpl.$$$reportNull$$$0(23);
            }
            return charSequence;
        }
        CharSequence contentAsText = this.myContentAsText;
        if (contentAsText == null) {
            this.myContentAsText = contentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myFile);
            this.myContent = null;
        }
        CharSequence charSequence = contentAsText;
        if (charSequence == null) {
            FileContentImpl.$$$reportNull$$$0(24);
        }
        return charSequence;
    }

    public String toString() {
        return this.myFileName;
    }

    @Nullable
    public byte[] getHash() {
        return this.myHash;
    }

    public void setHash(byte[] hash) {
        this.myHash = hash;
    }

    @Deprecated
    @NotNull
    public PsiFile getPsiFileForPsiDependentIndex() {
        PsiFile existingPsi;
        PsiDocumentManager psiDocumentManager;
        Document document;
        PsiFile psi = null;
        if (!this.myPhysicalContent && (document = FileDocumentManager.getInstance().getCachedDocument(this.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject())).isUncommited(document) && (existingPsi = psiDocumentManager.getPsiFile(document)) != null) {
            psi = existingPsi;
        }
        if (psi == null) {
            psi = this.getFileFromText();
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            FileContentImpl.$$$reportNull$$$0(25);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentAsText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileContentImpl";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileContentImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileFromText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLighterAST";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutedFileType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentAsText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFileForPsiDependentIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createByFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IllegalDataException
    extends RuntimeException {
        IllegalDataException(String message) {
            super(message);
        }
    }
}

