/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveRelatedFilesHandler
extends MoveFilesOrDirectoriesHandler {
    @Override
    public boolean canMove(PsiElement[] elements2, PsiElement targetContainer, @Nullable PsiReference reference2) {
        if (!super.canMove(elements2, targetContainer, reference2)) {
            return false;
        }
        for (PsiElement element : elements2) {
            if (!(element instanceof PsiFile) || ((PsiFile)element).getVirtualFile() == null || NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), ((PsiFile)element).getVirtualFile()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PsiElement[] adjustForMove(@NotNull Project project, @NotNull PsiElement[] sourceElements, @Nullable PsiElement targetElement) {
        if (project == null) {
            MoveRelatedFilesHandler.$$$reportNull$$$0(0);
        }
        if (sourceElements == null) {
            MoveRelatedFilesHandler.$$$reportNull$$$0(1);
        }
        if ((sourceElements = super.adjustForMove(project, sourceElements, targetElement)) == null) {
            return null;
        }
        THashSet relatedFilesToMove = new THashSet();
        for (PsiElement element : sourceElements) {
            VirtualFile file2;
            if (!(element instanceof PsiFile) || (file2 = ((PsiFile)element).getVirtualFile()) == null) continue;
            Collection<NestingTreeStructureProvider.ChildFileInfo> relatedFileInfos = NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), file2);
            for (NestingTreeStructureProvider.ChildFileInfo info : relatedFileInfos) {
                PsiFile psiFile = element.getManager().findFile(info.file);
                if (psiFile == null || ArrayUtil.contains((Object)psiFile, (Object[])sourceElements)) continue;
                relatedFilesToMove.add(psiFile);
            }
        }
        if (!relatedFilesToMove.isEmpty()) {
            int ok;
            String message = relatedFilesToMove.size() == 1 ? RefactoringBundle.message((String)"ask.to.move.related.file", (Object[])new Object[]{((PsiFile)relatedFilesToMove.iterator().next()).getName()}) : RefactoringBundle.message((String)"ask.to.move.related.files", (Object[])new Object[]{StringUtil.join((Collection)relatedFilesToMove, PsiFileSystemItem::getName, (String)", ")});
            int n = ok = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)project, (String)message, (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon());
            if (ok == 0) {
                PsiElement[] result2 = new PsiElement[sourceElements.length + relatedFilesToMove.size()];
                System.arraycopy(sourceElements, 0, result2, 0, sourceElements.length);
                Iterator iterator = relatedFilesToMove.iterator();
                for (int i = sourceElements.length; i < result2.length; ++i) {
                    result2[i] = (PsiElement)iterator.next();
                }
                return result2;
            }
        }
        return sourceElements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceElements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveRelatedFilesHandler";
        objectArray[2] = "adjustForMove";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

