/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CachedValueBase;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public abstract class PsiCachedValue<T>
extends CachedValueBase<T> {
    private static final Key<?> PSI_MOD_COUNT_OPTIMIZATION = Key.create((String)"PSI_MOD_COUNT_OPTIMIZATION");
    private final PsiManager myManager;

    PsiCachedValue(@NotNull PsiManager manager, boolean trackValue) {
        if (manager == null) {
            PsiCachedValue.$$$reportNull$$$0(0);
        }
        super(trackValue);
        this.myManager = manager;
    }

    @Override
    @NotNull
    protected Object[] normalizeDependencies(@NotNull CachedValueProvider.Result<T> result2) {
        Object[] dependencies;
        if (result2 == null) {
            PsiCachedValue.$$$reportNull$$$0(1);
        }
        if ((dependencies = super.normalizeDependencies(result2)).length > 0 && ContainerUtil.and((Object[])dependencies, this::anyChangeImpliesPsiCounterChange)) {
            Object[] objectArray = ArrayUtil.prepend(PSI_MOD_COUNT_OPTIMIZATION, (Object[])dependencies);
            if (objectArray == null) {
                PsiCachedValue.$$$reportNull$$$0(2);
            }
            return objectArray;
        }
        if (dependencies == null) {
            PsiCachedValue.$$$reportNull$$$0(3);
        }
        return dependencies;
    }

    private boolean anyChangeImpliesPsiCounterChange(@NotNull Object dependency) {
        if (dependency == null) {
            PsiCachedValue.$$$reportNull$$$0(4);
        }
        return dependency instanceof PsiElement && this.isVeryPhysical((PsiElement)dependency) || dependency instanceof ProjectRootModificationTracker || dependency instanceof PsiModificationTracker || dependency == PsiModificationTracker.MODIFICATION_COUNT || dependency == PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT || dependency == PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT;
    }

    private boolean isVeryPhysical(@NotNull PsiElement dependency) {
        if (dependency == null) {
            PsiCachedValue.$$$reportNull$$$0(5);
        }
        if (!dependency.isValid()) {
            return false;
        }
        if (!dependency.isPhysical()) {
            return false;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.myManager.getProject());
        if (manager == null) {
            return false;
        }
        PsiFile topLevelFile = manager.getTopLevelFile(dependency);
        return topLevelFile != null && topLevelFile.isPhysical();
    }

    @Override
    protected boolean isUpToDate(@NotNull CachedValueBase.Data data) {
        if (data == null) {
            PsiCachedValue.$$$reportNull$$$0(6);
        }
        if (this.myManager.isDisposed()) {
            return false;
        }
        Object[] dependencies = data.getDependencies();
        if (dependencies.length > 0 && dependencies[0] == PSI_MOD_COUNT_OPTIMIZATION && data.getTimeStamps()[0] == this.myManager.getModificationTracker().getModificationCount()) {
            return true;
        }
        return super.isUpToDate(data);
    }

    @Override
    protected boolean isDependencyOutOfDate(@NotNull Object dependency, long oldTimeStamp) {
        if (dependency == null) {
            PsiCachedValue.$$$reportNull$$$0(7);
        }
        if (dependency == PSI_MOD_COUNT_OPTIMIZATION) {
            return false;
        }
        return super.isDependencyOutOfDate(dependency, oldTimeStamp);
    }

    @Override
    protected long getTimeStamp(@NotNull Object dependency) {
        if (dependency == null) {
            PsiCachedValue.$$$reportNull$$$0(8);
        }
        if (dependency instanceof PsiDirectory) {
            return this.myManager.getModificationTracker().getOutOfCodeBlockModificationCount();
        }
        if (dependency instanceof PsiElement) {
            PsiElement element = (PsiElement)dependency;
            if (!element.isValid()) {
                return -1L;
            }
            PsiFile containingFile = element.getContainingFile();
            if (containingFile != null) {
                return containingFile.getModificationStamp();
            }
        }
        if (dependency == PsiModificationTracker.MODIFICATION_COUNT || dependency == PSI_MOD_COUNT_OPTIMIZATION) {
            return this.myManager.getModificationTracker().getModificationCount();
        }
        if (dependency == PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getOutOfCodeBlockModificationCount();
        }
        if (dependency == PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT) {
            return this.myManager.getModificationTracker().getJavaStructureModificationCount();
        }
        return super.getTimeStamp(dependency);
    }

    @Override
    public boolean isFromMyProject(@NotNull Project project) {
        if (project == null) {
            PsiCachedValue.$$$reportNull$$$0(9);
        }
        return this.myManager.getProject() == project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiCachedValue";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiCachedValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalizeDependencies";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "anyChangeImpliesPsiCounterChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isVeryPhysical";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOutOfDate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFromMyProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

