/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

abstract class FileIndexBase
implements FileIndex {
    private final FileTypeRegistry myFileTypeRegistry;
    final DirectoryIndex myDirectoryIndex;

    FileIndexBase(@NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (directoryIndex == null) {
            FileIndexBase.$$$reportNull$$$0(0);
        }
        if (fileTypeManager == null) {
            FileIndexBase.$$$reportNull$$$0(1);
        }
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = fileTypeManager;
    }

    protected abstract boolean isScopeDisposed();

    public boolean iterateContent(@NotNull ContentIterator processor2) {
        if (processor2 == null) {
            FileIndexBase.$$$reportNull$$$0(2);
        }
        return this.iterateContent(processor2, null);
    }

    public boolean iterateContentUnderDirectory(final @NotNull VirtualFile dir, final @NotNull ContentIterator processor2, final @Nullable VirtualFileFilter customFilter) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            FileIndexBase.$$$reportNull$$$0(4);
        }
        VirtualFileVisitor.Result result2 = VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DirectoryInfo info = (DirectoryInfo)ReadAction.compute(() -> FileIndexBase.this.getInfoForFileOrDirectory(file2));
                if (file2.isDirectory() && info.isExcluded(file2)) {
                    if (!info.processContentBeneathExcluded(file2, (Processor<? super VirtualFile>)((Processor)content2 -> FileIndexBase.this.iterateContentUnderDirectory((VirtualFile)content2, processor2, customFilter)))) {
                        VirtualFileVisitor.Result result2 = 1.skipTo((VirtualFile)dir);
                        if (result2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return result2;
                    }
                    VirtualFileVisitor.Result result3 = SKIP_CHILDREN;
                    if (result3 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result3;
                }
                boolean accepted = (Boolean)ReadAction.compute(() -> !FileIndexBase.this.isScopeDisposed() && FileIndexBase.this.isInContent(file2, info)) != false && (customFilter == null || customFilter.accept(file2));
                VirtualFileVisitor.Result result4 = !accepted || processor2.processFile(file2) ? CONTINUE : 1.skipTo((VirtualFile)dir);
                if (result4 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return result4;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return !Comparing.equal((Object)result2.skipToParent, (Object)dir);
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator processor2) {
        if (dir == null) {
            FileIndexBase.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            FileIndexBase.$$$reportNull$$$0(6);
        }
        return this.iterateContentUnderDirectory(dir, processor2, null);
    }

    boolean isTestSourcesRoot(@NotNull DirectoryInfo info) {
        JpsModuleSourceRootType<?> rootType;
        if (info == null) {
            FileIndexBase.$$$reportNull$$$0(7);
        }
        return (rootType = this.myDirectoryIndex.getSourceRootType(info)) != null && rootType.isForTests();
    }

    @NotNull
    public DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(8);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        file2 = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file2);
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file2);
        if (directoryInfo == null) {
            FileIndexBase.$$$reportNull$$$0(9);
        }
        return directoryInfo;
    }

    public boolean isContentSourceFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(10);
        }
        return !file2.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file2) && this.isInSourceContent(file2);
    }

    @NotNull
    static VirtualFile[][] getModuleContentAndSourceRoots(@NotNull Module module) {
        if (module == null) {
            FileIndexBase.$$$reportNull$$$0(11);
        }
        VirtualFile[][] virtualFileArrayArray = new VirtualFile[][]{ModuleRootManager.getInstance((Module)module).getContentRoots(), ModuleRootManager.getInstance((Module)module).getSourceRoots()};
        if (virtualFileArrayArray == null) {
            FileIndexBase.$$$reportNull$$$0(12);
        }
        return virtualFileArrayArray;
    }

    protected boolean isInContent(@NotNull VirtualFile file2, @NotNull DirectoryInfo info) {
        if (file2 == null) {
            FileIndexBase.$$$reportNull$$$0(13);
        }
        if (info == null) {
            FileIndexBase.$$$reportNull$$$0(14);
        }
        return ProjectFileIndexImpl.isFileInContent(file2, info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/FileIndexBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFileOrDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentAndSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateContentUnderDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTestSourcesRoot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFileOrDirectory";
                break;
            }
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isContentSourceFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleContentAndSourceRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

