/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.editor.richcopy.model.ColorRegistry;
import com.intellij.openapi.editor.richcopy.model.FontNameRegistry;
import com.intellij.openapi.editor.richcopy.model.MarkupHandler;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.AbstractSyntaxAwareInputStreamTransferableData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.MacColorSpaceLoader;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import org.jetbrains.annotations.NotNull;

public class RtfTransferableData
extends AbstractSyntaxAwareInputStreamTransferableData {
    public static final int PRIORITY = 100;
    public static final DataFlavor FLAVOR = new DataFlavor("text/rtf;class=java.io.InputStream", "RTF text");
    private static final String HEADER_PREFIX = "{\\rtf1\\ansi\\deff0";
    private static final String HEADER_SUFFIX = "}";
    private static final String TAB = "\\tab\n";
    private static final String NEW_LINE = SystemInfo.isMac ? "\\\n" : "\\line\n";
    private static final String BOLD = "\\b";
    private static final String ITALIC = "\\i";

    public RtfTransferableData(@NotNull SyntaxInfo syntaxInfo) {
        if (syntaxInfo == null) {
            RtfTransferableData.$$$reportNull$$$0(0);
        }
        super(syntaxInfo, FLAVOR);
    }

    @Override
    protected void build(@NotNull StringBuilder holder, int maxLength) {
        if (holder == null) {
            RtfTransferableData.$$$reportNull$$$0(1);
        }
        holder.append(HEADER_PREFIX);
        holder.append("{\\colortbl;");
        ColorRegistry colorRegistry = this.mySyntaxInfo.getColorRegistry();
        for (int id : colorRegistry.getAllIds()) {
            Color color = (Color)colorRegistry.dataById(id);
            int[] components = RtfTransferableData.getAdjustedColorComponents(color);
            holder.append(String.format("\\red%d\\green%d\\blue%d;", components[0], components[1], components[2]));
        }
        holder.append("}\n");
        holder.append("{\\fonttbl");
        FontNameRegistry fontNameRegistry = this.mySyntaxInfo.getFontNameRegistry();
        for (int id : fontNameRegistry.getAllIds()) {
            String fontName = (String)fontNameRegistry.dataById(id);
            holder.append(String.format("{\\f%d %s;}", id, fontName));
        }
        holder.append("}\n");
        holder.append("\n\\s0\\box").append("\\cbpat").append(this.mySyntaxInfo.getDefaultBackground()).append("\\cb").append(this.mySyntaxInfo.getDefaultBackground()).append("\\cf").append(this.mySyntaxInfo.getDefaultForeground());
        RtfTransferableData.addFontSize(holder, this.mySyntaxInfo.getFontSize());
        holder.append('\n');
        this.mySyntaxInfo.processOutputInfo(new MyVisitor(holder, this.myRawText, this.mySyntaxInfo, maxLength));
        holder.append("\\par");
        holder.append(HEADER_SUFFIX);
    }

    private static int[] getAdjustedColorComponents(Color color) {
        ColorSpace genericRgbSpace;
        if (SystemInfo.isMac && (genericRgbSpace = MacColorSpaceLoader.getGenericRgbColorSpace()) != null) {
            float[] components = genericRgbSpace.fromRGB(color.getRGBColorComponents(null));
            return new int[]{RtfTransferableData.colorComponentFloatToInt(components[0]), RtfTransferableData.colorComponentFloatToInt(components[1]), RtfTransferableData.colorComponentFloatToInt(components[2])};
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    private static int colorComponentFloatToInt(float component) {
        return (int)(component * 255.0f + 0.5f);
    }

    @Override
    @NotNull
    protected String getCharset() {
        if ("US-ASCII" == null) {
            RtfTransferableData.$$$reportNull$$$0(2);
        }
        return "US-ASCII";
    }

    private static void addFontSize(StringBuilder buffer, float fontSize) {
        buffer.append("\\fs").append(Math.round(fontSize * 2.0f));
    }

    @Override
    public int getPriority() {
        return 100;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/view/RtfTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/view/RtfTransferableData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVisitor
    implements MarkupHandler {
        @NotNull
        private final StringBuilder myBuffer;
        @NotNull
        private final String myRawText;
        private final int myMaxLength;
        private final int myDefaultBackgroundId;
        private final float myFontSize;
        private int myForegroundId;
        private int myFontNameId;
        private int myFontStyle;

        MyVisitor(@NotNull StringBuilder buffer, @NotNull String rawText, @NotNull SyntaxInfo syntaxInfo, int maxLength) {
            if (buffer == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (rawText == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (syntaxInfo == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.myForegroundId = -1;
            this.myFontNameId = -1;
            this.myFontStyle = -1;
            this.myBuffer = buffer;
            this.myRawText = rawText;
            this.myMaxLength = maxLength;
            this.myDefaultBackgroundId = syntaxInfo.getDefaultBackground();
            this.myFontSize = syntaxInfo.getFontSize();
        }

        @Override
        public void handleText(int startOffset, int endOffset) {
            this.myBuffer.append("\n");
            block5: for (int i = startOffset; i < endOffset; ++i) {
                char c2 = this.myRawText.charAt(i);
                if (c2 > '\u007f') {
                    this.myBuffer.append(String.format("\\u%04d?", c2));
                    continue;
                }
                switch (c2) {
                    case '\t': {
                        this.myBuffer.append(RtfTransferableData.TAB);
                        continue block5;
                    }
                    case '\n': {
                        this.myBuffer.append(NEW_LINE);
                        continue block5;
                    }
                    case '\\': 
                    case '{': 
                    case '}': {
                        this.myBuffer.append('\\');
                    }
                    default: {
                        this.myBuffer.append(c2);
                    }
                }
            }
        }

        @Override
        public void handleBackground(int backgroundId) {
            if (backgroundId == this.myDefaultBackgroundId) {
                this.myBuffer.append("\\plain");
                RtfTransferableData.addFontSize(this.myBuffer, this.myFontSize);
                if (this.myFontNameId >= 0) {
                    this.handleFont(this.myFontNameId);
                }
                if (this.myForegroundId >= 0) {
                    this.handleForeground(this.myForegroundId);
                }
                if (this.myFontStyle >= 0) {
                    this.handleStyle(this.myFontStyle);
                }
            } else {
                this.myBuffer.append("\\chcbpat").append(backgroundId);
            }
            this.myBuffer.append("\\cb").append(backgroundId);
            this.myBuffer.append('\n');
        }

        @Override
        public void handleForeground(int foregroundId) {
            this.myBuffer.append("\\cf").append(foregroundId).append('\n');
            this.myForegroundId = foregroundId;
        }

        @Override
        public void handleFont(int fontNameId) {
            this.myBuffer.append("\\f").append(fontNameId).append('\n');
            this.myFontNameId = fontNameId;
        }

        @Override
        public void handleStyle(int style) {
            this.myBuffer.append(RtfTransferableData.ITALIC);
            if ((style & 2) == 0) {
                this.myBuffer.append('0');
            }
            this.myBuffer.append(RtfTransferableData.BOLD);
            if ((style & 1) == 0) {
                this.myBuffer.append('0');
            }
            this.myBuffer.append('\n');
            this.myFontStyle = style;
        }

        @Override
        public boolean canHandleMore() {
            if (this.myBuffer.length() > this.myMaxLength) {
                this.myBuffer.append("... truncated ...");
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rawText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "syntaxInfo";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/richcopy/view/RtfTransferableData$MyVisitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

