/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchTask;

import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.FrameSearcher;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskBase;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskCallback;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.ArrayList;

public class RangeSearchTask
extends SearchTaskBase {
    private static final Logger logger = Logger.getInstance(RangeSearchTask.class);
    private ProgressIndicator myProgressIndicator;

    public RangeSearchTask(SearchTaskOptions options, Project project, FileDataProviderForSearch fileDataProviderForSearch, SearchTaskCallback callback2) {
        super(options, project, fileDataProviderForSearch, callback2);
    }

    public String getTitleForBackgroundableTask() {
        int maxStrToFindLength = 16;
        int maxFileNameLength = 20;
        String strToFind = RangeSearchTask.cutToMaxLength(this.options.stringToFind, 16);
        String fileName2 = RangeSearchTask.cutToMaxLength(this.fileDataProviderForSearch.getName(), 20);
        return String.format("Searching for \"%s\" in file \"%s\"", strToFind, fileName2);
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator;
    }

    @Override
    protected void doRun() {
        FrameSearcher searcher = this.createFrameSearcher(this.options, this.project);
        int tailLength = this.options.stringToFind.length() - 1;
        try {
            long pagesAmount = this.fileDataProviderForSearch.getPagesAmount();
            long curPageNumber = RangeSearchTask.getPageNumberForBeginning(pagesAmount, this.options);
            if (RangeSearchTask.isTheEndOfSearchingCycle(curPageNumber, pagesAmount, this.options)) {
                this.callback.tellSearchIsFinished(this, curPageNumber);
                return;
            }
            String prevPageText = curPageNumber > 0L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber - 1L).getText() : "";
            String curPageText = this.fileDataProviderForSearch.getPage_wait(curPageNumber).getText();
            String nextPageText = curPageNumber < pagesAmount - 1L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber + 1L).getText() : "";
            String tailText = RangeSearchTask.getTailFromPage(nextPageText, tailLength);
            char prefixSymbol = RangeSearchTask.getPrefixSymbol(prevPageText);
            char postfixSymbol = RangeSearchTask.getPostfixSymbol(nextPageText, tailLength);
            while (true) {
                this.callback.tellSearchProgress(this, curPageNumber, pagesAmount);
                searcher.setFrame(curPageNumber, prefixSymbol, curPageText, tailText, postfixSymbol);
                ArrayList<SearchResult> allMatchesAtFrame = searcher.findAllMatchesAtFrame();
                if (allMatchesAtFrame.size() > 0) {
                    this.callback.tellFrameSearchResultsFound(this, allMatchesAtFrame);
                }
                if (this.isShouldStop()) {
                    if (this.myProgressIndicator != null) {
                        this.myProgressIndicator.cancel();
                    }
                    this.callback.tellSearchWasStopped(this, curPageNumber);
                    return;
                }
                if (this.myProgressIndicator != null && this.myProgressIndicator.isCanceled()) {
                    this.shouldStop();
                    this.callback.tellSearchWasStopped(this, curPageNumber);
                    return;
                }
                pagesAmount = this.fileDataProviderForSearch.getPagesAmount();
                if (this.options.searchForwardDirection) {
                    prevPageText = curPageText;
                    curPageText = nextPageText;
                    nextPageText = ++curPageNumber < pagesAmount - 1L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber + 1L).getText() : "";
                } else {
                    nextPageText = curPageText;
                    curPageText = prevPageText;
                    String string = prevPageText = --curPageNumber > 0L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber - 1L).getText() : "";
                }
                if (RangeSearchTask.isTheEndOfSearchingCycle(curPageNumber, pagesAmount, this.options)) {
                    this.callback.tellSearchIsFinished(this, RangeSearchTask.getPreviousPageNumber(curPageNumber, this.options));
                    return;
                }
                if (this.isShouldStop()) {
                    if (this.myProgressIndicator != null) {
                        this.myProgressIndicator.cancel();
                    }
                    this.callback.tellSearchWasStopped(this, curPageNumber);
                    return;
                }
                if (this.myProgressIndicator != null && this.myProgressIndicator.isCanceled()) {
                    this.shouldStop();
                    this.callback.tellSearchWasStopped(this, curPageNumber);
                    return;
                }
                tailText = RangeSearchTask.getTailFromPage(nextPageText, tailLength);
                prefixSymbol = RangeSearchTask.getPrefixSymbol(prevPageText);
                postfixSymbol = RangeSearchTask.getPostfixSymbol(nextPageText, tailLength);
            }
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            this.callback.tellSearchWasCatchedException(this, e);
            return;
        }
    }

    private static String cutToMaxLength(String whatToCut, int maxLength) {
        if (whatToCut.length() > maxLength) {
            return whatToCut.substring(0, maxLength / 2 - 1) + "..." + whatToCut.substring(whatToCut.length() - 1 - maxLength / 2);
        }
        return whatToCut;
    }
}

