/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.actions;

import com.intellij.icons.AllIcons;
import com.intellij.largeFilesEditor.search.searchResultsPanel.SearchResultsToolWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FindFurtherAction
extends AnAction
implements DumbAware {
    private static final String TEXT_FIND_NEXT = "Find Next Matches";
    private static final String TEXT_FIND_PREV = "Find Previous Matches";
    private static final String TEXT_FIND_ADD_NEXT = "Find and Add Next Matches";
    private static final String TEXT_FIND_ADD_PREV = "Find and Add Previous Matches";
    private static final String DESCRIPTION_FIND_NEXT = "Search for matches toward the end of the file and replace existing results";
    private static final String DESCRIPTION_FIND_PREV = "Search for matches toward the beginning of the file and replace existing results";
    private static final String DESCRIPTION_FIND_ADD_NEXT = "Search for matches toward the end of the file and add them to existing results";
    private static final String DESCRIPTION_FIND_ADD_PREV = "Search for matches toward the beginning of the file and add them to existing results";
    private static final Icon ICON_FIND_NEXT = AllIcons.Actions.Stub;
    private static final Icon ICON_FIND_PREV = AllIcons.Actions.Stub;
    private static final Icon ICON_FIND_ADD_NEXT = AllIcons.Actions.FindAndShowNextMatches;
    private static final Icon ICON_FIND_ADD_PREV = AllIcons.Actions.FindAndShowPrevMatches;
    private final boolean directionForward;
    private final boolean additionMode;
    private final SearchResultsToolWindow searchResultsToolWindow;

    public FindFurtherAction(boolean directionForward, boolean additionMode, SearchResultsToolWindow searchResultsToolWindow) {
        Icon icon;
        String description;
        String text2;
        this.directionForward = directionForward;
        this.additionMode = additionMode;
        this.searchResultsToolWindow = searchResultsToolWindow;
        if (directionForward) {
            if (additionMode) {
                text2 = TEXT_FIND_ADD_NEXT;
                description = DESCRIPTION_FIND_ADD_NEXT;
                icon = ICON_FIND_ADD_NEXT;
            } else {
                text2 = TEXT_FIND_NEXT;
                description = DESCRIPTION_FIND_NEXT;
                icon = ICON_FIND_NEXT;
            }
        } else if (additionMode) {
            text2 = TEXT_FIND_ADD_PREV;
            description = DESCRIPTION_FIND_ADD_PREV;
            icon = ICON_FIND_ADD_PREV;
        } else {
            text2 = TEXT_FIND_PREV;
            description = DESCRIPTION_FIND_PREV;
            icon = ICON_FIND_PREV;
        }
        this.getTemplatePresentation().setText(text2);
        this.getTemplatePresentation().setDescription(description);
        this.getTemplatePresentation().setIcon(icon);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FindFurtherAction.$$$reportNull$$$0(0);
        }
        boolean enabled = this.searchResultsToolWindow.isButtonFindFurtherEnabled(this.directionForward);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FindFurtherAction.$$$reportNull$$$0(1);
        }
        this.searchResultsToolWindow.onClickSearchFurther(this.directionForward, this.additionMode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/largeFilesEditor/search/actions/FindFurtherAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

