/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.StatisticsEventLogFileAppender;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogFileWriter;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "recorderId", "", "maxFileSize", "(Ljava/lang/String;Ljava/lang/String;)V", "eventLogger", "Lorg/apache/log4j/Logger;", "fileAppender", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogFileAppender;", "cleanup", "", "getEventLogDir", "Ljava/nio/file/Path;", "getFiles", "", "Ljava/io/File;", "log", "message", "rollOver", "intellij.platform.ide.impl"})
public final class StatisticsEventLogFileWriter
implements StatisticsEventLogWriter {
    private StatisticsEventLogFileAppender fileAppender;
    private final Logger eventLogger;
    private final String recorderId;
    private final String maxFileSize;

    private final Path getEventLogDir() {
        Path path;
        if (Intrinsics.areEqual((Object)this.recorderId, (Object)"FUS")) {
            Path path2 = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("event-log");
            path = path2;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(PathManager.ge\u2026h()).resolve(\"event-log\")");
        } else {
            Path path3 = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("plugins-event-log").resolve(this.recorderId);
            path = path3;
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(PathManager.ge\u2026log\").resolve(recorderId)");
        }
        return path;
    }

    @Override
    public void log(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.eventLogger.info((Object)message);
    }

    @Override
    @NotNull
    public List<File> getFiles() {
        Object[] files2;
        StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender;
        String activeLog = statisticsEventLogFileAppender != null ? statisticsEventLogFileAppender.getActiveLogName() : null;
        Object object = files2 = new File(this.getEventLogDir().toUri()).listFiles(new FileFilter(activeLog){
            final /* synthetic */ String $activeLog;

            public final boolean accept(@NotNull File f) {
                Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                return !StringUtil.equals((CharSequence)f.getName(), (CharSequence)this.$activeLog);
            }
            {
                this.$activeLog = string;
            }
        });
        if (files2 == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    public void cleanup() {
        block0: {
            StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender;
            if (statisticsEventLogFileAppender == null) break block0;
            statisticsEventLogFileAppender.cleanUp();
        }
    }

    @Override
    public void rollOver() {
        block0: {
            StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender;
            if (statisticsEventLogFileAppender == null) break block0;
            statisticsEventLogFileAppender.rollOver();
        }
    }

    public StatisticsEventLogFileWriter(@NotNull String recorderId, @NotNull String maxFileSize) {
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        Intrinsics.checkParameterIsNotNull((Object)maxFileSize, (String)"maxFileSize");
        this.recorderId = recorderId;
        this.maxFileSize = maxFileSize;
        Logger logger = Logger.getLogger((String)("event.logger." + this.recorderId));
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(\"event.logger.$recorderId\")");
        this.eventLogger = logger;
        this.eventLogger.setLevel(Level.INFO);
        this.eventLogger.setAdditivity(false);
        PatternLayout pattern = new PatternLayout("%m\n");
        try {
            Path dir = this.getEventLogDir();
            StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender = StatisticsEventLogFileAppender.create((Layout)pattern, dir);
            if (statisticsEventLogFileAppender != null) {
                StatisticsEventLogFileAppender statisticsEventLogFileAppender2 = statisticsEventLogFileAppender;
                boolean bl = false;
                boolean bl2 = false;
                StatisticsEventLogFileAppender appender = statisticsEventLogFileAppender2;
                boolean bl3 = false;
                appender.setMaxFileSize(this.maxFileSize);
                this.eventLogger.addAppender((Appender)appender);
            }
        }
        catch (IOException e) {
            System.err.println("Unable to initialize logging for feature usage: " + e.getLocalizedMessage());
        }
    }
}

