/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.KeyedLazyInstanceEP;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataValidator<T> {
    private static boolean ourExtensionsLoaded;
    public static final ExtensionPointName<KeyedLazyInstanceEP<DataValidator>> EP_NAME;
    private static final Logger LOG;
    private static final Map<String, DataValidator<?>> ourValidators;
    private static final DataValidator<VirtualFile> VIRTUAL_FILE_VALIDATOR;
    private static final DataValidator<Project> PROJECT_VALIDATOR;
    private static final DataValidator<Editor> EDITOR_VALIDATOR;

    @Nullable
    public abstract T findInvalid(@NotNull String var1, @NotNull T var2, @NotNull Object var3);

    private static <T> DataValidator<T> getValidator(@NotNull String dataId) {
        if (dataId == null) {
            DataValidator.$$$reportNull$$$0(0);
        }
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            for (KeyedLazyInstanceEP ep : EP_NAME.getExtensionList()) {
                ourValidators.put(ep.key, (DataValidator<?>)ep.getInstance());
            }
        }
        return ourValidators.get(dataId);
    }

    static <T> T findInvalidData(@NotNull String dataId, @NotNull Object data, @NotNull Object dataSource) {
        DataValidator<Object> validator;
        if (dataId == null) {
            DataValidator.$$$reportNull$$$0(1);
        }
        if (data == null) {
            DataValidator.$$$reportNull$$$0(2);
        }
        if (dataSource == null) {
            DataValidator.$$$reportNull$$$0(3);
        }
        if ((validator = DataValidator.getValidator(dataId)) != null) {
            try {
                return (T)validator.findInvalid(dataId, data, dataSource);
            }
            catch (ClassCastException e) {
                throw new AssertionError("Object of incorrect type returned for key '" + dataId + "' by " + dataSource, e);
            }
        }
        return null;
    }

    static {
        EP_NAME = ExtensionPointName.create((String)"com.intellij.dataValidator");
        LOG = Logger.getInstance((String)"#com.intellij.ide.impl.DataValidator");
        ourValidators = new HashMap();
        VIRTUAL_FILE_VALIDATOR = new DataValidator<VirtualFile>(){

            @Override
            public VirtualFile findInvalid(@NotNull String dataId, @NotNull VirtualFile file2, @NotNull Object dataSource) {
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (dataSource == null) {
                    1.$$$reportNull$$$0(2);
                }
                return file2.isValid() ? null : file2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSource";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/impl/DataValidator$1";
                objectArray[2] = "findInvalid";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PROJECT_VALIDATOR = new DataValidator<Project>(){

            @Override
            public Project findInvalid(@NotNull String dataId, @NotNull Project project, @NotNull Object dataSource) {
                if (dataId == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (dataSource == null) {
                    2.$$$reportNull$$$0(2);
                }
                return project.isDisposed() ? project : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSource";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/impl/DataValidator$2";
                objectArray[2] = "findInvalid";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        EDITOR_VALIDATOR = new DataValidator<Editor>(){

            @Override
            public Editor findInvalid(@NotNull String dataId, @NotNull Editor editor, @NotNull Object dataSource) {
                if (dataId == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (dataSource == null) {
                    3.$$$reportNull$$$0(2);
                }
                return editor.isDisposed() ? editor : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSource";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/impl/DataValidator$3";
                objectArray[2] = "findInvalid";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ourValidators.put(CommonDataKeys.VIRTUAL_FILE.getName(), VIRTUAL_FILE_VALIDATOR);
        ourValidators.put(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName(), new ArrayValidator<VirtualFile>(VIRTUAL_FILE_VALIDATOR));
        ourValidators.put(CommonDataKeys.PROJECT.getName(), PROJECT_VALIDATOR);
        ourValidators.put(CommonDataKeys.EDITOR.getName(), EDITOR_VALIDATOR);
        ourValidators.put(AnActionEvent.injectedId((String)CommonDataKeys.EDITOR.getName()), EDITOR_VALIDATOR);
        ourValidators.put(CommonDataKeys.HOST_EDITOR.getName(), EDITOR_VALIDATOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/DataValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidator";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findInvalidData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ArrayValidator<T>
    extends DataValidator<T[]> {
        private final DataValidator<T> myElementValidator;

        ArrayValidator(@NotNull DataValidator<T> elementValidator) {
            if (elementValidator == null) {
                ArrayValidator.$$$reportNull$$$0(0);
            }
            this.myElementValidator = elementValidator;
        }

        @Override
        public T[] findInvalid(@NotNull String dataId, @NotNull T[] array, @NotNull Object dataSource) {
            if (dataId == null) {
                ArrayValidator.$$$reportNull$$$0(1);
            }
            if (array == null) {
                ArrayValidator.$$$reportNull$$$0(2);
            }
            if (dataSource == null) {
                ArrayValidator.$$$reportNull$$$0(3);
            }
            for (T element : array) {
                if (element == null) {
                    LOG.error("Data isn't valid. " + dataId + "=null Provided by: " + dataSource.getClass().getName() + " (" + dataSource.toString() + ")");
                    return null;
                }
                T invalid = this.myElementValidator.findInvalid(dataId, element, dataSource);
                if (invalid == null) continue;
                Class type = ArrayUtil.getComponentType((Object[])array);
                return ArrayUtil.toObjectArray((Class)type, (Object[])new Object[]{invalid});
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementValidator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/impl/DataValidator$ArrayValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findInvalid";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

