/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.MyIcon;
import com.intellij.ide.RecentProjectIconHelper;
import com.intellij.ide.RecentProjectIconHelperKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectPanel;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.Function;
import com.intellij.util.ImageLoader;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u000e\u001a\u0004\u0018\u00010\b2\u000b\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001d\u0010\u0013\u001a\u0004\u0018\u00010\b2\u000b\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0014\u001a\u00020\b2\u000b\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0010R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper;", "", "()V", "projectIcons", "Lgnu/trove/THashMap;", "", "Lcom/intellij/ide/MyIcon;", "smallAppIcon", "Ljavax/swing/Icon;", "kotlin.jvm.PlatformType", "getSmallAppIcon", "()Ljavax/swing/Icon;", "smallAppIcon$delegate", "Lkotlin/Lazy;", "calculateIcon", "path", "Lorg/jetbrains/annotations/SystemIndependent;", "isDark", "", "getProjectIcon", "getProjectOrAppIcon", "Companion", "intellij.platform.ide.impl"})
public final class RecentProjectIconHelper {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final THashMap<String, MyIcon> projectIcons = new THashMap();
    private final Lazy smallAppIcon$delegate = LazyKt.lazy((Function0)smallAppIcon.2.INSTANCE);
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(RecentProjectIconHelper.class), "smallAppIcon", "getSmallAppIcon()Ljavax/swing/Icon;"))};
        Companion = new Companion(null);
    }

    private final Icon getSmallAppIcon() {
        Lazy lazy = this.smallAppIcon$delegate;
        RecentProjectIconHelper recentProjectIconHelper = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Icon)lazy.getValue();
    }

    @Nullable
    public final Icon getProjectIcon(@NotNull String path, boolean isDark) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        MyIcon icon = (MyIcon)this.projectIcons.get((Object)path);
        return icon != null ? icon.getIcon() : IconDeferrer.getInstance().defer(EmptyIcon.ICON_16, (Object)Pair.create((Object)path, (Object)isDark), (Function)new Function<Pair<String, Boolean>, Icon>(this){
            final /* synthetic */ RecentProjectIconHelper this$0;

            @Nullable
            public final Icon fun(Pair<String, Boolean> it) {
                Object object = it.first;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.first");
                String string = (String)object;
                Object object2 = it.second;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it.second");
                return RecentProjectIconHelper.access$calculateIcon(this.this$0, string, (Boolean)object2);
            }
            {
                this.this$0 = recentProjectIconHelper;
            }
        });
    }

    @NotNull
    public final Icon getProjectOrAppIcon(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Icon icon = this.getProjectIcon(path, UIUtil.isUnderDarcula());
        if (icon != null) {
            return icon;
        }
        if (UIUtil.isUnderDarcula() && (icon = this.getProjectIcon(path, false)) != null) {
            return icon;
        }
        Icon icon2 = this.getSmallAppIcon();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"smallAppIcon");
        return icon2;
    }

    private final Icon calculateIcon(String path, boolean isDark) {
        Path file2;
        if (!RecentProjectPanel.isFileSystemPath(path)) {
            return null;
        }
        Path path2 = file2 = Paths.get(path, ".idea", isDark ? "icon_dark.png" : "icon.png");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)path2);
        if (basicFileAttributes == null) {
            return null;
        }
        BasicFileAttributes fileInfo = basicFileAttributes;
        long timestamp = fileInfo.lastModifiedTime().toMillis();
        MyIcon icon = (MyIcon)this.projectIcons.get((Object)path);
        if (icon != null) {
            Long l = icon.getTimestamp();
            if (l != null && l == timestamp) {
                return icon.getIcon();
            }
        }
        try {
            Icon icon2 = Companion.createIcon(file2);
            if (icon2 == null) {
                return null;
            }
            icon = new MyIcon(icon2, timestamp);
            this.projectIcons.put((Object)path, (Object)icon);
            return icon.getIcon();
        }
        catch (Exception e) {
            RecentProjectIconHelperKt.access$getLOG$p().error((Throwable)e);
            return null;
        }
    }

    public static final /* synthetic */ Icon access$calculateIcon(RecentProjectIconHelper $this, String path, boolean isDark) {
        return $this.calculateIcon(path, isDark);
    }

    @JvmStatic
    @Nullable
    public static final Icon createIcon(@NotNull Path file2) {
        return Companion.createIcon(file2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/RecentProjectIconHelper$Companion;", "", "()V", "createIcon", "Ljavax/swing/Icon;", "file", "Ljava/nio/file/Path;", "toRetinaAwareIcon", "image", "Ljava/awt/image/BufferedImage;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Icon createIcon(@NotNull Path file2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            try {
                Image image = ImageLoader.loadFromUrl((URL)file2.toUri().toURL());
                if (image == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"ImageLoader.loadFromUrl(\u2026).toURL()) ?: return null");
                Image image2 = image;
                int targetSize = UIUtil.isRetina() ? 32 : (int)JBUI.pixScale((float)16.0f);
                BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage((Image)image2), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)targetSize, (BufferedImageOp[])new BufferedImageOp[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"Scalr.resize(ImageUtil.t\u2026LTRA_QUALITY, targetSize)");
                return this.toRetinaAwareIcon(bufferedImage);
            }
            catch (MalformedURLException e) {
                RecentProjectIconHelperKt.access$getLOG$p().debug((Throwable)e);
                return null;
            }
        }

        private final Icon toRetinaAwareIcon(BufferedImage image) {
            return new Icon(image){
                final /* synthetic */ BufferedImage $image;

                public void paintIcon(@NotNull Component c2, @NotNull Graphics g, int x, int y) {
                    Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c");
                    Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
                    if (UIUtil.isJreHiDPI()) {
                        Graphics graphics = g.create(x, y, this.$image.getWidth(), this.$image.getHeight());
                        if (graphics == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
                        }
                        Graphics2D newG = (Graphics2D)graphics;
                        float s = JBUI.sysScale();
                        newG.scale(1.0f / s, 1.0f / s);
                        newG.drawImage((Image)this.$image, (int)((float)x / s), (int)((float)y / s), null);
                        newG.scale(1.0, 1.0);
                        newG.dispose();
                    } else {
                        g.drawImage(this.$image, x, y, null);
                    }
                }

                public int getIconWidth() {
                    return UIUtil.isJreHiDPI() ? (int)((float)this.$image.getWidth() / JBUI.sysScale()) : this.$image.getWidth();
                }

                public int getIconHeight() {
                    return UIUtil.isJreHiDPI() ? (int)((float)this.$image.getHeight() / JBUI.sysScale()) : this.$image.getHeight();
                }
                {
                    this.$image = $captured_local_variable$0;
                }
            };
        }

        private Companion() {
        }

        public static final /* synthetic */ Icon access$toRetinaAwareIcon(Companion $this, BufferedImage image) {
            return $this.toRetinaAwareIcon(image);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

