/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CliResult;
import com.intellij.ide.CommandLineWaitingManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.CommandLineProcessor");
    private static final String WAIT_KEY = "--wait";

    private CommandLineProcessor() {
    }

    @NotNull
    private static Pair<Project, Future<? extends CliResult>> doOpenFileOrProject(VirtualFile file2, boolean shouldWait) {
        if (ProjectUtil.isValidProjectPath(file2) || ProjectOpenProcessor.getImportProvider((VirtualFile)file2) != null) {
            String path = file2.getPath();
            Project project = ProjectUtil.openOrImport(path, null, true);
            if (project == null) {
                String message = "Cannot open project '" + FileUtil.toSystemDependentName((String)path) + "'";
                Messages.showErrorDialog((String)message, (String)"Cannot Open Project");
                Pair pair = Pair.pair(null, (Object)CliResult.error((int)1, (String)message));
                if (pair == null) {
                    CommandLineProcessor.$$$reportNull$$$0(0);
                }
                return pair;
            }
            Pair pair = Pair.pair((Object)project, (Object)(shouldWait ? CommandLineWaitingManager.getInstance().addHookForProject(project) : CliResult.ok()));
            if (pair == null) {
                CommandLineProcessor.$$$reportNull$$$0(1);
            }
            return pair;
        }
        Pair<Project, Future<? extends CliResult>> pair = CommandLineProcessor.doOpenFile(file2, -1, false, shouldWait);
        if (pair == null) {
            CommandLineProcessor.$$$reportNull$$$0(2);
        }
        return pair;
    }

    @NotNull
    private static Pair<Project, Future<? extends CliResult>> doOpenFile(VirtualFile file2, int line2, boolean tempProject, boolean shouldWait) {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0 || tempProject) {
            Project project = CommandLineProjectOpenProcessor.getInstance().openProjectAndFile(file2, line2, tempProject);
            if (project == null) {
                String message = "No project found to open file in";
                Messages.showErrorDialog((String)"No project found to open file in", (String)"Cannot Open File");
                Pair pair = Pair.pair(null, (Object)CliResult.error((int)1, (String)"No project found to open file in"));
                if (pair == null) {
                    CommandLineProcessor.$$$reportNull$$$0(3);
                }
                return pair;
            }
            Pair pair = Pair.pair((Object)project, (Object)(shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : CliResult.ok()));
            if (pair == null) {
                CommandLineProcessor.$$$reportNull$$$0(4);
            }
            return pair;
        }
        NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(file2));
        Project project = CommandLineProcessor.findBestProject(file2, projects);
        (line2 > 0 ? new OpenFileDescriptor(project, file2, line2 - 1, 0) : PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1)).navigate(true);
        Pair pair = Pair.pair((Object)project, (Object)(shouldWait ? CommandLineWaitingManager.getInstance().addHookForFile(file2) : CliResult.ok()));
        if (pair == null) {
            CommandLineProcessor.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @NotNull
    private static Project findBestProject(VirtualFile file2, Project[] projects) {
        Project project;
        for (Project project2 : projects) {
            if (!ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2)) continue;
            Project project3 = project2;
            if (project3 == null) {
                CommandLineProcessor.$$$reportNull$$$0(6);
            }
            return project3;
        }
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (frame != null && (project = frame.getProject()) != null) {
            Project project4 = project;
            if (project4 == null) {
                CommandLineProcessor.$$$reportNull$$$0(7);
            }
            return project4;
        }
        Project project5 = projects[0];
        if (project5 == null) {
            CommandLineProcessor.$$$reportNull$$$0(8);
        }
        return project5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Pair<Project, Future<? extends CliResult>> processExternalCommandLine(@NotNull List<String> args, @Nullable String currentDirectory) {
        ApplicationStarter starter2;
        if (args == null) {
            CommandLineProcessor.$$$reportNull$$$0(9);
        }
        LOG.info("External command line:");
        LOG.info("Dir: " + currentDirectory);
        for (String string : args) {
            LOG.info(string);
        }
        LOG.info("-----");
        if (args.isEmpty()) {
            Pair pair = Pair.pair(null, (Object)CliResult.ok());
            if (pair == null) {
                CommandLineProcessor.$$$reportNull$$$0(10);
            }
            return pair;
        }
        String command = args.get(0);
        Iterator iterator = ApplicationStarter.EP_NAME.getIterable().iterator();
        while (iterator.hasNext() && (starter2 = (ApplicationStarter)iterator.next()) != null) {
            if (!command.equals(starter2.getCommandName())) continue;
            if (starter2.canProcessExternalCommandLine()) {
                LOG.info("Processing command with " + starter2);
                Pair pair = Pair.pair(null, (Object)starter2.processExternalCommandLineAsync(ArrayUtilRt.toStringArray(args), currentDirectory));
                if (pair == null) {
                    CommandLineProcessor.$$$reportNull$$$0(11);
                }
                return pair;
            }
            String title = "Cannot execute command '" + command + "'";
            String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.";
            Messages.showErrorDialog((String)message, (String)title);
            Pair pair = Pair.pair(null, (Object)CliResult.error((int)1, (String)message));
            if (pair == null) {
                CommandLineProcessor.$$$reportNull$$$0(12);
            }
            return pair;
        }
        if (command.startsWith("jetbrains://")) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)command);
            ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
            Pair pair = Pair.pair(null, (Object)CliResult.ok());
            if (pair == null) {
                CommandLineProcessor.$$$reportNull$$$0(13);
            }
            return pair;
        }
        boolean bl = args.contains(WAIT_KEY);
        Pair<Project, Future<? extends CliResult>> projectAndCallback = null;
        int line2 = -1;
        boolean tempProject = false;
        for (int i = 0; i < args.size(); ++i) {
            block29: {
                String arg = args.get(i);
                if (arg.equals("nosplash")) continue;
                if (arg.equals("-l") || arg.equals("--line")) {
                    if (++i == args.size()) break;
                    try {
                        line2 = Integer.parseInt(args.get(i));
                    }
                    catch (NumberFormatException e) {
                        line2 = -1;
                    }
                    continue;
                }
                if (arg.equals("--temp-project")) {
                    tempProject = true;
                    continue;
                }
                if (arg.equals(WAIT_KEY)) continue;
                if (StringUtil.isQuotedString((String)arg)) {
                    arg = StringUtil.unquoteString((String)arg);
                }
                if (!new File(arg).isAbsolute()) {
                    arg = (currentDirectory != null ? new File(currentDirectory, arg) : new File(arg)).getAbsolutePath();
                }
                VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(arg);
                if (line2 != -1 || tempProject) {
                    if (file2 != null && !file2.isDirectory()) {
                        projectAndCallback = CommandLineProcessor.doOpenFile(file2, line2, tempProject, bl);
                        if (bl) {
                            break;
                        }
                        break block29;
                    } else {
                        String message = "Cannot find file '" + arg + "'";
                        Messages.showErrorDialog((String)message, (String)"Cannot Find File");
                        Pair pair = Pair.pair(null, (Object)CliResult.error((int)1, (String)message));
                        if (pair == null) {
                            CommandLineProcessor.$$$reportNull$$$0(14);
                        }
                        return pair;
                    }
                }
                if (file2 != null) {
                    projectAndCallback = CommandLineProcessor.doOpenFileOrProject(file2, bl);
                    if (bl) {
                        break;
                    }
                } else {
                    String message = "Cannot find file '" + arg + "'";
                    Messages.showErrorDialog((String)message, (String)"Cannot Find File");
                    Pair pair = Pair.pair(null, (Object)CliResult.error((int)1, (String)message));
                    if (pair == null) {
                        CommandLineProcessor.$$$reportNull$$$0(15);
                    }
                    return pair;
                }
            }
            line2 = -1;
            tempProject = false;
        }
        if (bl && projectAndCallback == null) {
            Pair pair = Pair.pair(null, (Object)CliResult.error((int)1, (String)"--wait must be supplied with file or project to wait for"));
            if (pair == null) {
                CommandLineProcessor.$$$reportNull$$$0(16);
            }
            return pair;
        }
        Pair pair = (Pair)ObjectUtils.coalesce(projectAndCallback, (Object)Pair.pair(null, (Object)CliResult.ok()));
        if (pair == null) {
            CommandLineProcessor.$$$reportNull$$$0(17);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CommandLineProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doOpenFileOrProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doOpenFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBestProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CommandLineProcessor";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "processExternalCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processExternalCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

