/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeSetHolder;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.util.Consumer;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InMemoryChangeListStorage
implements ChangeListStorage {
    private int myCurrentId;
    private final List<ChangeSet> mySets = new ArrayList<ChangeSet>();

    @Override
    public void close() {
    }

    @Override
    public long nextId() {
        return this.myCurrentId++;
    }

    @Override
    @Nullable
    public ChangeSetHolder readPrevious(int id, TIntHashSet recursionGuard) {
        if (this.mySets.isEmpty()) {
            return null;
        }
        if (id == -1) {
            return new ChangeSetHolder(this.mySets.size() - 1, this.mySets.get(this.mySets.size() - 1));
        }
        return id == 0 ? null : new ChangeSetHolder(id - 1, this.mySets.get(id - 1));
    }

    @Override
    public void writeNextSet(ChangeSet changeSet) {
        this.mySets.add(changeSet);
    }

    @Override
    public void purge(long period, int intervalBetweenActivities, Consumer<? super ChangeSet> processor2) {
    }
}

