/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class ChangeCollectingVisitor
extends ChangeVisitor {
    private String myPath;
    private final String myProjectId;
    private final Pattern myPattern;
    private ChangeSet myCurrentChangeSet;
    private boolean myExists = true;
    private boolean myDoNotAddAnythingElseFromCurrentChangeSet = false;
    private final LinkedHashSet<ChangeSet> myResult = new LinkedHashSet();

    public ChangeCollectingVisitor(String path, String projectId, @Nullable String pattern) {
        this.myPath = path;
        this.myProjectId = projectId;
        this.myPattern = pattern == null ? null : Pattern.compile(NameUtil.buildRegexp((String)pattern, (int)0, (boolean)true, (boolean)true), 2);
    }

    public List<ChangeSet> getChanges() {
        return new ArrayList<ChangeSet>(this.myResult);
    }

    public String getPath() {
        return this.myPath;
    }

    @Override
    public void begin(ChangeSet c2) throws ChangeVisitor.StopVisitingException {
        this.myCurrentChangeSet = c2;
    }

    @Override
    public void end(ChangeSet c2) throws ChangeVisitor.StopVisitingException {
        this.myCurrentChangeSet = null;
        this.myDoNotAddAnythingElseFromCurrentChangeSet = false;
    }

    @Override
    public void visit(PutLabelChange c2) throws ChangeVisitor.StopVisitingException {
        this.doVisit(c2);
    }

    @Override
    public void visit(StructuralChange c2) throws ChangeVisitor.StopVisitingException {
        this.doVisit(c2);
    }

    private void doVisit(Change c2) {
        if (this.skippedDueToNonexistence(c2)) {
            return;
        }
        this.addIfAffectsAndRevert(c2);
    }

    @Override
    public void visit(CreateEntryChange c2) throws ChangeVisitor.StopVisitingException {
        if (this.skippedDueToNonexistence(c2)) {
            return;
        }
        this.addIfAffectsAndRevert(c2);
        if (c2.isCreationalFor(this.myPath)) {
            this.myExists = false;
        }
    }

    @Override
    public void visit(DeleteChange c2) throws ChangeVisitor.StopVisitingException {
        if (this.skippedDueToNonexistence(c2)) {
            if (c2.isDeletionOf(this.myPath)) {
                this.addIfAffectsAndRevert(c2);
                this.myExists = true;
                this.myDoNotAddAnythingElseFromCurrentChangeSet = true;
            }
        } else {
            this.addIfAffectsAndRevert(c2);
        }
    }

    private void addIfAffectsAndRevert(Change c2) {
        if (!this.myDoNotAddAnythingElseFromCurrentChangeSet && (c2.affectsPath(this.myPath) || c2.affectsProject(this.myProjectId)) && (this.myPattern == null || c2.affectsMatching(this.myPattern))) {
            this.myResult.add(this.myCurrentChangeSet);
        }
        if (c2 instanceof StructuralChange) {
            this.myPath = ((StructuralChange)c2).revertPath(this.myPath);
        }
    }

    private boolean skippedDueToNonexistence(Change c2) {
        if (this.myExists) {
            return false;
        }
        if (c2 instanceof StructuralChange) {
            this.myPath = ((StructuralChange)c2).revertPath(this.myPath);
        }
        return true;
    }
}

