/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutorRegistryImpl
extends ExecutorRegistry
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ExecutorRegistryImpl.class);
    public static final String RUNNERS_GROUP = "RunnerActions";
    public static final String RUN_CONTEXT_GROUP = "RunContextGroupInner";
    private List<Executor> myExecutors = new ArrayList<Executor>();
    private final Map<String, Executor> myId2Executor = new THashMap();
    private final Set<String> myContextActionIdSet = new THashSet();
    private final Map<String, AnAction> myId2Action = new THashMap();
    private final Map<String, AnAction> myContextActionId2Action = new THashMap();
    private final Set<Trinity<Project, String, String>> myInProgress = Collections.synchronizedSet(new THashSet());

    public ExecutorRegistryImpl() {
        this.initComponent();
    }

    synchronized void initExecutor(@NotNull Executor executor) {
        ActionGroup runContextAction;
        DumbAware toolbarAction;
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(0);
        }
        if (this.myId2Executor.get(executor.getId()) != null) {
            LOG.error("Executor with id: \"" + executor.getId() + "\" was already registered!");
        }
        if (this.myContextActionIdSet.contains(executor.getContextActionId())) {
            LOG.error("Executor with context action id: \"" + executor.getContextActionId() + "\" was already registered!");
        }
        if (executor instanceof ExecutorGroup) {
            ExecutorGroupActionGroup toolbarActionGroup = new ExecutorGroupActionGroup((ExecutorGroup)executor, x$0 -> new ExecutorAction((Executor)x$0));
            toolbarActionGroup.setPopup(true);
            Presentation presentation = toolbarActionGroup.getTemplatePresentation();
            presentation.setIcon(executor.getIcon());
            presentation.setText(executor.getStartActionText());
            presentation.setDescription(executor.getDescription());
            toolbarAction = toolbarActionGroup;
            runContextAction = new ExecutorGroupActionGroup((ExecutorGroup)executor, RunContextAction::new);
        } else {
            toolbarAction = new ExecutorAction(executor);
            runContextAction = new RunContextAction(executor);
        }
        Executor.ActionWrapper customizer = executor.runnerActionsGroupExecutorActionCustomizer();
        ExecutorRegistryImpl.registerAction(executor.getId(), (AnAction)(customizer != null ? customizer.wrap((AnAction)toolbarAction) : toolbarAction), RUNNERS_GROUP, this.myId2Action);
        ExecutorRegistryImpl.registerAction(executor.getContextActionId(), (AnAction)runContextAction, RUN_CONTEXT_GROUP, this.myContextActionId2Action);
        this.myExecutors.add(executor);
        this.myId2Executor.put(executor.getId(), executor);
        this.myContextActionIdSet.add(executor.getContextActionId());
    }

    private static void registerAction(@NotNull String actionId, @NotNull AnAction anAction, @NotNull String groupId, @NotNull Map<String, AnAction> map2) {
        ActionManager actionManager;
        AnAction action2;
        if (actionId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(1);
        }
        if (anAction == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(2);
        }
        if (groupId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(3);
        }
        if (map2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(4);
        }
        if ((action2 = (actionManager = ActionManager.getInstance()).getAction(actionId)) == null) {
            actionManager.registerAction(actionId, anAction);
            map2.put(actionId, anAction);
            action2 = anAction;
        }
        ((DefaultActionGroup)actionManager.getAction(groupId)).add(action2);
    }

    synchronized void deinitExecutor(@NotNull Executor executor) {
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(5);
        }
        this.myExecutors.remove(executor);
        this.myId2Executor.remove(executor.getId());
        this.myContextActionIdSet.remove(executor.getContextActionId());
        ExecutorRegistryImpl.unregisterAction(executor.getId(), RUNNERS_GROUP, this.myId2Action);
        ExecutorRegistryImpl.unregisterAction(executor.getContextActionId(), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private static void unregisterAction(@NotNull String actionId, @NotNull String groupId, @NotNull Map<String, AnAction> map2) {
        ActionManager actionManager;
        DefaultActionGroup group;
        if (actionId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(6);
        }
        if (groupId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(7);
        }
        if (map2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(8);
        }
        if ((group = (DefaultActionGroup)(actionManager = ActionManager.getInstance()).getAction(groupId)) != null) {
            group.remove(actionManager.getAction(actionId));
            AnAction action2 = map2.get(actionId);
            if (action2 != null) {
                actionManager.unregisterAction(actionId);
                map2.remove(actionId);
            }
        }
    }

    @NotNull
    public synchronized Executor[] getRegisteredExecutors() {
        Executor[] executorArray = this.myExecutors.toArray(new Executor[0]);
        if (executorArray == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(9);
        }
        return executorArray;
    }

    public Executor getExecutorById(String executorId) {
        return this.myId2Executor.get(executorId);
    }

    private void initComponent() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStartScheduled(@NotNull String executorId, @NotNull ExecutionEnvironment environment) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExecutorRegistryImpl.this.myInProgress.add(ExecutorRegistryImpl.createExecutionId(executorId, environment));
            }

            public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment environment) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(3);
                }
                ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, environment));
            }

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment environment, @NotNull ProcessHandler handler2) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (handler2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                ExecutorRegistryImpl.this.myInProgress.remove(ExecutorRegistryImpl.createExecutionId(executorId, environment));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environment";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStartScheduled";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processNotStarted";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                Set set = ExecutorRegistryImpl.this.myInProgress;
                synchronized (set) {
                    Iterator it = ExecutorRegistryImpl.this.myInProgress.iterator();
                    while (it.hasNext()) {
                        if (project != ((Trinity)it.next()).first) continue;
                        it.remove();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutorRegistryImpl$2", "projectClosed"));
            }
        });
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            try {
                this.initExecutor(executor);
            }
            catch (Throwable t) {
                LOG.error("executor initialization failed: " + executor.getClass().getName(), t);
            }
        }
    }

    @NotNull
    private static Trinity<Project, String, String> createExecutionId(String executorId, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(10);
        }
        Trinity trinity = Trinity.create((Object)environment.getProject(), (Object)executorId, (Object)environment.getRunner().getRunnerId());
        if (trinity == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(11);
        }
        return trinity;
    }

    public boolean isStarting(Project project, String executorId, String runnerId) {
        return this.myInProgress.contains(Trinity.create((Object)project, (Object)executorId, (Object)runnerId));
    }

    public boolean isStarting(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(12);
        }
        return this.isStarting(environment.getProject(), environment.getExecutor().getId(), environment.getRunner().getRunnerId());
    }

    public synchronized void dispose() {
        if (!this.myExecutors.isEmpty()) {
            for (Executor executor : new ArrayList<Executor>(this.myExecutors)) {
                this.deinitExecutor(executor);
            }
        }
        this.myExecutors = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutorRegistryImpl";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredExecutors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExecutor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deinitExecutor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAction";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isStarting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExecutorGroupActionGroup
    extends ActionGroup
    implements DumbAware {
        private final ExecutorGroup<?> myExecutorGroup;
        private final Function<? super Executor, ? extends AnAction> myChildConverter;

        private ExecutorGroupActionGroup(ExecutorGroup executorGroup, Function<? super Executor, ? extends AnAction> childConverter) {
            this.myExecutorGroup = executorGroup;
            this.myChildConverter = childConverter;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            List childExecutors = this.myExecutorGroup.childExecutors();
            AnAction[] result2 = new AnAction[childExecutors.size()];
            for (int i = 0; i < childExecutors.size(); ++i) {
                result2[i] = this.myChildConverter.apply((Executor)childExecutors.get(i));
            }
            if (result2 == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(0);
            }
            return result2;
        }

        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(1);
            }
            if ((project = e.getProject()) == null || !project.isInitialized() || project.isDisposed()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(this.myExecutorGroup.isApplicable(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorGroupActionGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorGroupActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ExecutorAction
    extends AnAction
    implements DumbAware,
    UpdateInBackground {
        private final Executor myExecutor;

        private ExecutorAction(final Executor executor) {
            if (executor == null) {
                ExecutorAction.$$$reportNull$$$0(0);
            }
            super(executor.getStartActionText(), executor.getDescription(), (Icon)new IconLoader.LazyIcon(){

                protected Icon compute() {
                    return executor.getIcon();
                }
            });
            this.myExecutor = executor;
        }

        private boolean canRun(@NotNull Project project, @NotNull List<SettingsAndEffectiveTarget> pairs) {
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(1);
            }
            if (pairs == null) {
                ExecutorAction.$$$reportNull$$$0(2);
            }
            if (pairs.isEmpty()) {
                return false;
            }
            for (SettingsAndEffectiveTarget pair : pairs) {
                RunConfiguration configuration = pair.getConfiguration();
                if (configuration instanceof CompoundRunConfiguration && !this.canRun(project, ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets())) {
                    return false;
                }
                ProgramRunner runner = ProgramRunner.getRunner((String)this.myExecutor.getId(), (RunProfile)configuration);
                if (runner != null && ExecutionTargetManager.canRun((RunConfiguration)configuration, (ExecutionTarget)pair.getTarget()) && !ExecutorRegistryImpl.this.isStarting(project, this.myExecutor.getId(), runner.getRunnerId())) continue;
                return false;
            }
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            String text2;
            if (e == null) {
                ExecutorAction.$$$reportNull$$$0(3);
            }
            Presentation presentation = e.getPresentation();
            Project project = e.getProject();
            if (project == null || !project.isInitialized() || project.isDisposed()) {
                presentation.setEnabled(false);
                return;
            }
            RunnerAndConfigurationSettings selectedSettings = this.getSelectedConfiguration(project);
            boolean enabled = false;
            boolean hideDisabledExecutorButtons = false;
            if (selectedSettings != null) {
                if (DumbService.isDumb((Project)project) && !selectedSettings.getType().isDumbAware()) {
                    presentation.setEnabled(false);
                    return;
                }
                presentation.setIcon(this.getInformativeIcon(project, selectedSettings));
                RunConfiguration configuration = selectedSettings.getConfiguration();
                if (configuration instanceof CompoundRunConfiguration) {
                    enabled = this.canRun(project, ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets());
                } else {
                    ExecutionTarget target2 = ExecutionTargetManager.getActiveTarget((Project)project);
                    enabled = this.canRun(project, Collections.singletonList(new SettingsAndEffectiveTarget(configuration, target2)));
                    hideDisabledExecutorButtons = configuration.hideDisabledExecutorButtons();
                }
                if (enabled) {
                    presentation.setDescription(this.myExecutor.getDescription());
                }
                text2 = this.myExecutor.getStartActionText(configuration.getName());
            } else {
                text2 = this.getTemplatePresentation().getTextWithMnemonic();
            }
            if (hideDisabledExecutorButtons) {
                presentation.setEnabledAndVisible(enabled);
            } else {
                presentation.setEnabled(enabled);
            }
            if (presentation.isVisible()) {
                presentation.setVisible(this.myExecutor.isApplicable(project));
            }
            presentation.setText(text2);
        }

        private Icon getInformativeIcon(Project project, RunnerAndConfigurationSettings selectedConfiguration2) {
            RunnerIconProvider provider;
            Icon icon;
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project);
            RunConfiguration configuration = selectedConfiguration2.getConfiguration();
            if (configuration instanceof RunnerIconProvider && (icon = (provider = (RunnerIconProvider)configuration).getExecutorIcon(configuration, this.myExecutor)) != null) {
                return icon;
            }
            List runningDescriptors2 = executionManager.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)s -> s != null && s.getConfiguration() == selectedConfiguration2.getConfiguration()));
            runningDescriptors2 = ContainerUtil.filter(runningDescriptors2, descriptor2 -> {
                RunContentDescriptor contentDescriptor = executionManager.getContentManager().findContentDescriptor(this.myExecutor, descriptor2.getProcessHandler());
                return contentDescriptor != null && executionManager.getExecutors(contentDescriptor).contains(this.myExecutor);
            });
            if (!configuration.isAllowRunningInParallel() && !runningDescriptors2.isEmpty() && DefaultRunExecutor.EXECUTOR_ID.equals(this.myExecutor.getId())) {
                return AllIcons.Actions.Restart;
            }
            if (runningDescriptors2.isEmpty()) {
                return this.myExecutor.getIcon();
            }
            if (runningDescriptors2.size() == 1) {
                return ExecutionUtil.getLiveIndicator((Icon)this.myExecutor.getIcon());
            }
            return IconUtil.addText((Icon)this.myExecutor.getIcon(), (String)String.valueOf(runningDescriptors2.size()));
        }

        @Nullable
        private RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull Project project) {
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(4);
            }
            return RunManager.getInstance((Project)project).getSelectedConfiguration();
        }

        private void run(@NotNull Project project, @Nullable RunConfiguration configuration, @Nullable RunnerAndConfigurationSettings settings, @NotNull DataContext dataContext) {
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(5);
            }
            if (dataContext == null) {
                ExecutorAction.$$$reportNull$$$0(6);
            }
            if (configuration instanceof CompoundRunConfiguration) {
                RunManager runManager = RunManager.getInstance((Project)project);
                for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets()) {
                    RunConfiguration subConfiguration = settingsAndEffectiveTarget.getConfiguration();
                    this.run(project, subConfiguration, runManager.findSettings(subConfiguration), dataContext);
                }
            } else {
                ExecutionEnvironmentBuilder builder2;
                ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder2 = settings == null ? null : ExecutionEnvironmentBuilder.createOrNull((Executor)this.myExecutor, (RunnerAndConfigurationSettings)settings);
                if (builder2 == null) {
                    return;
                }
                ExecutionManager.getInstance((Project)project).restartRunProfile(builder2.activeTarget().dataContext(dataContext).build());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ExecutorAction.$$$reportNull$$$0(7);
            }
            if ((project = e.getProject()) == null || project.isDisposed()) {
                return;
            }
            MacroManager.getInstance().cacheMacrosPreview(e.getDataContext());
            RunnerAndConfigurationSettings selectedConfiguration2 = this.getSelectedConfiguration(project);
            if (selectedConfiguration2 != null) {
                this.run(project, selectedConfiguration2.getConfiguration(), selectedConfiguration2, e.getDataContext());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedConfiguration";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

