/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideTextDiffViewerEx
extends ThreesideTextDiffViewer {
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable1;
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable2;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextConflictIterable;
    @NotNull
    protected final MyStatusPanel myStatusPanel;
    @NotNull
    protected final MyFoldingModel myFoldingModel;
    @NotNull
    protected final MyInitialScrollHelper myInitialScrollHelper;
    private int myChangesCount;
    private int myConflictsCount;

    public ThreesideTextDiffViewerEx(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(1);
        }
        super(context, request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myChangesCount = -1;
        this.myConflictsCount = -1;
        this.mySyncScrollable1 = new MySyncScrollable(Side.LEFT);
        this.mySyncScrollable2 = new MySyncScrollable(Side.RIGHT);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myPrevNextConflictIterable = new MyPrevNextConflictIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.getProject(), this.getEditors().toArray(new EditorEx[0]), (Disposable)this);
        for (ThreeSide side : ThreeSide.values()) {
            DiffUtil.installLineConvertor(this.getEditor(side), this.getContent(side), this.myFoldingModel, side.getIndex());
        }
        DiffUtil.registerAction((AnAction)new PrevConflictAction(), this.myPanel);
        DiffUtil.registerAction((AnAction)new NextConflictAction(), this.myPanel);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter(Side.LEFT), Side.LEFT);
        this.myContentPanel.setPainter(new MyDividerPainter(Side.RIGHT), Side.RIGHT);
    }

    @Override
    protected void onDispose() {
        this.destroyChangedBlocks();
        this.myFoldingModel.destroy();
        super.onDispose();
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(2);
        }
        return settings;
    }

    @NotNull
    protected Runnable applyNotification(@Nullable JComponent notification) {
        Runnable runnable2 = () -> {
            this.clearDiffPresentation();
            this.myFoldingModel.destroy();
            if (notification != null) {
                this.myPanel.addNotification(notification);
            }
        };
        if (runnable2 == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(3);
        }
        return runnable2;
    }

    protected void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.destroyChangedBlocks();
        this.myContentPanel.repaintDividers();
        this.myStatusPanel.update();
    }

    protected void destroyChangedBlocks() {
    }

    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        ThreesideDiffChangeBase targetChange;
        if (scrollToPolicy == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(4);
        }
        if ((targetChange = scrollToPolicy.select(this.getChanges())) == null) {
            return false;
        }
        this.doScrollToChange(targetChange, false);
        return true;
    }

    protected void doScrollToChange(@NotNull ThreesideDiffChangeBase change, boolean animated) {
        if (change == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(5);
        }
        int[] startLines = new int[3];
        int[] endLines = new int[3];
        for (int i = 0; i < 3; ++i) {
            ThreeSide side = ThreeSide.fromIndex((int)i);
            startLines[i] = change.getStartLine(side);
            endLines[i] = change.getEndLine(side);
            DiffUtil.moveCaret(this.getEditor(side), startLines[i]);
        }
        this.getSyncScrollSupport().makeVisible(this.getCurrentSide(), startLines, endLines, animated);
    }

    public int getChangesCount() {
        return this.myChangesCount;
    }

    public int getConflictsCount() {
        return this.myConflictsCount;
    }

    protected void resetChangeCounters() {
        this.myChangesCount = 0;
        this.myConflictsCount = 0;
    }

    protected void onChangeAdded(@NotNull ThreesideDiffChangeBase change) {
        if (change == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(6);
        }
        if (change.isConflict()) {
            ++this.myConflictsCount;
        } else {
            ++this.myChangesCount;
        }
        this.myStatusPanel.update();
    }

    protected void onChangeRemoved(@NotNull ThreesideDiffChangeBase change) {
        if (change == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(7);
        }
        if (change.isConflict()) {
            --this.myConflictsCount;
        } else {
            --this.myChangesCount;
        }
        this.myStatusPanel.update();
    }

    @NotNull
    protected abstract DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side var1);

    @NotNull
    protected List<? extends ThreesideDiffChangeBase> getAllChanges() {
        List<? extends ThreesideDiffChangeBase> list2 = this.getChanges();
        if (list2 == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    protected abstract List<? extends ThreesideDiffChangeBase> getChanges();

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side side) {
        if (side == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(9);
        }
        SyncScrollSupport.SyncScrollable syncScrollable = (SyncScrollSupport.SyncScrollable)side.select((Object)this.mySyncScrollable1, (Object)this.mySyncScrollable2);
        if (syncScrollable == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(10);
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(11);
        }
        return myStatusPanel;
    }

    @NotNull
    public SyncScrollSupport.ThreesideSyncScrollSupport getSyncScrollSupport() {
        SyncScrollSupport.ThreesideSyncScrollSupport threesideSyncScrollSupport = this.mySyncScrollSupport;
        if (threesideSyncScrollSupport == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(12);
        }
        return threesideSyncScrollSupport;
    }

    @Nullable
    protected ThreesideDiffChangeBase getSelectedChange(@NotNull ThreeSide side) {
        if (side == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(13);
        }
        int caretLine = this.getEditor((ThreeSide)side).getCaretModel().getLogicalPosition().line;
        for (ThreesideDiffChangeBase threesideDiffChangeBase : this.getChanges()) {
            int line2;
            int line1 = threesideDiffChangeBase.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(caretLine, line1, line2 = threesideDiffChangeBase.getEndLine(side))) continue;
            return threesideDiffChangeBase;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        ThreesideDiffChangeBase change;
        if (dataId == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(14);
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getSelectedChange(this.getCurrentSide())) != null) {
            return new LineRange(change.getStartLine(this.getCurrentSide()), change.getEndLine(this.getCurrentSide()));
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollToPolicy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "applyNotification";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onChangeAdded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onChangeRemoved";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSyncScrollable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChange";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyInitialScrollHelper
    extends ThreesideTextDiffViewer.MyInitialScrollPositionHelper {
        protected MyInitialScrollHelper() {
            super(ThreesideTextDiffViewerEx.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return ThreesideTextDiffViewerEx.this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return ThreesideTextDiffViewerEx.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }
    }

    protected static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable1;
        private final FoldingModelSupport.MyPaintable myPaintable2;

        public MyFoldingModel(@Nullable Project project, @NotNull EditorEx[] editors, @NotNull Disposable disposable) {
            if (editors == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            super(project, editors, disposable);
            this.myPaintable1 = new FoldingModelSupport.MyPaintable(this, 0, 1);
            this.myPaintable2 = new FoldingModelSupport.MyPaintable(this, 1, 2);
            assert (editors.length == 3);
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<? extends MergeLineFragment> fragments, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider, @NotNull Side side) {
            if (gg == null) {
                MyFoldingModel.$$$reportNull$$$0(3);
            }
            if (divider == null) {
                MyFoldingModel.$$$reportNull$$$0(4);
            }
            if (side == null) {
                MyFoldingModel.$$$reportNull$$$0(5);
            }
            FoldingModelSupport.MyPaintable paintable = (FoldingModelSupport.MyPaintable)side.select((Object)this.myPaintable1, (Object)this.myPaintable2);
            paintable.paintOnDivider(gg, divider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gg";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createState";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintOnDivider";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyStatusPanel
    extends StatusPanel {
        protected MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (ThreesideTextDiffViewerEx.this.myChangesCount < 0 || ThreesideTextDiffViewerEx.this.myConflictsCount < 0) {
                return null;
            }
            if (ThreesideTextDiffViewerEx.this.myChangesCount == 0 && ThreesideTextDiffViewerEx.this.myConflictsCount == 0) {
                return DiffBundle.message((String)"merge.dialog.all.conflicts.resolved.message.text", (Object[])new Object[0]);
            }
            return this.makeCounterWord(ThreesideTextDiffViewerEx.this.myChangesCount, "change") + ". " + this.makeCounterWord(ThreesideTextDiffViewerEx.this.myConflictsCount, "conflict");
        }

        @NotNull
        private String makeCounterWord(int number, @NotNull String word) {
            if (word == null) {
                MyStatusPanel.$$$reportNull$$$0(0);
            }
            if (number == 0) {
                String string = "No " + StringUtil.pluralize((String)word);
                if (string == null) {
                    MyStatusPanel.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = number + " " + StringUtil.pluralize((String)word, (int)number);
            if (string == null) {
                MyStatusPanel.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyStatusPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyStatusPanel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeCounterWord";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "makeCounterWord";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class MyDividerPainter
    implements DiffSplitter.Painter {
        @NotNull
        private final Side mySide;
        @NotNull
        private final DiffDividerDrawUtil.DividerPaintable myPaintable;

        public MyDividerPainter(Side side) {
            if (side == null) {
                MyDividerPainter.$$$reportNull$$$0(0);
            }
            this.mySide = side;
            this.myPaintable = ThreesideTextDiffViewerEx.this.getDividerPaintable(side);
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                MyDividerPainter.$$$reportNull$$$0(1);
            }
            if (divider == null) {
                MyDividerPainter.$$$reportNull$$$0(2);
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE).getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor(ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE)));
            gg.fill(gg.getClipBounds());
            Editor editor1 = (Editor)this.mySide.select((Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.LEFT), (Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE));
            Editor editor2 = (Editor)this.mySide.select((Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE), (Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.RIGHT));
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), editor1, editor2, this.myPaintable);
            ThreesideTextDiffViewerEx.this.myFoldingModel.paintOnDivider(gg, divider, this.mySide);
            gg.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyDividerPainter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MySyncScrollable
    extends BaseSyncScrollable {
        @NotNull
        private final Side mySide;

        public MySyncScrollable(Side side) {
            if (side == null) {
                MySyncScrollable.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return ThreesideTextDiffViewerEx.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                MySyncScrollable.$$$reportNull$$$0(1);
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            if (!helper.process(0, 0)) {
                return;
            }
            for (ThreesideDiffChangeBase threesideDiffChangeBase : ThreesideTextDiffViewerEx.this.getAllChanges()) {
                if (!helper.process(threesideDiffChangeBase.getStartLine(left), threesideDiffChangeBase.getStartLine(right))) {
                    return;
                }
                if (helper.process(threesideDiffChangeBase.getEndLine(left), threesideDiffChangeBase.getEndLine(right))) continue;
                return;
            }
            helper.process(DiffUtil.getLineCount(ThreesideTextDiffViewerEx.this.getEditor(left).getDocument()), DiffUtil.getLineCount(ThreesideTextDiffViewerEx.this.getEditor(right).getDocument()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MySyncScrollable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processHelper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        public MyToggleExpandByDefaultAction() {
            super(ThreesideTextDiffViewerEx.this.getTextSettings());
        }

        @Override
        protected void expandAll(boolean expand) {
            ThreesideTextDiffViewerEx.this.myFoldingModel.expandAll(expand);
        }
    }

    protected class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<ThreesideDiffChangeBase> {
        protected MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<? extends ThreesideDiffChangeBase> getChanges() {
            List<? extends ThreesideDiffChangeBase> changes = ThreesideTextDiffViewerEx.this.getChanges();
            ThreeSide currentSide = ThreesideTextDiffViewerEx.this.getCurrentSide();
            if (currentSide == ThreeSide.BASE) {
                List<? extends ThreesideDiffChangeBase> list2 = changes;
                if (list2 == null) {
                    MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
                }
                return list2;
            }
            List list3 = ContainerUtil.filter(changes, change -> change.isChange(currentSide));
            if (list3 == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return list3;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = ThreesideTextDiffViewerEx.this.getCurrentEditor();
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull ThreesideDiffChangeBase change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return change.getStartLine(ThreesideTextDiffViewerEx.this.getCurrentSide());
        }

        @Override
        protected int getEndLine(@NotNull ThreesideDiffChangeBase change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(4);
            }
            return change.getEndLine(ThreesideTextDiffViewerEx.this.getCurrentSide());
        }

        @Override
        protected void scrollToChange(@NotNull ThreesideDiffChangeBase change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(5);
            }
            ThreesideTextDiffViewerEx.this.doScrollToChange(change, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextDifferenceIterable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "scrollToChange";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyPrevNextConflictIterable
    extends MyPrevNextDifferenceIterable {
        private MyPrevNextConflictIterable() {
        }

        @Override
        @NotNull
        protected List<? extends ThreesideDiffChangeBase> getChanges() {
            List<? extends ThreesideDiffChangeBase> changes = ThreesideTextDiffViewerEx.this.getChanges();
            List list2 = ContainerUtil.filter(changes, change -> change.isConflict());
            if (list2 == null) {
                MyPrevNextConflictIterable.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextConflictIterable", "getChanges"));
        }
    }

    private class NextConflictAction
    extends DumbAwareAction {
        NextConflictAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.NextConflict");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NextConflictAction.$$$reportNull$$$0(0);
            }
            if (!ThreesideTextDiffViewerEx.this.myPrevNextConflictIterable.canGoNext()) {
                return;
            }
            ThreesideTextDiffViewerEx.this.myPrevNextConflictIterable.goNext();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$NextConflictAction", "actionPerformed"));
        }
    }

    private class PrevConflictAction
    extends DumbAwareAction {
        PrevConflictAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.PreviousConflict");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                PrevConflictAction.$$$reportNull$$$0(0);
            }
            if (!ThreesideTextDiffViewerEx.this.myPrevNextConflictIterable.canGoPrev()) {
                return;
            }
            ThreesideTextDiffViewerEx.this.myPrevNextConflictIterable.goPrev();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$PrevConflictAction", "actionPerformed"));
        }
    }
}

