/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.visitors;

import com.intellij.diagnostic.hprof.navigator.RootReason;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import gnu.trove.TLongObjectHashMap;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J \u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J \u0010\u0016\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diagnostic/hprof/visitors/CollectRootReasonsVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "()V", "roots", "Lgnu/trove/TLongObjectHashMap;", "Lcom/intellij/diagnostic/hprof/navigator/RootReason;", "getRoots", "()Lgnu/trove/TLongObjectHashMap;", "preVisit", "", "visitRootGlobalJNI", "objectId", "", "jniGlobalRefId", "visitRootJavaFrame", "threadSerialNumber", "frameNumber", "visitRootLocalJNI", "visitRootMonitorUsed", "visitRootNativeStack", "visitRootStickyClass", "visitRootThreadBlock", "visitRootThreadObject", "stackTraceSerialNumber", "visitRootUnknown", "intellij.platform.ide.impl"})
public final class CollectRootReasonsVisitor
extends HProfVisitor {
    @NotNull
    private final TLongObjectHashMap<RootReason> roots = new TLongObjectHashMap();

    @NotNull
    public final TLongObjectHashMap<RootReason> getRoots() {
        return this.roots;
    }

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(HeapDumpRecordType.RootGlobalJNI);
        this.enable(HeapDumpRecordType.RootJavaFrame);
        this.enable(HeapDumpRecordType.RootLocalJNI);
        this.enable(HeapDumpRecordType.RootMonitorUsed);
        this.enable(HeapDumpRecordType.RootNativeStack);
        this.enable(HeapDumpRecordType.RootStickyClass);
        this.enable(HeapDumpRecordType.RootThreadBlock);
        this.enable(HeapDumpRecordType.RootThreadObject);
        this.enable(HeapDumpRecordType.RootUnknown);
    }

    @Override
    public void visitRootUnknown(long objectId) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootUnknown());
    }

    @Override
    public void visitRootGlobalJNI(long objectId, long jniGlobalRefId) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootGlobalJNI());
    }

    @Override
    public void visitRootLocalJNI(long objectId, long threadSerialNumber, long frameNumber) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootLocalJNI());
    }

    @Override
    public void visitRootJavaFrame(long objectId, long threadSerialNumber, long frameNumber) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootJavaFrame());
    }

    @Override
    public void visitRootNativeStack(long objectId, long threadSerialNumber) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootNativeStack());
    }

    @Override
    public void visitRootStickyClass(long objectId) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootStickyClass());
    }

    @Override
    public void visitRootThreadBlock(long objectId, long threadSerialNumber) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootThreadBlock());
    }

    @Override
    public void visitRootThreadObject(long objectId, long threadSerialNumber, long stackTraceSerialNumber) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootThreadObject());
    }

    @Override
    public void visitRootMonitorUsed(long objectId) {
        this.roots.put(objectId, (Object)RootReason.Companion.getRootMonitorUsed());
    }
}

