/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.BlockElement;
import com.intellij.codeInsight.hints.InlayHint;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.InlineElement;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.DocumentUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002'(B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\bH\u0002J \u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J>\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0006\u0010 \u001a\u00020\u0010J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0002J,\u0010$\u001a\u00020\f2\u0012\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010H\u0002J8\u0010$\u001a\u00020\f2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\u0006\u0010 \u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSinkImpl;", "T", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "(Lcom/intellij/codeInsight/hints/SettingsKey;)V", "hints", "Lgnu/trove/TIntObjectHashMap;", "Lcom/intellij/codeInsight/hints/InlayHint;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "addBlockElement", "", "offset", "", "relatesToPrecedingText", "", "showAbove", "priority", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "addHint", "hint", "addInlineElement", "applyToEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "existingHorizontalInlays", "", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "existingVerticalInlays", "isEnabled", "createNewHints", "inlayModel", "Lcom/intellij/openapi/editor/InlayModel;", "updateOrDeleteExistingHints", "existingInlays", "isInline", "Companion", "InlayListener", "intellij.platform.lang.impl"})
public final class InlayHintsSinkImpl<T>
implements InlayHintsSink {
    private final TIntObjectHashMap<InlayHint> hints;
    @NotNull
    private final SettingsKey<T> key;
    private static final Key<Object> INLAY_KEY;
    private static final int BulkChangeThreshold = 1000;
    public static final Companion Companion;

    public void addInlineElement(int offset, boolean relatesToPrecedingText, @NotNull InlayPresentation presentation) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        this.addHint(new InlineElement(offset, relatesToPrecedingText, presentation));
    }

    public void addBlockElement(int offset, boolean relatesToPrecedingText, boolean showAbove, int priority, @NotNull InlayPresentation presentation) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        this.addHint(new BlockElement(offset, relatesToPrecedingText, showAbove, priority, presentation));
    }

    private final void addHint(InlayHint hint) {
        this.hints.put(hint.getOffset(), (Object)hint);
    }

    public final void applyToEditor(@NotNull Editor editor, @NotNull List<? extends Inlay<EditorCustomElementRenderer>> existingHorizontalInlays, @NotNull List<? extends Inlay<EditorCustomElementRenderer>> existingVerticalInlays, boolean isEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull(existingHorizontalInlays, (String)"existingHorizontalInlays");
        Intrinsics.checkParameterIsNotNull(existingVerticalInlays, (String)"existingVerticalInlays");
        InlayModel inlayModel = editor.getInlayModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)inlayModel, (String)"editor.inlayModel");
        InlayModel inlayModel2 = inlayModel;
        boolean isBulkChange = existingHorizontalInlays.size() + this.hints.size() > 1000;
        DocumentUtil.executeInBulk(editor.getDocument(), isBulkChange, new Runnable(this, existingHorizontalInlays, existingVerticalInlays, isEnabled, inlayModel2){
            final /* synthetic */ InlayHintsSinkImpl this$0;
            final /* synthetic */ List $existingHorizontalInlays;
            final /* synthetic */ List $existingVerticalInlays;
            final /* synthetic */ boolean $isEnabled;
            final /* synthetic */ InlayModel $inlayModel;

            public final void run() {
                InlayHintsSinkImpl.access$updateOrDeleteExistingHints(this.this$0, this.$existingHorizontalInlays, this.$existingVerticalInlays, this.$isEnabled);
                InlayHintsSinkImpl.access$createNewHints(this.this$0, this.$inlayModel);
            }
            {
                this.this$0 = inlayHintsSinkImpl;
                this.$existingHorizontalInlays = list2;
                this.$existingVerticalInlays = list3;
                this.$isEnabled = bl;
                this.$inlayModel = inlayModel;
            }
        });
        this.hints.clear();
    }

    private final void createNewHints(InlayModel inlayModel) {
        this.hints.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<InlayHint>(this, inlayModel){
            final /* synthetic */ InlayHintsSinkImpl this$0;
            final /* synthetic */ InlayModel $inlayModel;

            public final boolean execute(int offset, InlayHint hint) {
                Inlay inlay;
                InlayPresentation presentation = hint.getPresentation();
                PresentationRenderer presentationRenderer = new PresentationRenderer(presentation);
                InlayHint inlayHint = hint;
                if (inlayHint instanceof InlineElement) {
                    inlay = this.$inlayModel.addInlineElement(offset, ((InlineElement)hint).getRelatesToPrecedingText(), (EditorCustomElementRenderer)presentationRenderer);
                } else if (inlayHint instanceof BlockElement) {
                    inlay = this.$inlayModel.addBlockElement(offset, ((BlockElement)hint).getRelatesToPrecedingText(), ((BlockElement)hint).getShowAbove(), ((BlockElement)hint).getPriority(), (EditorCustomElementRenderer)presentationRenderer);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (inlay == null) {
                    return true;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)inlay, (String)"when (hint) {\n        is\u2026 return@forEachEntry true");
                Inlay inlay2 = inlay;
                inlay2.putUserData(InlayHintsSinkImpl.access$getINLAY_KEY$cp(), this.this$0.getKey());
                presentation.addListener((PresentationListener)new InlayListener((Inlay<PresentationRenderer>)inlay2));
                return true;
            }
            {
                this.this$0 = inlayHintsSinkImpl;
                this.$inlayModel = inlayModel;
            }
        });
    }

    private final void updateOrDeleteExistingHints(List<? extends Inlay<EditorCustomElementRenderer>> existingHorizontalInlays, List<? extends Inlay<EditorCustomElementRenderer>> existingVerticalInlays, boolean isEnabled) {
        this.updateOrDeleteExistingHints(existingHorizontalInlays, true, isEnabled);
        this.updateOrDeleteExistingHints(existingVerticalInlays, false, isEnabled);
    }

    private final void updateOrDeleteExistingHints(List<? extends Inlay<EditorCustomElementRenderer>> existingInlays, boolean isInline, boolean isEnabled) {
        for (Inlay<EditorCustomElementRenderer> inlay : existingInlays) {
            int offset;
            InlayHint newHint;
            SettingsKey inlayKey = (SettingsKey)inlay.getUserData(INLAY_KEY);
            if (Intrinsics.areEqual((Object)inlayKey, this.key) ^ true || (newHint = (InlayHint)this.hints.get(offset = inlay.getOffset())) != null && newHint instanceof InlineElement != isInline) continue;
            if (newHint == null || !isEnabled) {
                Disposer.dispose((Disposable)((Disposable)inlay));
                continue;
            }
            InlayPresentation newPresentation = newHint.getPresentation();
            EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
            if (editorCustomElementRenderer == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.hints.presentation.PresentationRenderer");
            }
            PresentationRenderer renderer2 = (PresentationRenderer)editorCustomElementRenderer;
            InlayPresentation previousPresentation = renderer2.getPresentation();
            Inlay<EditorCustomElementRenderer> inlay2 = inlay;
            if (inlay2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.Inlay<com.intellij.codeInsight.hints.presentation.PresentationRenderer>");
            }
            newPresentation.addListener((PresentationListener)new InlayListener(inlay2));
            renderer2.setPresentation(newPresentation);
            if (newPresentation.updateState(previousPresentation)) {
                InlayHintsUtilsKt.fireUpdateEvent(newPresentation, InlayHintsUtilsKt.dimension(previousPresentation));
            }
            this.hints.remove(offset);
        }
    }

    @NotNull
    public final SettingsKey<T> getKey() {
        return this.key;
    }

    public InlayHintsSinkImpl(@NotNull SettingsKey<T> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        this.key = key;
        this.hints = new TIntObjectHashMap();
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"INLAY_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"INLAY_KEY\")");
        INLAY_KEY = key;
    }

    public static final /* synthetic */ void access$updateOrDeleteExistingHints(InlayHintsSinkImpl $this, List existingHorizontalInlays, List existingVerticalInlays, boolean isEnabled) {
        $this.updateOrDeleteExistingHints((List<Inlay<EditorCustomElementRenderer>>)existingHorizontalInlays, existingVerticalInlays, isEnabled);
    }

    public static final /* synthetic */ void access$createNewHints(InlayHintsSinkImpl $this, InlayModel inlayModel) {
        $this.createNewHints(inlayModel);
    }

    public static final /* synthetic */ Key access$getINLAY_KEY$cp() {
        return INLAY_KEY;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSinkImpl$InlayListener;", "Lcom/intellij/codeInsight/hints/presentation/PresentationListener;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/codeInsight/hints/presentation/PresentationRenderer;", "(Lcom/intellij/openapi/editor/Inlay;)V", "contentChanged", "", "area", "Ljava/awt/Rectangle;", "sizeChanged", "previous", "Ljava/awt/Dimension;", "current", "intellij.platform.lang.impl"})
    public static final class InlayListener
    implements PresentationListener {
        private final Inlay<PresentationRenderer> inlay;

        public void contentChanged(@NotNull Rectangle area) {
            Intrinsics.checkParameterIsNotNull((Object)area, (String)"area");
            this.inlay.repaint();
        }

        public void sizeChanged(@NotNull Dimension previous, @NotNull Dimension current) {
            Intrinsics.checkParameterIsNotNull((Object)previous, (String)"previous");
            Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
            this.inlay.updateSize();
        }

        public InlayListener(@NotNull Inlay<PresentationRenderer> inlay) {
            Intrinsics.checkParameterIsNotNull(inlay, (String)"inlay");
            this.inlay = inlay;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSinkImpl$Companion;", "", "()V", "BulkChangeThreshold", "", "INLAY_KEY", "Lcom/intellij/openapi/util/Key;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

