/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.VirtualFileResolver;
import com.intellij.configurationStore.schemeManager.SchemeFileTracker;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u0002:\u0003234B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0091\u0001\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u0014\"\b\b\u0001\u0010\u0015*\u0002H\u00132\u0006\u0010\u0016\u001a\u00020\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00150\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2%\u0010\u001c\u001a!\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u000f0\u001dj\u0002` 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&J3\u0010'\u001a-\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b((\u0012\u0004\u0012\u00020)\u0018\u00010\u001dj\u0004\u0018\u0001`*H\u0014J\u0014\u0010+\u001a\u00020)2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0014J\u0010\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020\u000fH&J&\u00100\u001a\u00020)2\u001e\u0010\u0017\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020)0\u001dJ\u0006\u00101\u001a\u00020)R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R`\u0010\b\u001aT\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b \f*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n \f*(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b \f*\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n0\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003567\u00a8\u00068"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "Lcom/intellij/openapi/components/SettingsSavingComponent;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "managers", "", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "Lcom/intellij/openapi/options/Scheme;", "kotlin.jvm.PlatformType", "", "checkPath", "", "originalPath", "create", "Lcom/intellij/openapi/options/SchemeManager;", "T", "", "MutableT", "directoryName", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "presentableName", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "schemeNameToFileName", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lcom/intellij/configurationStore/SchemeNameToFileName;", "streamProvider", "Lcom/intellij/configurationStore/StreamProvider;", "directoryPath", "Ljava/nio/file/Path;", "isAutoSave", "", "createFileChangeSubscriber", "schemeManager", "", "Lcom/intellij/configurationStore/schemeManager/FileChangeSubscriber;", "dispose", "getVirtualFileResolver", "Lcom/intellij/configurationStore/VirtualFileResolver;", "pathToFile", "path", "process", "save", "ApplicationSchemeManagerFactory", "ProjectSchemeManagerFactory", "TestSchemeManagerFactory", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$TestSchemeManagerFactory;", "intellij.platform.configurationStore.impl"})
public abstract class SchemeManagerFactoryBase
extends SchemeManagerFactory
implements SettingsSavingComponent {
    private final List<SchemeManagerImpl<Scheme, Scheme>> managers;
    @Nullable
    private final ComponentManager componentManager;

    @Nullable
    protected ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Nullable
    protected Function1<SchemeManagerImpl<?, ?>, Unit> createFileChangeSubscriber() {
        return null;
    }

    @Nullable
    protected VirtualFileResolver getVirtualFileResolver() {
        return null;
    }

    @NotNull
    public final <T, MutableT extends T> SchemeManager<T> create(@NotNull String directoryName, @NotNull SchemeProcessor<T, ? super MutableT> processor2, @Nullable String presentableName, @NotNull RoamingType roamingType, @NotNull Function1<? super String, String> schemeNameToFileName, @Nullable StreamProvider streamProvider, @Nullable Path directoryPath, boolean isAutoSave) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)directoryName, (String)"directoryName");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(schemeNameToFileName, (String)"schemeNameToFileName");
        String path2 = this.checkPath(directoryName);
        Function1<SchemeManagerImpl<?, ?>, Unit> fileChangeSubscriber = streamProvider != null && streamProvider.isApplicable(path2, roamingType) ? null : this.createFileChangeSubscriber();
        StreamProvider streamProvider2 = streamProvider;
        if (streamProvider2 == null) {
            StateStorageManager stateStorageManager;
            ComponentManager componentManager = this.getComponentManager();
            if (!((componentManager != null && (componentManager = ServiceKt.getStateStore((ComponentManager)componentManager)) != null ? componentManager.getStorageManager() : (stateStorageManager = null)) instanceof StateStorageManagerImpl)) {
                stateStorageManager = null;
            }
            StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
            streamProvider2 = stateStorageManagerImpl != null ? stateStorageManagerImpl.getCompoundStreamProvider() : null;
        }
        if ((path = directoryPath) == null) {
            path = this.pathToFile(path2);
        }
        SchemeManagerImpl<T, ? super MutableT> manager = new SchemeManagerImpl<T, MutableT>(path2, processor2, streamProvider2, path, roamingType, presentableName, schemeNameToFileName, fileChangeSubscriber, this.getVirtualFileResolver());
        if (isAutoSave) {
            this.managers.add(manager);
        }
        return (SchemeManager)manager;
    }

    public void dispose(@NotNull SchemeManager<?> schemeManager) {
        Intrinsics.checkParameterIsNotNull(schemeManager, (String)"schemeManager");
        Collection collection = this.managers;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(schemeManager);
    }

    @NotNull
    public String checkPath(@NotNull String originalPath) {
        Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
        if (StringsKt.contains$default((CharSequence)originalPath, (char)'\\', (boolean)false, (int)2, null)) {
            ComponentStoreImplKt.getLOG().error("Path must be system-independent, use forward slash instead of backslash");
        } else {
            CharSequence charSequence = originalPath;
            boolean bl = false;
            if (charSequence.length() == 0) {
                ComponentStoreImplKt.getLOG().error("Path must not be empty");
            }
        }
        return originalPath;
    }

    @NotNull
    public abstract Path pathToFile(@NotNull String var1);

    public final void process(@NotNull Function1<? super SchemeManagerImpl<Scheme, Scheme>, Unit> processor2) {
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        for (SchemeManagerImpl<Scheme, Scheme> manager : this.managers) {
            try {
                SchemeManagerImpl<Scheme, Scheme> schemeManagerImpl = manager;
                Intrinsics.checkExpressionValueIsNotNull(schemeManagerImpl, (String)"manager");
                processor2.invoke(schemeManagerImpl);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error("Cannot reload settings for " + ((Object)manager).getClass().getName(), e);
            }
        }
    }

    public final void save() {
        SmartList errors = new SmartList();
        for (SchemeManagerImpl<Scheme, Scheme> registeredManager : this.managers) {
            try {
                registeredManager.save((List)errors);
            }
            catch (Throwable e) {
                errors.add((Object)e);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)((List)errors));
    }

    private SchemeManagerFactoryBase() {
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLock\u2026erImpl<Scheme, Scheme>>()");
        this.managers = list;
    }

    public /* synthetic */ SchemeManagerFactoryBase(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "()V", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "checkPath", "", "originalPath", "pathToFile", "Ljava/nio/file/Path;", "path", "intellij.platform.configurationStore.impl"})
    private static final class ApplicationSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @Override
        @NotNull
        protected ComponentManager getComponentManager() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            return (ComponentManager)application;
        }

        @Override
        @NotNull
        public String checkPath(@NotNull String originalPath) {
            Intrinsics.checkParameterIsNotNull((Object)originalPath, (String)"originalPath");
            String path = super.checkPath(originalPath);
            if (StringsKt.startsWith$default((String)path, (String)"$ROOT_CONFIG$", (boolean)false, (int)2, null)) {
                String string = path;
                int n = 14;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                path = string3;
                String message = "Path must not contains ROOT_CONFIG macro, corrected: " + path;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                ComponentStoreImplKt.getLOG().warn(message);
            }
            return path;
        }

        @Override
        @NotNull
        public Path pathToFile(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            Path path2 = Paths.get(ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager().expandMacros("$ROOT_CONFIG$"), path);
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            return path2;
        }

        public ApplicationSchemeManagerFactory() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J3\u0010\f\u001a-\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\t\u0018\u00010\rj\u0004\u0018\u0001`\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentManager", "getComponentManager", "()Lcom/intellij/openapi/project/Project;", "addVfsListener", "", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "createFileChangeSubscriber", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lcom/intellij/configurationStore/schemeManager/FileChangeSubscriber;", "getVirtualFileResolver", "Lcom/intellij/configurationStore/VirtualFileResolver;", "pathToFile", "Ljava/nio/file/Path;", "path", "", "intellij.platform.configurationStore.impl"})
    private static final class ProjectSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        @NotNull
        private final Project componentManager;
        private final Project project;

        @NotNull
        protected Project getComponentManager() {
            return this.componentManager;
        }

        @Override
        @Nullable
        protected VirtualFileResolver getVirtualFileResolver() {
            Project project = this.project;
            if (!(project instanceof VirtualFileResolver)) {
                project = null;
            }
            return (VirtualFileResolver)project;
        }

        private final void addVfsListener(SchemeManagerImpl<?, ?> schemeManager) {
            SchemeManagerImpl<Object, Object> schemeManagerImpl = schemeManager;
            if (schemeManagerImpl == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerImpl<kotlin.Any, kotlin.Any>");
            }
            this.project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new SchemeFileTracker(schemeManagerImpl, this.project));
        }

        @Override
        @Nullable
        protected Function1<SchemeManagerImpl<?, ?>, Unit> createFileChangeSubscriber() {
            return new Function1<SchemeManagerImpl<?, ?>, Unit>(this){
                final /* synthetic */ ProjectSchemeManagerFactory this$0;

                public final void invoke(@NotNull SchemeManagerImpl<?, ?> schemeManager) {
                    StartupManagerEx startupManager;
                    Intrinsics.checkParameterIsNotNull(schemeManager, (String)"schemeManager");
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    StartupManagerEx startupManagerEx = startupManager = application.isUnitTestMode() ? null : StartupManagerEx.getInstanceEx((Project)ProjectSchemeManagerFactory.access$getProject$p(this.this$0));
                    if (startupManager == null || startupManager.postStartupActivityPassed()) {
                        ProjectSchemeManagerFactory.access$addVfsListener(this.this$0, schemeManager);
                    } else {
                        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(this, schemeManager){
                            final /* synthetic */ createFileChangeSubscriber.1 this$0;
                            final /* synthetic */ SchemeManagerImpl $schemeManager;

                            public final void run() {
                                ProjectSchemeManagerFactory.access$addVfsListener(this.this$0.this$0, this.$schemeManager);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$schemeManager = schemeManagerImpl;
                            }
                        });
                    }
                }
                {
                    this.this$0 = projectSchemeManagerFactory;
                    super(1);
                }
            };
        }

        @Override
        @NotNull
        public Path pathToFile(@NotNull String path) {
            String projectFileDir;
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)this.project));
            if (!(iComponentStore instanceof IProjectStore)) {
                iComponentStore = null;
            }
            IProjectStore iProjectStore = (IProjectStore)iComponentStore;
            String string = projectFileDir = iProjectStore != null ? iProjectStore.getProjectConfigDir() : null;
            if (projectFileDir == null) {
                Path path2 = Paths.get(this.project.getBasePath(), '.' + path);
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(project.basePath, \".$path\")");
                return path2;
            }
            Path path3 = Paths.get(projectFileDir, path);
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(projectFileDir, path)");
            return path3;
        }

        public ProjectSchemeManagerFactory(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            super(null);
            this.componentManager = this.project = project;
        }

        public static final /* synthetic */ Project access$getProject$p(ProjectSchemeManagerFactory $this) {
            return $this.project;
        }

        public static final /* synthetic */ void access$addVfsListener(ProjectSchemeManagerFactory $this, SchemeManagerImpl schemeManager) {
            $this.addVfsListener(schemeManager);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase$TestSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "basePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "pathToFile", "path", "", "intellij.platform.configurationStore.impl"})
    public static final class TestSchemeManagerFactory
    extends SchemeManagerFactoryBase {
        private final Path basePath;

        @Override
        @NotNull
        public Path pathToFile(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Path path2 = this.basePath.resolve(path);
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            return path2;
        }

        public TestSchemeManagerFactory(@NotNull Path basePath) {
            Intrinsics.checkParameterIsNotNull((Object)basePath, (String)"basePath");
            super(null);
            this.basePath = basePath;
        }
    }
}

