/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.DataWriterFilter;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.configurationStore.StateMap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vfs.SafeWriteUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.io.PathKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a,\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u000bH\u0002\u001a\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r*\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\u0016\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0000\u001a \u0010\u0014\u001a\u00020\u0015*\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0005H\u0000\u00a8\u0006\u0018"}, d2={"createDataWriterForElement", "Lcom/intellij/configurationStore/DataWriter;", "element", "Lorg/jdom/Element;", "storageFilePathForDebugPurposes", "", "save", "", "states", "Lcom/intellij/configurationStore/StateMap;", "newLiveStates", "", "getChangedComponentNames", "", "newStates", "normalizeRootName", "toBufferExposingByteArray", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "writeTo", "", "file", "Ljava/nio/file/Path;", "intellij.platform.configurationStore.impl"})
public final class XmlElementStorageKt {
    private static final List<Element> save(StateMap states, Map<String, ? extends Element> newLiveStates) {
        if (states.isEmpty()) {
            return null;
        }
        List result = null;
        for (String componentName : states.keys()) {
            Element element = null;
            try {
                Element element2 = states.getElement(componentName, newLiveStates);
                if (element2 == null || (element2 = element2.clone()) == null) {
                    continue;
                }
                element = element2;
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error("Cannot save \"" + componentName + "\" data", (Throwable)e);
                continue;
            }
            List elementAttributes = element.getAttributes();
            Attribute nameAttribute = element.getAttribute("name");
            if (nameAttribute == null || nameAttribute != (Attribute)elementAttributes.get(0) || !Intrinsics.areEqual((Object)componentName, (Object)nameAttribute.getValue())) {
                if (nameAttribute == null) {
                    nameAttribute = new Attribute("name", componentName);
                    elementAttributes.add(0, nameAttribute);
                } else {
                    nameAttribute.setValue(componentName);
                    if (Intrinsics.areEqual((Object)((Attribute)elementAttributes.get(0)), (Object)nameAttribute) ^ true) {
                        elementAttributes.remove(nameAttribute);
                        elementAttributes.add(0, nameAttribute);
                    }
                }
            }
            if (result == null) {
                result = (List)new SmartList();
            }
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final Element normalizeRootName(@NotNull Element $this$normalizeRootName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$normalizeRootName, (String)"$this$normalizeRootName");
        if (JDOMInterner.isInterned((Element)$this$normalizeRootName)) {
            if (Intrinsics.areEqual((Object)$this$normalizeRootName.getName(), (Object)"component")) {
                return $this$normalizeRootName;
            }
            Element element = $this$normalizeRootName.clone();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"clone()");
            Element clone = element;
            clone.setName("component");
            return clone;
        }
        if ($this$normalizeRootName.getParent() != null) {
            ComponentStoreImplKt.getLOG().warn("State element must not have parent: " + JDOMUtil.writeElement((Element)$this$normalizeRootName));
            $this$normalizeRootName.detach();
        }
        $this$normalizeRootName.setName("component");
        return $this$normalizeRootName;
    }

    private static final Set<String> getChangedComponentNames(@NotNull StateMap $this$getChangedComponentNames, StateMap newStates) {
        Set bothStates = ArraysKt.toMutableSet((Object[])$this$getChangedComponentNames.keys());
        CollectionsKt.retainAll((Collection)bothStates, (Object[])newStates.keys());
        SmartHashSet diffs = new SmartHashSet();
        CollectionsKt.addAll((Collection)((Collection)diffs), (Object[])newStates.keys());
        CollectionsKt.addAll((Collection)((Collection)diffs), (Object[])$this$getChangedComponentNames.keys());
        diffs.removeAll((Collection)bothStates);
        for (String componentName : bothStates) {
            $this$getChangedComponentNames.compare(componentName, newStates, (Set)diffs);
        }
        return (Set)diffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeTo(@Nullable DataWriter $this$writeTo, @NotNull Path file, @NotNull String lineSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        if ($this$writeTo == null) {
            PathKt.delete$default((Path)file, (boolean)false, (int)1, null);
        } else {
            Closeable closeable = SafeWriteUtil.safeOutputStream((Path)file, null);
            boolean bl = false;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl2 = false;
                DataWriter.DefaultImpls.write$default($this$writeTo, it, lineSeparator, null, 4, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public static /* synthetic */ void writeTo$default(DataWriter dataWriter, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            String string2 = LineSeparator.LF.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"LineSeparator.LF.separatorString");
            string = string2;
        }
        XmlElementStorageKt.writeTo(dataWriter, path, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final BufferExposingByteArrayOutputStream toBufferExposingByteArray(@NotNull DataWriter $this$toBufferExposingByteArray, @NotNull LineSeparator lineSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toBufferExposingByteArray, (String)"$this$toBufferExposingByteArray");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(1024);
        Closeable closeable = (Closeable)out;
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferExposingByteArrayOutputStream it = (BufferExposingByteArrayOutputStream)closeable;
            boolean bl2 = false;
            OutputStream outputStream = (OutputStream)out;
            String string = lineSeparator.getSeparatorString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
            DataWriter.DefaultImpls.write$default($this$toBufferExposingByteArray, outputStream, string, null, 4, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return out;
    }

    public static /* synthetic */ BufferExposingByteArrayOutputStream toBufferExposingByteArray$default(DataWriter dataWriter, LineSeparator lineSeparator, int n, Object object) {
        if ((n & 1) != 0) {
            lineSeparator = LineSeparator.LF;
        }
        return XmlElementStorageKt.toBufferExposingByteArray(dataWriter, lineSeparator);
    }

    @NotNull
    public static final DataWriter createDataWriterForElement(@NotNull Element element, @NotNull String storageFilePathForDebugPurposes) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)storageFilePathForDebugPurposes, (String)"storageFilePathForDebugPurposes");
        return new DataWriter(element, storageFilePathForDebugPurposes){
            final /* synthetic */ Element $element;
            final /* synthetic */ String $storageFilePathForDebugPurposes;

            public boolean hasData(@NotNull DataWriterFilter filter) {
                Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
                return filter.hasData(this.$element);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(@NotNull OutputStream output, @NotNull String lineSeparator, @Nullable DataWriterFilter filter) {
                Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
                Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
                Closeable closeable = output;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Closeable closeable2 = closeable;
                int n = 0;
                closeable2 = new OutputStreamWriter((OutputStream)closeable2, charset);
                n = 8192;
                boolean bl2 = false;
                closeable = closeable2 instanceof BufferedWriter ? (BufferedWriter)closeable2 : new BufferedWriter((Writer)closeable2, n);
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    BufferedWriter it = (BufferedWriter)closeable;
                    boolean bl4 = false;
                    DataWriterFilter dataWriterFilter = filter;
                    new JbXmlOutputter(lineSeparator, (JDOMUtil.ElementOutputFilter)(dataWriterFilter != null ? dataWriterFilter.toElementFilter() : null), null, null, false, this.$storageFilePathForDebugPurposes, 28, null).output(this.$element, (Writer)it);
                    closeable2 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.$element = $captured_local_variable$0;
                this.$storageFilePathForDebugPurposes = $captured_local_variable$1;
            }
        };
    }

    public static final /* synthetic */ List access$save(StateMap states, Map newLiveStates) {
        return XmlElementStorageKt.save(states, newLiveStates);
    }

    public static final /* synthetic */ Set access$getChangedComponentNames(StateMap $this$access_u24getChangedComponentNames, StateMap newStates) {
        return XmlElementStorageKt.getChangedComponentNames($this$access_u24getChangedComponentNames, newStates);
    }
}

