/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.PgGPlumJdbcHelperBase;
import java.sql.Connection;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.PostgresExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.PostgresIntermediateFacade;

public class PgJdbcHelper
extends PgGPlumJdbcHelperBase {
    private static final Pattern PG_VERSION_PATTERN = Pattern.compile("(\\d+(?:(?:alpha|beta|rc)\\d*|\\.\\d+)(?:\\.\\d+)*)", 2);

    public PgJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Postgres.RDBMS, version, connection);
    }

    public PgJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return PgJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            PgJdbcHelper.$$$reportNull$$$0(0);
        }
        PostgresIntermediateFacade postgresIntermediateFacade = new PostgresIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)PostgresExceptionRecognizer.INSTANCE);
        if (postgresIntermediateFacade == null) {
            PgJdbcHelper.$$$reportNull$$$0(1);
        }
        return postgresIntermediateFacade;
    }

    @NotNull
    protected static PgJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        String version = PgJdbcHelper.extractVersion(productVer);
        PgJdbcHelper pgJdbcHelper = new PgJdbcHelper(version, delegate);
        if (pgJdbcHelper == null) {
            PgJdbcHelper.$$$reportNull$$$0(2);
        }
        return pgJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, PG_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/PgJdbcHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/PgJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

