/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.sql.Connection;
import java.util.Locale;
import java.util.Set;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.H2dbExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.H2dbIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;

public class H2JdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> H2_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"uuid", "geometry", "other", "array", "timestamp with time zone", "null", "result_set"});
    private static final Set<String> H2_LIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"varchar", "varchar_ignorecase", "char", "tid"});

    public H2JdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(H2db.RDBMS, version, connection);
    }

    public H2JdbcHelper() {
        this(null, null);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            H2JdbcHelper.$$$reportNull$$$0(0);
        }
        H2dbIntermediateFacade h2dbIntermediateFacade = new H2dbIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)H2dbExceptionRecognizer.INSTANCE);
        if (h2dbIntermediateFacade == null) {
            H2JdbcHelper.$$$reportNull$$$0(1);
        }
        return h2dbIntermediateFacade;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            H2JdbcHelper.$$$reportNull$$$0(2);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        int n = e.length;
        if (n == 0x7FFFFFFE) {
            e.length = Integer.MAX_VALUE;
        } else if (H2_UNLIMITED_TYPES.contains(t) || n == 1 && "boolean".equals(t) || H2_LIMITED_TYPES.contains(t) && n == Integer.MAX_VALUE || t.equals("decimal") && e.scale == Short.MAX_VALUE && e.length == 65535) {
            e.length = -1;
        } else if (t.equals("varbinary")) {
            e.typeName = "binary";
            if (e.length == Integer.MAX_VALUE) {
                e.length = -1;
            }
        }
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return H2JdbcHelper.extractVersion(version);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) {
        if (!JdbcNativeUtil.detectString(product, "H2")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return H2JdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static H2JdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        H2JdbcHelper h2JdbcHelper = new H2JdbcHelper(H2JdbcHelper.extractVersion(productVer), delegate);
        if (h2JdbcHelper == null) {
            H2JdbcHelper.$$$reportNull$$$0(3);
        }
        return h2JdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/H2JdbcHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/H2JdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

