/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class GenericJdbcHelper
extends JdbcHelperImpl {
    private final String myProduct;

    public GenericJdbcHelper(@Nullable String product, @Nullable String version, @Nullable Connection connection) {
        super(UnknownDatabase.RDBMS, version, connection);
        this.myProduct = product == null ? UnknownDatabase.RDBMS.code : product;
    }

    public GenericJdbcHelper() {
        this((String)null, (String)null, (Connection)null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    @NotNull
    public String getDbmsName() {
        String string = this.myProduct;
        if (string == null) {
            GenericJdbcHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public final GenericJdbcHelper detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        DatabaseMetaData md = delegate == null ? null : delegate.getMetaData();
        String version = null;
        if (md != null) {
            try {
                version = md.getDatabaseMajorVersion() + "." + md.getDatabaseMinorVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (version == null) {
            version = JdbcNativeUtil.findVersion(productVer, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product + "\ngetDatabaseMajorVersion.getDatabaseMinorVersion: " + version);
        GenericJdbcHelper genericJdbcHelper = new GenericJdbcHelper(product, version, delegate);
        if (genericJdbcHelper == null) {
            GenericJdbcHelper.$$$reportNull$$$0(1);
        }
        return genericJdbcHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/remote/jdbc/helpers/GenericJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbmsName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

