/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.util.Strings;

public class Directories {
    @NotNull
    public List<File> listFilesRecursively(@NotNull File dir, @NotNull Pattern fileNamePattern) {
        ArrayList<File> files = new ArrayList<File>();
        this.listFilesRecursively(dir, fileNamePattern, files);
        return files;
    }

    private void listFilesRecursively(@NotNull File dir, final @NotNull Pattern fileNamePattern, @NotNull Collection<File> foundFiles) {
        File[] nestedDirs;
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && Strings.matches(file.getName(), fileNamePattern);
            }
        });
        if (files != null) {
            Collections.addAll(foundFiles, files);
        }
        if ((nestedDirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) != null) {
            for (File nestedDir : nestedDirs) {
                this.listFilesRecursively(nestedDir, fileNamePattern, foundFiles);
            }
        }
    }
}

