/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.exceptions;

import java.sql.SQLException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.exceptions.StrippedSQLException;
import org.jetbrains.dekaf.exceptions.StrippedUnknownException;

public abstract class DBException
extends RuntimeException {
    public final int vendorErrorCode;
    public final String statementText;

    protected DBException(@NotNull SQLException sqlException, @Nullable String statementText) {
        this(sqlException.getMessage(), (Throwable)sqlException, sqlException.getErrorCode(), statementText);
    }

    protected DBException(@NotNull String message, @NotNull SQLException sqlException, @Nullable String statementText) {
        this(message, (Throwable)sqlException, sqlException.getErrorCode(), statementText);
    }

    protected DBException(@NotNull String message, @NotNull Exception exception, String statementText) {
        this(message, (Throwable)exception, 0, statementText);
    }

    protected DBException(@NotNull String message, @Nullable String statementText) {
        this(message, null, 0, statementText);
    }

    public DBException(@NotNull String message, @Nullable Throwable cause, @Nullable String statementText) {
        this(message, cause, 0, statementText);
    }

    private DBException(@NotNull String message, @Nullable Throwable cause, int vendorErrorCode, @Nullable String statementText) {
        super(DBException.makeErrorText(message, cause), DBException.stripException(cause));
        this.vendorErrorCode = vendorErrorCode;
        this.statementText = statementText;
    }

    @NotNull
    private static String makeErrorText(@NotNull String message, @Nullable Throwable cause) {
        String causeMessage = cause != null ? cause.getMessage() : null;
        return causeMessage != null && !message.endsWith(".") && !message.contains(causeMessage) ? message + " (" + causeMessage + ")" : message;
    }

    @Contract(value="null->null; !null->!null")
    private static Throwable stripException(Throwable e) {
        boolean causeOk;
        if (e == null) {
            return null;
        }
        String className = e.getClass().getName();
        boolean classOk = e instanceof DBException || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.jdbc.odbc.");
        Throwable originalCause = e.getCause();
        Throwable strippedCause = DBException.stripException(originalCause);
        boolean bl = causeOk = originalCause == strippedCause;
        if (classOk && causeOk) {
            return e;
        }
        Exception strippedException = e instanceof SQLException ? new StrippedSQLException((SQLException)e, strippedCause) : new StrippedUnknownException(e, strippedCause);
        return strippedException;
    }

    @Override
    public String toString() {
        String message = this.getMessage();
        StringBuilder b = new StringBuilder(message);
        if (this.statementText != null) {
            b.append("\nThe SQL statement:\n").append(this.statementText).append('\n');
        }
        return b.toString();
    }
}

