/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.OutlineStepSubstitution;
import org.jetbrains.plugins.cucumber.ParameterTypeManager;
import org.jetbrains.plugins.cucumber.steps.search.CucumberStepSearchUtil;

public class CucumberUtil {
    @NonNls
    public static final String STEP_DEFINITIONS_DIR_NAME = "step_definitions";
    public static final String[][] ARR = new String[][]{{"\\\\", "\\\\\\\\"}, {"\\|", "\\\\|"}, {"\\$", "\\\\\\$"}, {"\\^", "\\\\^"}, {"\\+", "\\+"}, {"\\-", "\\\\-"}, {"\\#", "\\\\#"}, {"\\?", "\\\\?"}, {"\\*", "\\\\*"}, {"\\/", "\\\\/"}, {"\\{", "\\\\{"}, {"\\}", "\\\\}"}, {"\\[", "\\\\["}, {"\\]", "\\\\]"}, {"\\(", "\\\\("}, {"\\)", "\\\\)"}, {"\\+", "\\\\+"}, {"\"([^\\\\\"]*)\"", "\"([^\"]*)\""}, {"(?<=^|[ .,])\\d+[ ]", "(\\\\d+) "}, {"(?<=^|[ .,])\\d+[,]", "(\\\\d+),"}, {"(?<=^|[ .,])\\d+[.]", "(\\\\d+)."}, {"(?<=^|[ .,])\\d+$", "(\\\\d+)"}, {"\\.", "\\\\."}, {"(<[^>]*>)", "(.*)"}};
    public static final String PREFIX_CHAR = "^";
    public static final String SUFFIX_CHAR = "$";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("([\\\\^\\[$.|?*+\\]])");
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("(\\\\\\\\)?\\(([^)]+)\\)");
    public static final Map<String, String> STANDARD_PARAMETER_TYPES;

    public static boolean findGherkinReferencesToElement(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchScope effectiveSearchScope) {
        if (stepDefinitionElement == null) {
            CucumberUtil.$$$reportNull$$$0(0);
        }
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            CucumberUtil.$$$reportNull$$$0(2);
        }
        if (effectiveSearchScope == null) {
            CucumberUtil.$$$reportNull$$$0(3);
        }
        return CucumberUtil.findPossibleGherkinElementUsages(stepDefinitionElement, regexp, new MyReferenceCheckingProcessor(stepDefinitionElement, consumer), effectiveSearchScope);
    }

    public static boolean findPossibleGherkinElementUsages(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull TextOccurenceProcessor processor, @NotNull SearchScope effectiveSearchScope) {
        String word;
        if (stepDefinitionElement == null) {
            CucumberUtil.$$$reportNull$$$0(4);
        }
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            CucumberUtil.$$$reportNull$$$0(6);
        }
        if (effectiveSearchScope == null) {
            CucumberUtil.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmptyOrSpaces((String)(word = CucumberUtil.getTheBiggestWordToSearchByIndex(regexp)))) {
            return true;
        }
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> CucumberStepSearchUtil.restrictScopeToGherkinFiles(effectiveSearchScope));
        int context = 5;
        PsiSearchHelper instance = PsiSearchHelper.getInstance((Project)stepDefinitionElement.getProject());
        return instance.processElementsWithWord(processor, searchScope, word, (short)5, true);
    }

    public static void findPossibleGherkinElementUsages(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull ReferencesSearch.SearchParameters params, @NotNull RequestResultProcessor processor) {
        String word;
        if (stepDefinitionElement == null) {
            CucumberUtil.$$$reportNull$$$0(8);
        }
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(9);
        }
        if (params == null) {
            CucumberUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            CucumberUtil.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmptyOrSpaces((String)(word = CucumberUtil.getTheBiggestWordToSearchByIndex(regexp)))) {
            return;
        }
        SearchScope searchScope = CucumberStepSearchUtil.restrictScopeToGherkinFiles(params.getEffectiveSearchScope());
        int searchContext = 5;
        params.getOptimizer().searchWord(word, searchScope, (short)5, true, stepDefinitionElement, processor);
    }

    public static String getTheBiggestWordToSearchByIndex(@NotNull String regexp) {
        if (regexp == null) {
            CucumberUtil.$$$reportNull$$$0(12);
        }
        String result = "";
        int start = 0;
        if (regexp.startsWith(PREFIX_CHAR)) {
            start += PREFIX_CHAR.length();
        }
        int end = regexp.length();
        if (regexp.endsWith(SUFFIX_CHAR)) {
            end -= SUFFIX_CHAR.length();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            char c = regexp.charAt(i);
            if (sb != null && Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb != null && sb.length() > result.length()) {
                    result = sb.toString();
                }
                sb = new StringBuilder();
                continue;
            }
            sb = null;
        }
        if (sb != null && sb.toString().length() > result.length()) {
            result = sb.toString();
        }
        return result;
    }

    public static String prepareStepRegexp(String stepName) {
        String result = stepName;
        for (String[] rule : ARR) {
            result = result.replaceAll(rule[0], rule[1]);
        }
        return result;
    }

    public static String processExpressionOrOperator(@NotNull String cucumberExpression) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(13);
        }
        StringBuilder result = new StringBuilder();
        boolean inGroup = false;
        for (int i = 0; i < cucumberExpression.length(); ++i) {
            char c = cucumberExpression.charAt(i);
            if (c == '/') {
                if (!inGroup) {
                    int j;
                    for (j = result.length() - 1; j >= 0 && !Character.isWhitespace(result.charAt(j)); --j) {
                    }
                    result.insert(j + 1, '(');
                    inGroup = true;
                }
                result.append('|');
                continue;
            }
            if (c == '|') {
                result.append("\\|");
                continue;
            }
            if (inGroup && Character.isWhitespace(c)) {
                result.append(')');
                inGroup = false;
            }
            result.append(c);
        }
        if (inGroup) {
            result.append(')');
        }
        return result.toString();
    }

    @NotNull
    public static String buildRegexpFromCucumberExpression(@NotNull String cucumberExpression, @NotNull ParameterTypeManager parameterTypeManager) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(14);
        }
        if (parameterTypeManager == null) {
            CucumberUtil.$$$reportNull$$$0(15);
        }
        cucumberExpression = CucumberUtil.escapeCucumberExpression(cucumberExpression);
        cucumberExpression = CucumberUtil.replaceNotNecessaryTextTemplateByRegexp(cucumberExpression);
        String escapedCucumberExpression = cucumberExpression = CucumberUtil.processExpressionOrOperator(cucumberExpression);
        ArrayList parameterTypeValues = new ArrayList();
        CucumberUtil.processParameterTypesInCucumberExpression(escapedCucumberExpression, (Processor<? super TextRange>)((Processor)range -> {
            String parameterTypeName = escapedCucumberExpression.substring(range.getStartOffset() + 1, range.getEndOffset() - 1);
            String parameterTypeValue = parameterTypeManager.getParameterTypeValue(parameterTypeName);
            parameterTypeValues.add(Pair.create((Object)range, (Object)parameterTypeValue));
            return true;
        }));
        StringBuilder result = new StringBuilder(escapedCucumberExpression);
        Collections.reverse(parameterTypeValues);
        for (Pair rangeAndValue : parameterTypeValues) {
            String value = (String)rangeAndValue.getSecond();
            if (value == null) {
                String string = escapedCucumberExpression;
                if (string == null) {
                    CucumberUtil.$$$reportNull$$$0(16);
                }
                return string;
            }
            int startOffset = ((TextRange)rangeAndValue.first).getStartOffset();
            int endOffset = ((TextRange)rangeAndValue.first).getEndOffset();
            result.replace(startOffset, endOffset, "(" + value + ")");
        }
        result.insert(0, '^');
        result.append('$');
        String string = result.toString();
        if (string == null) {
            CucumberUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static String replaceNotNecessaryTextTemplateByRegexp(@NotNull String cucumberExpression) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(18);
        }
        Matcher matcher = OPTIONAL_PATTERN.matcher(cucumberExpression);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String parameterPart = matcher.group(2);
            if ("\\\\".equals(matcher.group(1))) {
                matcher.appendReplacement(result, "\\\\(" + parameterPart + "\\\\)");
                continue;
            }
            matcher.appendReplacement(result, "(?:" + parameterPart + ")?");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static void processParameterTypesInCucumberExpression(@NotNull String cucumberExpression, @NotNull Processor<? super TextRange> processor) {
        if (cucumberExpression == null) {
            CucumberUtil.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            CucumberUtil.$$$reportNull$$$0(20);
        }
        int i = 0;
        while (i < cucumberExpression.length()) {
            char c = cucumberExpression.charAt(i);
            if (c == '{') {
                char parameterTypeChar;
                int j;
                for (j = i; j < cucumberExpression.length() && (parameterTypeChar = cucumberExpression.charAt(j)) != '}'; ++j) {
                    if (parameterTypeChar != '\\') continue;
                    ++j;
                }
                if (j < cucumberExpression.length()) {
                    processor.process((Object)TextRange.create((int)i, (int)(j + 1)));
                    i = j + 1;
                    continue;
                }
                return;
            }
            if (c == '\\') {
                if (i >= cucumberExpression.length() - 1) {
                    return;
                }
                ++i;
            }
            ++i;
        }
    }

    public static boolean isCucumberExpression(@NotNull String stepDefinitionPattern) {
        if (stepDefinitionPattern == null) {
            CucumberUtil.$$$reportNull$$$0(21);
        }
        if (stepDefinitionPattern.startsWith(PREFIX_CHAR) && stepDefinitionPattern.endsWith(SUFFIX_CHAR)) {
            return false;
        }
        boolean[] containsParameterTypes = new boolean[]{false};
        CucumberUtil.processParameterTypesInCucumberExpression(stepDefinitionPattern, (Processor<? super TextRange>)((Processor)textRange -> {
            if (textRange.getLength() < 2) {
                return true;
            }
            String parameterTypeCandidate = stepDefinitionPattern.substring(textRange.getStartOffset() + 1, textRange.getEndOffset() - 1);
            if (!StringUtil.isNotNegativeNumber((CharSequence)parameterTypeCandidate) && !parameterTypeCandidate.contains(",")) {
                containsParameterTypes[0] = true;
            }
            return true;
        }));
        return containsParameterTypes[0];
    }

    @NotNull
    public static OutlineStepSubstitution substituteTableReferences(String stepName, @Nullable Map<String, String> outlineTableMap) {
        int end;
        int start;
        if (outlineTableMap == null) {
            OutlineStepSubstitution outlineStepSubstitution = new OutlineStepSubstitution(stepName, Collections.emptyList());
            if (outlineStepSubstitution == null) {
                CucumberUtil.$$$reportNull$$$0(22);
            }
            return outlineStepSubstitution;
        }
        ArrayList<Pair> offsets = new ArrayList<Pair>();
        StringBuilder result = new StringBuilder();
        int currentOffset = 0;
        while ((start = stepName.indexOf(60, currentOffset)) >= 0 && (end = stepName.indexOf(62, start)) >= 0) {
            String columnName = stepName.substring(start + 1, end);
            String value = outlineTableMap.get(columnName);
            if (value == null) {
                OutlineStepSubstitution outlineStepSubstitution = new OutlineStepSubstitution(stepName);
                if (outlineStepSubstitution == null) {
                    CucumberUtil.$$$reportNull$$$0(23);
                }
                return outlineStepSubstitution;
            }
            result.append(stepName.subSequence(currentOffset, start));
            int replaceOffset = result.length();
            result.append(value);
            int outlineParameterLength = end - start + 1;
            int valueLength = value.length();
            offsets.add(new Pair((Object)replaceOffset, (Object)(outlineParameterLength - valueLength)));
            currentOffset = end + 1;
        }
        result.append(stepName.subSequence(currentOffset, stepName.length()));
        OutlineStepSubstitution outlineStepSubstitution = new OutlineStepSubstitution(result.toString(), offsets);
        if (outlineStepSubstitution == null) {
            CucumberUtil.$$$reportNull$$$0(24);
        }
        return outlineStepSubstitution;
    }

    public static String escapeCucumberExpression(@NotNull String stepPattern) {
        if (stepPattern == null) {
            CucumberUtil.$$$reportNull$$$0(25);
        }
        return ESCAPE_PATTERN.matcher(stepPattern).replaceAll("\\\\$1");
    }

    static {
        HashMap<String, String> standardParameterTypes = new HashMap<String, String>();
        standardParameterTypes.put("int", "-?\\d+");
        standardParameterTypes.put("float", "-?\\d*[.,]?\\d+");
        standardParameterTypes.put("word", "[^\\s]+");
        standardParameterTypes.put("string", "\"(?:[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\"|'(?:[^'\\\\]*(?:\\\\.[^'\\\\]*)*)'");
        standardParameterTypes.put("", "(.*)");
        STANDARD_PARAMETER_TYPES = Collections.unmodifiableMap(standardParameterTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinitionElement";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveSearchScope";
                break;
            }
            case 6: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cucumberExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypeManager";
                break;
            }
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/CucumberUtil";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinitionPattern";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/CucumberUtil";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRegexpFromCucumberExpression";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTableReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findGherkinReferencesToElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPossibleGherkinElementUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTheBiggestWordToSearchByIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processExpressionOrOperator";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildRegexpFromCucumberExpression";
                break;
            }
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceNotNecessaryTextTemplateByRegexp";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processParameterTypesInCucumberExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isCucumberExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "escapeCucumberExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReferenceCheckingProcessor
    implements TextOccurenceProcessor {
        @NotNull
        private final PsiElement myElementToFind;
        @NotNull
        private final Processor<? super PsiReference> myConsumer;

        private MyReferenceCheckingProcessor(@NotNull PsiElement elementToFind, @NotNull Processor<? super PsiReference> consumer) {
            if (elementToFind == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(1);
            }
            this.myElementToFind = elementToFind;
            this.myConsumer = consumer;
        }

        public boolean execute(@NotNull PsiElement element, int offsetInElement) {
            if (element == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(2);
            }
            PsiElement parent = element.getParent();
            boolean result = this.executeInternal(element);
            if (result && parent != null) {
                return this.executeInternal(parent);
            }
            return result;
        }

        private boolean executeInternal(@NotNull PsiElement referenceOwner) {
            if (referenceOwner == null) {
                MyReferenceCheckingProcessor.$$$reportNull$$$0(3);
            }
            for (PsiReference ref : referenceOwner.getReferences()) {
                if (ref == null || !ref.isReferenceTo(this.myElementToFind) || this.myConsumer.process((Object)ref)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToFind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceOwner";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/cucumber/CucumberUtil$MyReferenceCheckingProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeInternal";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

