/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtilRt;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.DefaultGb;
import org.jetbrains.idea.perforce.perforce.jobs.ErrorReporter;
import org.jetbrains.idea.perforce.perforce.jobs.JobSearchParametersPanel;
import org.jetbrains.idea.perforce.perforce.jobs.JobsMasterDetails;
import org.jetbrains.idea.perforce.perforce.jobs.JobsSearchSpecificator;
import org.jetbrains.idea.perforce.perforce.jobs.JobsWorker;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobSpecification;

public class AddJobToChangeListDialog
extends DialogWrapper {
    private final Project myProject;
    private final JobsWorker myWorker;
    private final PerforceJobSpecification mySpecification;
    private JPanel myMainPanel;
    private JobSearchParametersPanel mySearchParametersPanel;
    private JobsMasterDetails myTable;
    private List<PerforceJob> mySelectedJobs;
    private final P4Connection myConnection;
    private final ConnectionKey myKey;
    private JPanel myResultsPanel;
    private static final String NO_RESULTS = "NO_RESULTS";
    private static final String FOUND_JOBS = "FOUND_JOBS";
    private JComponent myTableComponent;
    private JLabel myLimitExceededLabel;

    public AddJobToChangeListDialog(Project project, boolean canBeParent, JobsWorker worker, PerforceJobSpecification specification, P4Connection connection, ConnectionKey key) {
        super(project, canBeParent);
        this.myProject = project;
        this.myWorker = worker;
        this.mySpecification = specification;
        this.myConnection = connection;
        this.myKey = key;
        this.createUI();
        this.setTitle("Link Job to Changelist");
        this.init();
        this.setOKActionEnabled(this.myTableComponent.isVisible() && !this.myTable.getSelectedJobs().isEmpty());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchParametersPanel.getPreferredFocusTarget();
    }

    protected String getHelpId() {
        return "reference.vcs.perforce.searchJob";
    }

    protected String getDimensionServiceKey() {
        return "org.jetbrains.idea.perforce.perforce.jobs.AddJobToChangeListDialog";
    }

    private void createUI() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = DefaultGb.create();
        ++gb.gridy;
        gb.gridx = 0;
        gb.anchor = 17;
        JLabel paramsLabel = new JLabel("Specify search parameters:");
        paramsLabel.setFont(paramsLabel.getFont().deriveFont(1));
        Insets insets = gb.insets;
        gb.insets = new Insets(2, 2, 7, 2);
        this.myMainPanel.add((Component)paramsLabel, gb);
        gb.insets = insets;
        ++gb.gridy;
        List<String> freeFields = JobsWorker.getFreeFields(this.mySpecification);
        this.mySearchParametersPanel = new JobSearchParametersPanel();
        this.myMainPanel.add((Component)this.mySearchParametersPanel.getComponent(), gb);
        ++gb.gridx;
        gb.anchor = 18;
        JButton searchBtn = new JButton("Search");
        this.myMainPanel.add((Component)searchBtn, gb);
        this.myTable = new JobsMasterDetails(this.myProject);
        this.myResultsPanel = new JPanel(new CardLayout());
        JPanel noResultsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints noResultsGb = DefaultGb.create();
        noResultsGb.anchor = 10;
        noResultsPanel.add((Component)new JLabel("Nothing found"), noResultsGb);
        this.myResultsPanel.add((Component)noResultsPanel, NO_RESULTS);
        this.myTableComponent = this.myTable.createComponent();
        this.myResultsPanel.add((Component)this.myTableComponent, FOUND_JOBS);
        ((CardLayout)this.myResultsPanel.getLayout()).show(this.myResultsPanel, NO_RESULTS);
        gb.gridx = 0;
        ++gb.gridy;
        gb.anchor = 17;
        JLabel resultsLabel = new JLabel("Search results:");
        gb.insets = new Insets(7, 2, 2, 2);
        resultsLabel.setFont(resultsLabel.getFont().deriveFont(1));
        this.myMainPanel.add((Component)resultsLabel, gb);
        this.myLimitExceededLabel = new JLabel();
        this.myLimitExceededLabel.setForeground((Color)JBColor.RED);
        ++gb.gridx;
        gb.insets = new Insets(2, 2, 2, 2);
        this.myMainPanel.add((Component)this.myLimitExceededLabel, gb);
        gb.gridx = 0;
        gb.gridwidth = 2;
        ++gb.gridy;
        gb.fill = 1;
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        gb.anchor = 10;
        this.myMainPanel.add((Component)this.myResultsPanel, gb);
        searchBtn.setMnemonic(KeyStroke.getKeyStroke(83, 512).getKeyCode());
        searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobsSearchSpecificator specificator = AddJobToChangeListDialog.this.mySearchParametersPanel.createSpecificator();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    try {
                        List<PerforceJob> jobs = AddJobToChangeListDialog.this.myWorker.getJobs(AddJobToChangeListDialog.this.mySpecification, specificator, AddJobToChangeListDialog.this.myConnection, AddJobToChangeListDialog.this.myKey);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            AddJobToChangeListDialog.this.myLimitExceededLabel.setText("");
                            if (!jobs.isEmpty()) {
                                ((CardLayout)AddJobToChangeListDialog.this.myResultsPanel.getLayout()).show(AddJobToChangeListDialog.this.myResultsPanel, AddJobToChangeListDialog.FOUND_JOBS);
                            } else {
                                ((CardLayout)AddJobToChangeListDialog.this.myResultsPanel.getLayout()).show(AddJobToChangeListDialog.this.myResultsPanel, AddJobToChangeListDialog.NO_RESULTS);
                            }
                            int maxCount = specificator.getMaxCount();
                            List<PerforceJob> toShow = jobs;
                            if (maxCount > 0 && maxCount < jobs.size()) {
                                toShow = jobs.subList(0, maxCount);
                                AddJobToChangeListDialog.this.myLimitExceededLabel.setText(PerforceBundle.message((String)"perforce.jobs.search.limit.exceeded.warning", (Object[])new Object[]{maxCount}));
                            }
                            AddJobToChangeListDialog.this.myTable.fillTree(toShow, toShow.isEmpty() ? null : toShow.get(0));
                        });
                    }
                    catch (VcsException e1) {
                        String[] params = specificator.addParams(ArrayUtilRt.EMPTY_STRING_ARRAY);
                        StringBuilder sb = new StringBuilder("searching for jobs. Search request: 'p4 jobs ");
                        for (String param : params) {
                            sb.append(param).append(' ');
                        }
                        sb.append("' ");
                        new ErrorReporter(sb.toString()).report(AddJobToChangeListDialog.this.myProject, e1);
                    }
                }, "Searching for jobs", false, AddJobToChangeListDialog.this.myProject);
            }
        });
        this.myTable.setSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AddJobToChangeListDialog.this.setOKActionEnabled(AddJobToChangeListDialog.this.myTableComponent.isVisible() && !AddJobToChangeListDialog.this.myTable.getSelectedJobs().isEmpty());
            }
        });
    }

    protected void doOKAction() {
        this.mySelectedJobs = this.myTable.getSelectedJobs();
        if (!this.mySelectedJobs.isEmpty()) {
            super.doOKAction();
        }
    }

    public List<PerforceJob> getSelectedJobs() {
        return this.mySelectedJobs;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }
}

