/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;

public class PerforceLocalChangeListDecorator
implements ChangeListDecorator {
    private final Project myProject;

    public PerforceLocalChangeListDecorator(Project project) {
        this.myProject = project;
    }

    public void decorateChangeList(LocalChangeList changeList, ColoredTreeCellRenderer cellRenderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (changeList.hasDefaultName()) {
            return;
        }
        Collection collNumbers = PerforceNumberNameSynchronizer.getInstance(this.myProject).getAllNumbers(changeList.getName()).values();
        if (collNumbers.isEmpty()) {
            return;
        }
        String text = " - Perforce #" + StringUtil.join((Iterable)ContainerUtil.sorted((Collection)collNumbers), (String)", ");
        int shelved = PerforceManager.getInstance(this.myProject).getShelf().getShelvedChanges(changeList).size();
        if (shelved > 0) {
            text = text + "; " + shelved + " shelved change" + (shelved > 1 ? "s" : "");
        }
        cellRenderer.append(text, SimpleTextAttributes.GRAY_ATTRIBUTES);
    }
}

