/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.HtmlTagReplaceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlBundle;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceFontTagAction
implements LocalQuickFix {
    @NonNls
    private static final Map<String, String> ourSizesMap = new HashMap<String, String>();

    @NotNull
    public String getName() {
        String string = XmlBundle.message((String)"html.replace.tag.with.css.quickfix.text", (Object[])new Object[]{"font"});
        if (string == null) {
            ReplaceFontTagAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        if ("ReplaceDepracatedTag" == null) {
            ReplaceFontTagAction.$$$reportNull$$$0(1);
        }
        return "ReplaceDepracatedTag";
    }

    private static PsiElement[] generateContainingElements(@NotNull Project project, String tagName) {
        if (project == null) {
            ReplaceFontTagAction.$$$reportNull$$$0(2);
        }
        XmlFile xmlFile = HtmlTagReplaceUtil.genereateXmlFileWithSingleTag(project, "span");
        return HtmlTagReplaceUtil.getXmlNamesFromSingleTagFile(xmlFile);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        if (project == null) {
            ReplaceFontTagAction.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            ReplaceFontTagAction.$$$reportNull$$$0(4);
        }
        for (parent = descriptor.getPsiElement(); !(parent == null || parent instanceof XmlTag && "font".equals(StringUtil.toLowerCase((String)((XmlTag)parent).getLocalName()))); parent = parent.getParent()) {
        }
        if (parent == null) {
            return;
        }
        String name = StringUtil.toLowerCase((String)((XmlTag)parent).getLocalName());
        XmlTag tag = (XmlTag)parent;
        PsiElement[] replacePsiElements = ReplaceFontTagAction.generateContainingElements(project, name);
        int cnt = 0;
        for (PsiElement element : tag.getChildren()) {
            XmlToken token;
            IElementType type;
            if (!(element instanceof XmlToken) || (type = (token = (XmlToken)element).getTokenType()) != XmlTokenType.XML_NAME) continue;
            token.replace(replacePsiElements[cnt++]);
        }
        StringBuilder style = new StringBuilder();
        for (XmlAttribute attribute : tag.getAttributes()) {
            String value;
            if ("face".equals(attribute.getName())) {
                value = attribute.getValue();
                attribute.delete();
                style.append("font-family: ");
                style.append(value);
                style.append("; ");
                continue;
            }
            if ("color".equals(attribute.getName())) {
                value = attribute.getValue();
                attribute.delete();
                style.append("color: ");
                style.append(value);
                style.append("; ");
                continue;
            }
            if (!"size".equals(attribute.getName())) continue;
            value = attribute.getValue();
            attribute.delete();
            if (!ourSizesMap.containsKey(value)) continue;
            style.append("font-size: ");
            style.append(ourSizesMap.get(value));
            style.append("; ");
        }
        if (style.length() != 0) {
            boolean found = false;
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!"style".equals(attribute.getName())) continue;
                found = true;
                attribute.setValue(attribute.getValue() + " " + style.toString());
                break;
            }
            if (!found) {
                tag.setAttribute("style", style.toString());
            }
        }
    }

    static {
        ourSizesMap.put("-3", "59%");
        ourSizesMap.put("-2", "70%");
        ourSizesMap.put("-1", "smaller");
        ourSizesMap.put("+1", "larger");
        ourSizesMap.put("+2", "144%");
        ourSizesMap.put("+3", "172%");
        ourSizesMap.put("1", "xx-small");
        ourSizesMap.put("2", "x-small");
        ourSizesMap.put("3", "small");
        ourSizesMap.put("4", "medium");
        ourSizesMap.put("5", "large");
        ourSizesMap.put("6", "x-large");
        ourSizesMap.put("7", "xx-large");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/htmltagreplace/ReplaceFontTagAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/htmltagreplace/ReplaceFontTagAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateContainingElements";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

