/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.util;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.psi.PuppetLazyProxyLightElement;
import com.intellij.lang.puppet.psi.mixins.PuppetVariableMixin;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PuppetTypesInfoUtil {
    private static final Map<IElementType, String> TYPE_TO_NAME_MAP = PuppetTypesInfoUtil.getTypeToNameMap();

    @Nullable
    public static String getTypeName(PsiElement element) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)element);
        if (TYPE_TO_NAME_MAP.containsKey(type)) {
            return TYPE_TO_NAME_MAP.get(type);
        }
        if (PuppetTokenTypes.VAR_WRAPPER.equals(type)) {
            if (((PuppetVariableMixin)element).isParameter()) {
                return PuppetBundle.message("puppet.type.names.parameter", new Object[0]);
            }
            return PuppetBundle.message("puppet.type.names.variable", new Object[0]);
        }
        if (element instanceof PuppetLazyProxyLightElement) {
            return ((PuppetLazyProxyLightElement)element).getTypeName();
        }
        return null;
    }

    private static Map<IElementType, String> getTypeToNameMap() {
        HashMap<IElementType, String> result = new HashMap<IElementType, String>();
        result.put(PuppetTokenTypes.RESOURCE_INSTANCE_DECLARATION, PuppetBundle.message("puppet.type.names.resource_instance", new Object[0]));
        result.put(PuppetTokenTypes.FUNCTION_DEFINITION, PuppetBundle.message("puppet.type.names.function_definition", new Object[0]));
        result.put(PuppetTokenTypes.CLASS_DEFINITION, PuppetBundle.message("puppet.type.names.class_definition", new Object[0]));
        result.put(PuppetTokenTypes.NAMESPACE_DEFINITION, PuppetBundle.message("puppet.type.names.namespace_definition", new Object[0]));
        result.put(PuppetTokenTypes.TYPE_DEFINITION, PuppetBundle.message("puppet.type.names.resource_definition", new Object[0]));
        return result;
    }
}

