/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi;

import com.intellij.lang.puppet.util.PuppetArrayUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public interface PuppetDataTypes {
    @NonNls
    public static final String RESOURCE_TYPE_NAME = "Resource";
    @NonNls
    public static final String CLASS_TYPE_NAME = "Class";
    @NonNls
    public static final String TYPE_TYPE_NAME = "Type";
    @NonNls
    public static final String VARIANT_TYPE_NAME = "Variant";
    public static final List<String> CORE_DATA_TYPES = ContainerUtil.immutableList((Object[])new String[]{"String", "Integer", "Float", "Numeric", "Boolean", "Array", "Hash", "Regexp", "Undef", "Default", "SemVer", "SemVerRange", "Timespan", "Timestamp", "NotUndef", "Iterator", "Iterable", "Runtime", "Sensitive"});
    public static final List<String> RESOURCE_AND_CLASS_DATATYPES = ContainerUtil.immutableList((Object[])new String[]{"Resource", "Class"});
    public static final List<String> ABSTRACT_DATA_TYPES = ContainerUtil.immutableList((Object[])new String[]{"Scalar", "Collection", "Variant", "Data", "Pattern", "Enum", "Tuple", "Struct", "Optional", "CatalogEntry", "Any", "Callable", "Type"});
    public static final List<String> ALL_DATA_TYPES = PuppetArrayUtil.mergeLists(CORE_DATA_TYPES, RESOURCE_AND_CLASS_DATATYPES, ABSTRACT_DATA_TYPES);
    public static final Set<String> ALL_LOWERCASED_DATA_TYPES = new THashSet((Collection)ContainerUtil.map(ALL_DATA_TYPES, StringUtil::toLowerCase));
}

