/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.ruby;

import com.intellij.lang.puppet.ide.libraries.PuppetLibraryUtil;
import com.intellij.lang.puppet.ide.navigation.plugins.PuppetExtFunctionInfo;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.PuppetRubyPluginsIndex;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class RubyFunctionIndexer
implements DataIndexer<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo, FileContent> {
    private static final Pattern RUBY_ADD_FUNCTION_PATTERN = Pattern.compile("newfunction\\s*\\((?:\"|'|:)([^ ,)\"]+)(?:\"|')?(?:\\)|,)");

    RubyFunctionIndexer() {
    }

    @NotNull
    public Map<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            RubyFunctionIndexer.$$$reportNull$$$0(0);
        }
        HashMap<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo> result = new HashMap<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo>();
        Matcher matcher = RUBY_ADD_FUNCTION_PATTERN.matcher(inputData.getContentAsText());
        while (matcher.find()) {
            String functionName = matcher.group(1);
            if (!PuppetLibraryUtil.isFunctionsStubsFile(inputData.getFile()) && !inputData.getFileName().equals(functionName + ".rb")) continue;
            result.put(new PuppetRubyPluginsIndex.EntryKey(PuppetRubyPluginsIndex.SymbolType.FUNCTION, functionName), new PuppetExtFunctionInfo(inputData.getFile().getUrl(), matcher.start(1), Collections.emptyList()));
        }
        HashMap<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo> hashMap = result;
        if (hashMap == null) {
            RubyFunctionIndexer.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/RubyFunctionIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/RubyFunctionIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

