/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer;

import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebuggerUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\tH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"EDITOR_MARKED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "createSourceFromProvidedContent", "Lcom/intellij/openapi/vfs/VirtualFile;", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "url", "Lcom/intellij/util/Url;", "script", "Lcom/intellij/openapi/util/UserDataHolder;", "getFileTitle", "", "file", "getSourceFile", "source", "setupEditor", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.javascript.debugger"})
public final class SourceMapInspectorKt {
    private static final Key<Boolean> EDITOR_MARKED;

    @Nullable
    public static final VirtualFile getSourceFile(@NotNull Url source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return LocalFileFinder.findFile((String)source.getPath());
    }

    @NotNull
    public static final String getFileTitle(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = JsFileUtil.trimTitle(FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl()));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JsFileUtil.trimTitle(Fil\u2026ome(file.presentableUrl))");
        return string;
    }

    @Nullable
    public static final VirtualFile createSourceFromProvidedContent(@NotNull SourceMap map, @NotNull Url url, @NotNull UserDataHolder script) {
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        int sourceIndex = map.getSourceResolver().getSourceIndex(url);
        String string = map.getSourceResolver().getSourceContent(sourceIndex);
        if (string == null) {
            return null;
        }
        String content = string;
        return ScriptsKt.createVmFile(url, script, content, sourceIndex);
    }

    private static final void setupEditor(EditorEx editor) {
        editor.setRendererMode(true);
        EditorSettings editorSettings = editor.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings, (String)"editor.settings");
        editorSettings.setLineNumbersShown(true);
        XDebuggerUtil.getInstance().disableValueLookup((Editor)editor);
    }

    static {
        Key key = Key.create((String)"marked");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Boolean>(\"marked\")");
        EDITOR_MARKED = key;
    }

    public static final /* synthetic */ void access$setupEditor(EditorEx editor) {
        SourceMapInspectorKt.setupEditor(editor);
    }

    public static final /* synthetic */ Key access$getEDITOR_MARKED$p() {
        return EDITOR_MARKED;
    }
}

