/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.nodejs.NodeDebugConnector;
import com.intellij.javascript.debugger.scripts.DirectoryInfo;
import com.intellij.javascript.debugger.scripts.LazyDirectoryInfo;
import com.intellij.openapi.Disposable;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SingleAlarmKt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseKt;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "root", "Lcom/intellij/javascript/debugger/scripts/DirectoryInfo;", "getRoot", "()Lcom/intellij/javascript/debugger/scripts/DirectoryInfo;", "updateScriptsAlarm", "Lcom/intellij/util/SingleAlarm;", "addScript", "", "script", "Lorg/jetbrains/debugger/Script;", "clear", "doAddScript", "url", "Lcom/intellij/util/Url;", "doRemoveScript", "isEvaluatedOneLineScript", "", "removeScript", "setTreeBuilder", "treeBuilder", "Lcom/intellij/ui/treeStructure/SimpleTreeBuilder;", "suggestRootNode", "intellij.javascript.debugger"})
public final class SourceTabManager {
    @NotNull
    private final DirectoryInfo root;
    private volatile SingleAlarm updateScriptsAlarm;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @NotNull
    public final DirectoryInfo getRoot() {
        return this.root;
    }

    public final void addScript(@NotNull Script script) {
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
            if (this.isEvaluatedOneLineScript(script)) {
                return;
            }
            if (NodeDebugConnector.INSTANCE.isDebugConnectorFile(script.getUrl())) {
                return;
            }
            if (script.getSourceMap() == null) {
                this.doAddScript(script, script.getUrl());
            } else {
                SourceMap sourceMap = script.getSourceMap();
                if (sourceMap == null) {
                    Intrinsics.throwNpe();
                }
                for (Url source : sourceMap.getSources()) {
                    this.doAddScript(script, source);
                }
            }
            SingleAlarm singleAlarm = this.updateScriptsAlarm;
            if (singleAlarm == null) break block6;
            SingleAlarm.cancelAndRequest$default((SingleAlarm)singleAlarm, (boolean)false, (int)1, null);
        }
    }

    private final boolean isEvaluatedOneLineScript(Script script) {
        return script.getSourceMap() == null && Intrinsics.areEqual((Object)"vm", (Object)script.getUrl().getScheme()) && script.getLine() - script.getEndLine() < 2;
    }

    private final void doAddScript(Script script, Url url) {
        this.suggestRootNode(script, url).addChild(script, url);
    }

    private final DirectoryInfo suggestRootNode(Script script, Url url) {
        DirectoryInfo child;
        Object object;
        String rootName = null;
        Icon icon = PlatformIcons.FOLDER_ICON;
        int weight = 5;
        if (script.isWorker()) {
            rootName = "Workers";
        } else if (url.getScheme() == null && !url.isInLocalFileSystem()) {
            rootName = "(no domain)";
        } else if (Intrinsics.areEqual((Object)"vm", (Object)url.getScheme())) {
            rootName = "(evaluated)";
            --weight;
        } else if (!JavaScriptDebugProcessKt.hasWebpackScheme(url) && ScriptManagerBaseKt.isSpecial((Url)url)) {
            rootName = "Libraries";
            icon = PlatformIcons.LIBRARY_ICON;
            ++weight;
        } else {
            return this.root;
        }
        if (!((object = this.root.getChildNameToInfo().get((Object)rootName)) instanceof DirectoryInfo)) {
            object = null;
        }
        if ((child = (DirectoryInfo)object) == null) {
            Url url2 = Urls.newUnparsable((String)rootName);
            Icon icon2 = icon;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"icon");
            child = new LazyDirectoryInfo(rootName, url2, icon2, this.debugProcess, weight);
            ((Map)this.root.getChildNameToInfo()).put(rootName, child);
        }
        return child;
    }

    public final void removeScript(@NotNull Script script) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
            if (this.isEvaluatedOneLineScript(script)) {
                return;
            }
            SourceMap sourceMap = script.getSourceMap();
            if (sourceMap != null) {
                SourceMap sourceMap2 = sourceMap;
                boolean bl = false;
                boolean bl2 = false;
                SourceMap it = sourceMap2;
                boolean bl3 = false;
                for (Url source : it.getSources()) {
                    this.doRemoveScript(script, source);
                }
            }
            this.doRemoveScript(script, script.getUrl());
            SingleAlarm singleAlarm = this.updateScriptsAlarm;
            if (singleAlarm == null) break block3;
            SingleAlarm.cancelAndRequest$default((SingleAlarm)singleAlarm, (boolean)false, (int)1, null);
        }
    }

    private final void doRemoveScript(Script script, Url url) {
        DirectoryInfo directory = this.suggestRootNode(script, url);
        directory.removeChild(url);
        if (directory != this.root && !directory.hasChildren()) {
            this.root.getChildNameToInfo().remove((Object)directory.getName());
        }
    }

    public final void setTreeBuilder(@NotNull SimpleTreeBuilder treeBuilder) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)treeBuilder, (String)"treeBuilder");
            SingleAlarm singleAlarm = this.updateScriptsAlarm = SingleAlarmKt.pooledThreadSingleAlarm((int)500, (Disposable)((Disposable)treeBuilder), (Function0)((Function0)new Function0<Unit>(treeBuilder){
                final /* synthetic */ SimpleTreeBuilder $treeBuilder;

                public final void invoke() {
                    this.$treeBuilder.updateFromRoot(true);
                }
                {
                    this.$treeBuilder = simpleTreeBuilder;
                    super(0);
                }
            }));
            if (singleAlarm == null) break block0;
            SingleAlarm.cancelAndRequest$default((SingleAlarm)singleAlarm, (boolean)false, (int)1, null);
        }
    }

    public final void clear() {
        block0: {
            this.root.getChildNameToInfo().clear();
            SingleAlarm singleAlarm = this.updateScriptsAlarm;
            if (singleAlarm == null) break block0;
            SingleAlarm.cancelAndRequest$default((SingleAlarm)singleAlarm, (boolean)false, (int)1, null);
        }
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public SourceTabManager(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.root = new DirectoryInfo("<root>", Urls.newUnparsable((String)""), null, 4, null);
    }
}

