/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.javascript.debugger.locationResolving.FileUrlMapping;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0011J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00130\u0011J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "", "()V", "fileToUrlMap", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/javascript/debugger/locationResolving/FileUrlMapping;", "urlToFileMap", "", "Lcom/intellij/util/Url;", "findFile", "url", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "finder", "Lkotlin/Function0;", "findUrls", "", "file", "isMappingValid", "", "mapping", "saveMapping", "", "intellij.javascript.debugger"})
public final class JSFileUrlMappings {
    private final Map<Url, FileUrlMapping> urlToFileMap;
    private final MultiMap<VirtualFile, FileUrlMapping> fileToUrlMap;

    @Nullable
    public final VirtualFile findFile(@NotNull Url url, @Nullable String sourceContent, @Nullable Script script, @NotNull Function0<? extends VirtualFile> finder) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(finder, (String)"finder");
        FileUrlMapping cachedValue = this.urlToFileMap.get(url);
        if (cachedValue != null && this.isMappingValid(cachedValue, sourceContent, script)) {
            return cachedValue.getFile();
        }
        VirtualFile file = (VirtualFile)finder.invoke();
        this.saveMapping(url, file, sourceContent, script);
        return file;
    }

    private final void saveMapping(Url url, VirtualFile file, String sourceContent, Script script) {
        FileUrlMapping mapping = new FileUrlMapping(url, file, sourceContent, script);
        if (file != null) {
            Collection collection = this.fileToUrlMap.get((Object)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"fileToUrlMap[file]");
            Collection prevMappingsForFile = collection;
            for (FileUrlMapping prevMapping : prevMappingsForFile) {
                this.urlToFileMap.remove(prevMapping.getUrl());
            }
            this.fileToUrlMap.putValue((Object)file, (Object)mapping);
        }
        this.urlToFileMap.put(url, mapping);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Url> findUrls(@NotNull VirtualFile file, @NotNull Function0<? extends List<? extends Url>> finder) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(finder, (String)"finder");
        if (this.fileToUrlMap.containsKey((Object)file)) {
            void $this$mapTo$iv$iv;
            FileUrlMapping it;
            Iterable $this$filterTo$iv$iv;
            ArrayList cachedMappings = new ArrayList(this.fileToUrlMap.get((Object)file));
            Iterable $this$filter$iv = cachedMappings;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FileUrlMapping)element$iv$iv;
                boolean bl = false;
                FileUrlMapping fileUrlMapping = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileUrlMapping, (String)"it");
                if (!JSFileUrlMappings.isMappingValid$default(this, fileUrlMapping, null, null, 6, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (FileUrlMapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Url url = it.getUrl();
                collection.add(url);
            }
            List result2 = (List)destination$iv$iv;
            $this$map$iv = result2;
            boolean bl = false;
            if (!$this$map$iv.isEmpty()) {
                return result2;
            }
        }
        List urls = (List)finder.invoke();
        Iterable $this$forEach$iv = urls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Url it = (Url)element$iv;
            boolean bl = false;
            this.saveMapping(it, file, null, null);
        }
        return urls;
    }

    private final boolean isMappingValid(FileUrlMapping mapping, String sourceContent, Script script) {
        boolean bl;
        boolean isNewMappingMoreAccurate = sourceContent != null && !mapping.getResolvedWithContent() ? true : (sourceContent == null && mapping.getResolvedWithContent() ? false : script != null && !mapping.getResolvedWithScript());
        if (isNewMappingMoreAccurate) {
            bl = false;
        } else if (mapping.getFile() != null) {
            bl = mapping.getFile().getModificationStamp() == mapping.getFileOrFsModificationStamp() && !FileDocumentManager.getInstance().isFileModified(mapping.getFile());
        } else {
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
            bl = !(virtualFileManager.getStructureModificationCount() != mapping.getFileOrFsModificationStamp() || sourceContent != null && sourceContent.hashCode() != mapping.getContentHashCode() || script != null && script.hashCode() != mapping.getScriptHashCode());
        }
        return bl;
    }

    static /* synthetic */ boolean isMappingValid$default(JSFileUrlMappings jSFileUrlMappings, FileUrlMapping fileUrlMapping, String string, Script script, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            script = null;
        }
        return jSFileUrlMappings.isMappingValid(fileUrlMapping, string, script);
    }

    public JSFileUrlMappings() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap()");
        this.urlToFileMap = concurrentMap;
        MultiMap multiMap = MultiMap.createConcurrentSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.createConcurrentSet()");
        this.fileToUrlMap = multiMap;
    }
}

