/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.table;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.model.OfficeTableSection;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ConditionalPrintExpressionReadHandler;
import org.libreoffice.report.pentaho.parser.table.TableColumnsReadHandler;
import org.libreoffice.report.pentaho.parser.table.TableRowReadHandler;
import org.libreoffice.report.pentaho.parser.table.TableRowsReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TableReadHandler
extends ElementReadHandler {
    private final List<ElementReadHandler> children = new ArrayList<ElementReadHandler>();
    private final Section table = new OfficeTableSection();

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        String enabled = attrs.getValue("http://openoffice.org/2005/report", "visible");
        if (enabled == null || "true".equals(enabled)) {
            this.table.setEnabled(true);
        } else {
            this.table.setEnabled(false);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://openoffice.org/2005/report".equals(uri) && "conditional-print-expression".equals(tagName)) {
            return new ConditionalPrintExpressionReadHandler(this.table);
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(uri)) {
            if ("table-columns".equals(tagName) || "table-header-columns".equals(tagName)) {
                TableColumnsReadHandler columns = new TableColumnsReadHandler();
                this.children.add(columns);
                return columns;
            }
            if ("table-row".equals(tagName)) {
                TableRowReadHandler rowHandler = new TableRowReadHandler();
                this.children.add(rowHandler);
                return rowHandler;
            }
            if ("table-rows".equals(tagName) || "table-header-rows".equals(tagName)) {
                TableRowsReadHandler rowsHandler = new TableRowsReadHandler();
                this.children.add(rowsHandler);
                return rowsHandler;
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.children.size(); ++i) {
            ElementReadHandler handler = this.children.get(i);
            this.table.addNode(handler.getElement());
        }
    }

    @Override
    public Element getElement() {
        return this.table;
    }
}

