/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.model.OfficeGroup;
import org.libreoffice.report.pentaho.model.OfficeGroupInstanceSection;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.DetailRootTableReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.FunctionReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.GroupSectionReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ReportReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.RootTableReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GroupReadHandler
extends ElementReadHandler {
    private GroupSectionReadHandler groupHeader;
    private GroupSectionReadHandler groupFooter;
    private GroupReadHandler childGroup;
    private RootTableReadHandler detailSection;
    private final OfficeGroup group;
    private final OfficeGroupInstanceSection groupInstanceSection;
    private final List<FunctionReadHandler> functionHandlers;
    private final ReportReadHandler rh;

    public GroupReadHandler(ReportReadHandler _rh) {
        this.rh = _rh;
        this.group = new OfficeGroup();
        this.groupInstanceSection = new OfficeGroupInstanceSection();
        this.groupInstanceSection.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
        this.groupInstanceSection.setType("group-instance");
        this.group.addNode(this.groupInstanceSection);
        this.functionHandlers = new ArrayList<FunctionReadHandler>();
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        String sortExpr;
        super.startParsing(attrs);
        String groupExpr = attrs.getValue("http://openoffice.org/2005/report", "group-expression");
        if (groupExpr != null && !"".equals(groupExpr)) {
            FormulaExpression function = new FormulaExpression();
            function.setFormula(groupExpr);
            this.groupInstanceSection.setGroupingExpression(function);
        }
        if ((sortExpr = attrs.getValue("http://openoffice.org/2005/report", "sort-expression")) != null && !"".equals(sortExpr)) {
            this.groupInstanceSection.setSortingExpression(sortExpr);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!"http://openoffice.org/2005/report".equals(uri)) {
            return null;
        }
        if ("function".equals(tagName)) {
            FunctionReadHandler erh = new FunctionReadHandler();
            this.functionHandlers.add(erh);
            return erh;
        }
        if ("group-header".equals(tagName)) {
            this.groupHeader = new GroupSectionReadHandler();
            return this.groupHeader;
        }
        if ("group".equals(tagName)) {
            this.childGroup = new GroupReadHandler(this.rh);
            return this.childGroup;
        }
        if ("detail".equals(tagName)) {
            this.detailSection = new DetailRootTableReadHandler();
            this.rh.setDetail(this.detailSection);
            return this.detailSection;
        }
        if ("group-footer".equals(tagName)) {
            ((Element)((Section)this.rh.getDetail().getElement()).getNode(0)).setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "has-group-footer", "true");
            this.groupFooter = new GroupSectionReadHandler();
            return this.groupFooter;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.functionHandlers.size(); ++i) {
            FunctionReadHandler handler = this.functionHandlers.get(i);
            this.groupInstanceSection.addExpression(handler.getExpression());
        }
        if (this.groupHeader != null) {
            this.groupInstanceSection.addNode(this.groupHeader.getElement());
        }
        Section groupBody = new Section();
        groupBody.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
        groupBody.setType("group-body");
        this.groupInstanceSection.addNode(groupBody);
        if (this.detailSection != null) {
            groupBody.addNode(this.detailSection.getElement());
        } else if (this.childGroup != null) {
            groupBody.addNode(this.childGroup.getElement());
        }
        if (this.groupFooter != null) {
            this.groupInstanceSection.addNode(this.groupFooter.getElement());
        }
    }

    @Override
    public Element getElement() {
        return this.group;
    }
}

