/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IStatusField;

public class StatusLineContributionItem
extends ContributionItem
implements IStatusField {
    private String fText;
    private Image fImage;
    private StatusLineLabel fLabel;

    StatusLineContributionItem(String id) {
        super(id);
    }

    public void setText(String text) {
        this.fText = text;
        if (this.fLabel != null && !this.fLabel.isDisposed()) {
            this.fLabel.setText(this.fText);
        }
    }

    public void setImage(Image image) {
        this.fImage = image;
        if (this.fLabel != null && !this.fLabel.isDisposed()) {
            this.fLabel.setImage(this.fImage);
        }
    }

    public void fill(Composite parent) {
        this.fLabel = new StatusLineLabel(parent, 4);
        this.fLabel.setData((Object)this);
        if (this.fText != null) {
            this.fLabel.setText(this.fText);
        }
    }

    static class StatusLineLabel
    extends CLabel {
        private static int INDENT = 3;
        private Point fFixedSize;

        public StatusLineLabel(Composite parent, int style) {
            super(parent, style);
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            Point extent = gc.textExtent("MMMMMMMMM");
            gc.dispose();
            this.fFixedSize = new Point(extent.x + INDENT * 2, 10);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return this.fFixedSize;
        }
    }
}

