/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.edit;

import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.view.dialog.chord.TGCustomChordManager;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.toolbar.UIToolActionMenuItem;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.toolbar.UIToolCheckableItem;
import org.herac.tuxguitar.util.TGContext;

public class TGEditToolBarSectionBeat
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "beat";
    private UIToolActionMenuItem chordMenu;
    private UIToolCheckableItem text;
    private UIToolCheckableItem strokeUp;
    private UIToolCheckableItem strokeDown;

    public TGEditToolBarSectionBeat(TGEditToolBar toolBar) {
        super(toolBar, SECTION_TITLE);
    }

    public void createSectionToolBars() {
        UIToolBar toolBar = this.createToolBar();
        this.chordMenu = toolBar.createActionMenuItem();
        this.chordMenu.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-chord-dialog"));
        this.text = toolBar.createCheckItem();
        this.text.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-text-dialog"));
        this.strokeUp = toolBar.createCheckItem();
        this.strokeUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-stroke-up-dialog"));
        this.strokeDown = toolBar.createCheckItem();
        this.strokeDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-stroke-down-dialog"));
    }

    public void loadSectionProperties() {
        this.chordMenu.setToolTipText(this.getText("insert.chord"));
        this.text.setToolTipText(this.getText("text.insert"));
        this.strokeUp.setToolTipText(this.getText("beat.stroke-up"));
        this.strokeDown.setToolTipText(this.getText("beat.stroke-down"));
    }

    public void loadSectionIcons() {
        this.chordMenu.setImage(this.getIconManager().getChord());
        this.text.setImage(this.getIconManager().getText());
        this.strokeUp.setImage(this.getIconManager().getStrokeUp());
        this.strokeDown.setImage(this.getIconManager().getStrokeDown());
    }

    public void updateSectionItems() {
        TGBeatImpl beat = this.getTablature().getCaret().getSelectedBeat();
        boolean running = MidiPlayer.getInstance((TGContext)this.getToolBar().getContext()).isRunning();
        this.chordMenu.setEnabled(!running);
        this.text.setEnabled(!running);
        this.text.setChecked(beat.isTextBeat());
        this.strokeUp.setEnabled(!running && !beat.isRestBeat());
        this.strokeUp.setChecked(beat != null && beat.getStroke().getDirection() == 1);
        this.strokeDown.setEnabled(!running && !beat.isRestBeat());
        this.strokeDown.setChecked(beat != null && beat.getStroke().getDirection() == -1);
        this.updateMenuItems();
    }

    public void updateMenuItems() {
        int i;
        TGCustomChordManager customChordManager = TuxGuitar.getInstance().getCustomChordManager();
        UIMenu uiMenu = this.chordMenu.getMenu();
        List uiMenuItems = this.chordMenu.getMenu().getItems();
        for (i = customChordManager.countChords(); i < uiMenuItems.size(); ++i) {
            ((UIMenuItem)uiMenuItems.get(i)).dispose();
        }
        for (i = 0; i < customChordManager.countChords(); ++i) {
            UIMenuItem uiMenuItem;
            TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(i);
            UIMenuItem uIMenuItem = uiMenuItem = uiMenu.getItemCount() > i ? uiMenu.getItem(i) : null;
            if (uiMenuItem == null) {
                UIMenuActionItem uiMenuActionItem = uiMenu.createActionItem();
                uiMenuActionItem.addSelectionListener(new UISelectionListener(){

                    public void onSelect(UISelectionEvent event) {
                        TGEditToolBarSectionBeat.this.processInsertChordAction((TGChord)event.getComponent().getData(TGChord.class.getName()));
                    }
                });
                uiMenuItem = uiMenuActionItem;
            }
            uiMenuItem.setText(chord.getName());
            uiMenuItem.setData(TGChord.class.getName(), (Object)chord);
        }
    }

    public void processInsertChordAction(TGChord chord) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.beat.general.insert-chord");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHORD, chord);
        tgActionProcessor.process();
    }
}

