/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.keybindings;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialog;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialogController;
import org.herac.tuxguitar.app.view.dialog.keybindings.TGKeyBindingEditor;
import org.herac.tuxguitar.app.view.dialog.keybindings.TGKeyBindingSelectorHandler;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIKeyEvent;
import org.herac.tuxguitar.ui.event.UIKeyReleasedListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.resource.UIKeyConvination;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIImageView;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;

public class TGKeyBindingSelector {
    public static final String ATTRIBUTE_EDITOR = TGKeyBindingEditor.class.getName();
    public static final String ATTRIBUTE_KB_ACTION = KeyBindingAction.class.getName();
    private TGKeyBindingEditor editor;
    private KeyBindingAction keyBindingAction;
    private TGKeyBindingSelectorHandler handler;

    public TGKeyBindingSelector(TGKeyBindingEditor editor, KeyBindingAction keyBindingAction, TGKeyBindingSelectorHandler handler) {
        this.editor = editor;
        this.keyBindingAction = keyBindingAction;
        this.handler = handler;
    }

    public void select(UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance(this.editor.getContext().getContext()).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("key-bindings-editor"));
        UITableLayout legendLayout = new UITableLayout();
        UILegendPanel legend = uiFactory.createLegendPanel((UIContainer)dialog);
        legend.setLayout((UILayout)legendLayout);
        legend.setText(TuxGuitar.getProperty(this.keyBindingAction.getAction()));
        dialogLayout.set((UIControl)legend, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = uiFactory.createPanel((UIContainer)legend, false);
        panel.setLayout((UILayout)panelLayout);
        panel.setFocus();
        panel.addKeyReleasedListener(new UIKeyReleasedListener(){

            public void onKeyReleased(UIKeyEvent event) {
                TGKeyBindingSelector.this.handleSelection(event.getKeyConvination());
                dialog.dispose();
            }
        });
        legendLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIImageView iconLabel = uiFactory.createImageView((UIContainer)panel);
        iconLabel.setImage(TGIconManager.getInstance(this.editor.getContext().getContext()).getStatusInfo());
        panelLayout.set((UIControl)iconLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        UILabel textLabel = uiFactory.createLabel((UIContainer)panel);
        textLabel.setText(TuxGuitar.getProperty("key-bindings-editor-push-a-key"));
        panelLayout.set((UIControl)textLabel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        UIFont defaultFont = textLabel.getFont();
        if (defaultFont != null) {
            final UIFont font = uiFactory.createFont(defaultFont.getName(), 14.0f, true, false);
            textLabel.setFont(font);
            textLabel.addDisposeListener(new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    font.dispose();
                }
            });
        }
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonClean = uiFactory.createButton((UIContainer)buttons);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGKeyBindingSelector.this.handleSelection(null);
                dialog.dispose();
            }
        });
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonClean, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public void handleSelection(final UIKeyConvination kb) {
        if (kb == null || kb.equals((Object)this.keyBindingAction.getConvination()) || !this.editor.exists(kb)) {
            this.handler.handleSelection(kb);
        } else {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.editor.getContext().getContext(), "action.gui.open-view");
            tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGConfirmDialogController());
            tgActionProcessor.setAttribute("message", (Object)TuxGuitar.getProperty("key-bindings-editor-override"));
            tgActionProcessor.setAttribute("style", (Object)(TGConfirmDialog.BUTTON_YES | TGConfirmDialog.BUTTON_NO));
            tgActionProcessor.setAttribute("defaultButton", (Object)TGConfirmDialog.BUTTON_NO);
            tgActionProcessor.setAttribute("yesRunnable", (Object)new Runnable(){

                public void run() {
                    TGKeyBindingSelector.this.handler.handleSelection(kb);
                }
            });
            tgActionProcessor.process();
        }
    }
}

