/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordCustomNameChooser;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordCustomNameChooserHandler;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDialog;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIListBoxSelect;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGChordCustomList {
    private static final float MAXIMUM_LIST_PACKED_HEIGHT = 200.0f;
    private TGChordDialog dialog;
    private UIPanel control;
    private UIListBoxSelect<Integer> chords;

    public TGChordCustomList(TGChordDialog dialog, UIContainer parent) {
        this.dialog = dialog;
        this.createControl(parent);
    }

    public void createControl(UIContainer parent) {
        UIFactory uiFactory = this.dialog.getUIFactory();
        UITableLayout layout = new UITableLayout(Float.valueOf(0.0f));
        this.control = uiFactory.createPanel(parent, true);
        this.control.setLayout((UILayout)layout);
        UITableLayout compositeLayout = new UITableLayout();
        UIPanel composite = uiFactory.createPanel((UIContainer)this.control, false);
        composite.setLayout((UILayout)compositeLayout);
        layout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.chords = uiFactory.createListBoxSelect((UIContainer)composite);
        this.chords.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                Integer index = (Integer)TGChordCustomList.this.getChords().getSelectedValue();
                if (index != null && TGChordCustomList.this.getDialog().getEditor() != null) {
                    TGChordCustomList.this.showChord(index);
                }
            }
        });
        compositeLayout.set(this.chords, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        compositeLayout.set(this.chords, "maximum_packed_height", (Object)Float.valueOf(200.0f));
        UITableLayout buttonsLayout = new UITableLayout();
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.control, false);
        buttons.setLayout((UILayout)buttonsLayout);
        layout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        UIButton add = uiFactory.createButton((UIContainer)buttons);
        add.setText(TuxGuitar.getProperty("add"));
        add.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordCustomList.this.addCustomChord();
            }
        });
        buttonsLayout.set((UIControl)add, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        UIButton rename = uiFactory.createButton((UIContainer)buttons);
        rename.setText(TuxGuitar.getProperty("rename"));
        rename.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                Integer index = (Integer)TGChordCustomList.this.getChords().getSelectedValue();
                if (index != null) {
                    TGChordCustomList.this.renameCustomChord(index);
                }
            }
        });
        buttonsLayout.set((UIControl)rename, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        UIButton remove = uiFactory.createButton((UIContainer)buttons);
        remove.setText(TuxGuitar.getProperty("remove"));
        remove.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                Integer index = (Integer)TGChordCustomList.this.getChords().getSelectedValue();
                if (index != null) {
                    TGChordCustomList.this.removeCustomChord(index);
                }
            }
        });
        buttonsLayout.set((UIControl)remove, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        this.loadChords();
    }

    public void loadChords() {
        this.chords.setIgnoreEvents(true);
        Integer selectionIndex = (Integer)this.chords.getSelectedValue();
        if (selectionIndex == null) {
            selectionIndex = 0;
        }
        this.chords.removeItems();
        for (int i = 0; i < TuxGuitar.getInstance().getCustomChordManager().countChords(); ++i) {
            TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(i);
            this.chords.addItem(new UISelectItem(chord.getName(), (Object)i));
        }
        if (selectionIndex >= 0 && selectionIndex < this.chords.getItemCount()) {
            this.chords.setSelectedValue((Object)selectionIndex);
        } else if (selectionIndex > 0 && selectionIndex - 1 < this.chords.getItemCount()) {
            this.chords.setSelectedValue((Object)(selectionIndex - 1));
        }
        this.chords.setIgnoreEvents(false);
    }

    public void showChord(int index) {
        TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(index);
        if (chord != null) {
            this.dialog.getEditor().setChord(chord);
        }
    }

    public void addCustomChord() {
        final TGChord chord = this.dialog.getEditor().getChord();
        if (chord != null) {
            TGChordCustomNameChooser nameChooser = new TGChordCustomNameChooser(this.dialog.getContext().getContext());
            nameChooser.setDefaultName(this.dialog.getEditor().getChordName().getText().trim());
            nameChooser.choose(this.dialog.getWindow(), new TGChordCustomNameChooserHandler(){

                public void onSelectName(String name) {
                    if (name != null) {
                        if (name.length() == 0) {
                            TGMessageDialogUtil.errorMessage(TGChordCustomList.this.getDialog().getContext().getContext(), TGChordCustomList.this.getDialog().getWindow(), TuxGuitar.getProperty("chord.custom.name-empty-error"));
                            return;
                        }
                        if (TuxGuitar.getInstance().getCustomChordManager().existOtherEqualCustomChord(name, -1)) {
                            TGMessageDialogUtil.errorMessage(TGChordCustomList.this.getDialog().getContext().getContext(), TGChordCustomList.this.getDialog().getWindow(), TuxGuitar.getProperty("chord.custom.name-exist-error"));
                            return;
                        }
                        chord.setName(name);
                        TuxGuitar.getInstance().getCustomChordManager().addChord(chord);
                        TGChordCustomList.this.loadChords();
                    }
                }
            });
        }
    }

    public void renameCustomChord(final int index) {
        TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(index);
        if (chord != null) {
            TGChordCustomNameChooser nameChooser = new TGChordCustomNameChooser(this.dialog.getContext().getContext());
            nameChooser.setDefaultName(chord.getName());
            nameChooser.choose(this.dialog.getWindow(), new TGChordCustomNameChooserHandler(){

                public void onSelectName(String name) {
                    if (name != null) {
                        if (name.length() == 0) {
                            TGMessageDialogUtil.errorMessage(TGChordCustomList.this.getDialog().getContext().getContext(), TGChordCustomList.this.getDialog().getWindow(), TuxGuitar.getProperty("chord.custom.name-empty-error"));
                            return;
                        }
                        if (TuxGuitar.getInstance().getCustomChordManager().existOtherEqualCustomChord(name, index)) {
                            TGMessageDialogUtil.errorMessage(TGChordCustomList.this.getDialog().getContext().getContext(), TGChordCustomList.this.getDialog().getWindow(), TuxGuitar.getProperty("chord.custom.name-exist-error"));
                            return;
                        }
                        TuxGuitar.getInstance().getCustomChordManager().renameChord(index, name);
                        TGChordCustomList.this.loadChords();
                    }
                }
            });
        }
    }

    public void removeCustomChord(int index) {
        if (index >= 0 && index < TuxGuitar.getInstance().getCustomChordManager().countChords()) {
            TuxGuitar.getInstance().getCustomChordManager().removeChord(index);
            this.loadChords();
        }
    }

    public TGChordDialog getDialog() {
        return this.dialog;
    }

    public UIPanel getControl() {
        return this.control;
    }

    public UIListBoxSelect<Integer> getChords() {
        return this.chords;
    }
}

