/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.oss;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.impl.midiport.oss.MidiOutputPortImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiSystem {
    private static final String JNI_LIBRARY_NAME = new String("tuxguitar-oss-jni");
    private long instance = this.malloc();
    private boolean open = false;
    private List<MidiOutputPort> ports = new ArrayList<MidiOutputPort>();
    private MidiOutputPortImpl connection = null;

    public void finalize() {
        if (this.instance != 0L) {
            this.free(this.instance);
            this.instance = 0L;
        }
    }

    public boolean isOpen() {
        return this.instance != 0L && this.open;
    }

    public void open(String device) {
        if (this.instance != 0L && !this.open) {
            this.open(this.instance, device);
            this.open = true;
        }
    }

    public void close() {
        if (this.instance != 0L && this.open) {
            this.close(this.instance);
            this.open = false;
        }
    }

    public List<MidiOutputPort> findPorts() {
        this.ports.clear();
        if (this.instance != 0L && this.open) {
            this.findPorts(this.instance);
        }
        return this.ports;
    }

    public void openPort(MidiOutputPortImpl port) {
        if (this.instance != 0L && this.open) {
            this.openPort(this.instance, port.getDevice());
            this.connection = port;
        }
    }

    public void closePort() {
        if (this.instance != 0L && this.open) {
            this.closePort(this.instance);
            this.connection = null;
        }
    }

    public void noteOn(int channel, int note, int velocity) {
        if (this.instance != 0L && this.open) {
            this.noteOn(this.instance, channel, note, velocity);
        }
    }

    public void noteOff(int channel, int note, int velocity) {
        if (this.instance != 0L && this.open) {
            this.noteOff(this.instance, channel, note, velocity);
        }
    }

    public void controlChange(int channel, int control, int value) {
        if (this.instance != 0L && this.open) {
            this.controlChange(this.instance, channel, control, value);
        }
    }

    public void programChange(int channel, int program) {
        if (this.instance != 0L && this.open) {
            this.programChange(this.instance, channel, program);
        }
    }

    public void pitchBend(int channel, int value) {
        if (this.instance != 0L && this.open) {
            this.pitchBend(this.instance, channel, value);
        }
    }

    public MidiOutputPortImpl getConnection() {
        return this.connection;
    }

    protected void addPort(String name, int device) {
        this.ports.add((MidiOutputPort)new MidiOutputPortImpl(this, name, device));
    }

    private native long malloc();

    private native void free(long var1);

    protected native void open(long var1, String var3);

    protected native void close(long var1);

    protected native void findPorts(long var1);

    protected native void openPort(long var1, int var3);

    protected native void closePort(long var1);

    protected native void noteOn(long var1, int var3, int var4, int var5);

    protected native void noteOff(long var1, int var3, int var4, int var5);

    protected native void controlChange(long var1, int var3, int var4, int var5);

    protected native void programChange(long var1, int var3, int var4);

    protected native void pitchBend(long var1, int var3, int var4);

    static {
        System.loadLibrary(JNI_LIBRARY_NAME);
    }
}

