/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.sequencer;

import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.player.base.MidiSequencer;
import org.herac.tuxguitar.player.base.MidiTransmitter;
import org.herac.tuxguitar.player.impl.sequencer.MidiEvent;
import org.herac.tuxguitar.player.impl.sequencer.MidiEventDispacher;
import org.herac.tuxguitar.player.impl.sequencer.MidiEventPlayer;
import org.herac.tuxguitar.player.impl.sequencer.MidiSequenceHandlerImpl;
import org.herac.tuxguitar.player.impl.sequencer.MidiTickPlayer;
import org.herac.tuxguitar.player.impl.sequencer.MidiTrackController;
import org.herac.tuxguitar.thread.TGThreadLoop;
import org.herac.tuxguitar.thread.TGThreadManager;
import org.herac.tuxguitar.util.TGContext;

public class MidiSequencerImpl
implements MidiSequencer {
    private boolean reset;
    private boolean running = false;
    private boolean stopped = true;
    private Object lock;
    private TGContext context;
    private MidiTransmitter transmitter;
    private MidiTickPlayer midiTickPlayer;
    private MidiEventPlayer midiEventPlayer;
    private MidiEventDispacher midiEventDispacher;
    private MidiTrackController midiTrackController;

    public MidiSequencerImpl(TGContext context) {
        this.context = context;
        this.lock = new Object();
        this.midiTickPlayer = new MidiTickPlayer();
        this.midiEventPlayer = new MidiEventPlayer(this);
        this.midiEventDispacher = new MidiEventDispacher(this);
        this.midiTrackController = new MidiTrackController(this);
    }

    public MidiSequenceHandler createSequence(int tracks) throws MidiPlayerException {
        return new MidiSequenceHandlerImpl(this, tracks);
    }

    public void check() {
    }

    public void open() {
    }

    public void close() throws MidiPlayerException {
        if (this.isRunning()) {
            this.stop();
        }
    }

    public void stop() throws MidiPlayerException {
        this.setRunning(false);
    }

    public void start() throws MidiPlayerException {
        this.setRunning(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            this.getTransmitter().sendAllNotesOff();
            this.getTransmitter().sendPitchBendReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(MidiEvent event) throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.reset) {
                this.midiEventDispacher.dispatch(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(MidiEvent event) {
        Object object = this.lock;
        synchronized (object) {
            this.midiEventPlayer.addEvent(event);
            this.midiTickPlayer.notifyTick(event.getTick());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process() throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            boolean running = this.isRunning();
            if (running) {
                if (this.reset) {
                    this.reset();
                    this.reset = false;
                    this.midiEventPlayer.reset();
                }
                this.stopped = false;
                this.midiTickPlayer.process();
                this.midiEventPlayer.process();
                if (this.getTickPosition() > this.getTickLength()) {
                    this.stop();
                }
            } else if (!this.stopped) {
                this.stopped = true;
                this.midiEventPlayer.clearEvents();
                this.midiTickPlayer.clearTick();
                this.reset();
            }
            return running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean running) throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            this.running = running;
            if (this.running) {
                this.setTempo(120);
                this.setTickPosition(this.getTickPosition());
                new MidiTimer(this).start();
            } else {
                this.process();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTempo(int tempo) {
        Object object = this.lock;
        synchronized (object) {
            this.midiTickPlayer.setTempo(tempo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTickPosition(long tickPosition) {
        Object object = this.lock;
        synchronized (object) {
            this.reset = true;
            this.midiTickPlayer.setTick(tickPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSolo(int index, boolean solo) throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            this.getMidiTrackController().setSolo(index, solo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMute(int index, boolean mute) throws MidiPlayerException {
        Object object = this.lock;
        synchronized (object) {
            this.getMidiTrackController().setMute(index, mute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransmitter(MidiTransmitter transmitter) {
        Object object = this.lock;
        synchronized (object) {
            this.transmitter = transmitter;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public MidiTrackController getMidiTrackController() {
        return this.midiTrackController;
    }

    public long getTickPosition() {
        return this.midiTickPlayer.getTick();
    }

    public long getTickLength() {
        return this.midiTickPlayer.getTickLength();
    }

    public MidiTransmitter getTransmitter() {
        return this.transmitter;
    }

    public String getKey() {
        return "tuxguitar.sequencer";
    }

    public String getName() {
        return "TuxGuitar Sequencer";
    }

    public TGContext getContext() {
        return this.context;
    }

    private class MidiTimer
    implements Runnable {
        private static final long TIMER_DELAY = 15L;
        private MidiSequencerImpl sequencer;

        public MidiTimer(MidiSequencerImpl sequencer) {
            this.sequencer = sequencer;
        }

        public void run() {
            TGThreadManager.getInstance(this.sequencer.getContext()).loop(new TGThreadLoop(){

                public Long process() {
                    return MidiTimer.this.processLoop() ? 15L : BREAK;
                }
            });
        }

        public boolean processLoop() {
            try {
                return this.sequencer.process();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return false;
            }
        }

        public void start() {
            TGThreadManager.getInstance(this.sequencer.getContext()).start(this);
        }
    }
}

